/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.project.options.LogoOptions;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.ImageIcon;

public class LogoAdjuster {
    private LogoOptions options = null;
    private ImageIcon builtinLogoIcon_w = null;
    private ImageIcon builtinLogoIcon_b = null;
    private int logoSpaceWidth = 74;
    private int logoSpaceHeight = 39;
    private ImageIcon logoIcon_w = null;
    private int widthOfLogo_w = -1;
    private int heightOfLogo_w = -1;
    private ImageIcon logoIcon_b = null;
    private int widthOfLogo_b = -1;
    private int heightOfLogo_b = -1;

    public LogoAdjuster(LogoOptions options, ImageIcon builtinLogoIcon_w, ImageIcon builtinLogoIcon_b, int logoSpaceWidth, int logoSpaceHeight) {
        this.options = options;
        this.builtinLogoIcon_w = builtinLogoIcon_w;
        this.builtinLogoIcon_b = builtinLogoIcon_b;
        this.logoSpaceWidth = logoSpaceWidth;
        this.logoSpaceHeight = logoSpaceHeight;
        this.adjust();
    }

    public void adjust() {
        this.logoIcon_w = null;
        this.logoIcon_b = null;
        if (this.options == null || !this.options.getUseExternalEnable()) {
            this.logoIcon_w = this.builtinLogoIcon_w;
            this.logoIcon_b = this.builtinLogoIcon_b;
        } else {
            String logoFileName_w = this.options.getExternalFile();
            String logoFileName_b = String.valueOf(FileRW.getNameButExt(logoFileName_w)) + "_b" + (FileRW.getExt(logoFileName_w).equals("") ? "" : "." + FileRW.getExt(logoFileName_w));
            if (new File(logoFileName_w).isFile()) {
                this.logoIcon_w = new ImageIcon(logoFileName_w);
            }
            if (new File(logoFileName_b).isFile()) {
                this.logoIcon_w = new ImageIcon(logoFileName_b);
            }
        }
        if (this.logoIcon_w != null) {
            this.widthOfLogo_w = this.logoIcon_w.getIconWidth();
            this.heightOfLogo_w = this.logoIcon_w.getIconHeight();
            double maxRatio = Math.max((double)this.widthOfLogo_w / (double)this.logoSpaceWidth, (double)this.heightOfLogo_w / (double)this.logoSpaceHeight);
            if (maxRatio > 1.0) {
                this.widthOfLogo_w = (int)((double)this.widthOfLogo_w / maxRatio);
                this.heightOfLogo_w = (int)((double)this.heightOfLogo_w / maxRatio);
            }
        }
        if (this.logoIcon_b != null) {
            this.widthOfLogo_b = this.logoIcon_b.getIconWidth();
            this.heightOfLogo_b = this.logoIcon_b.getIconHeight();
            double maxRatio = Math.max((double)this.widthOfLogo_b / (double)this.logoSpaceWidth, (double)this.heightOfLogo_b / (double)this.logoSpaceHeight);
            if (maxRatio > 1.0) {
                this.widthOfLogo_b = (int)((double)this.widthOfLogo_b / maxRatio);
                this.heightOfLogo_b = (int)((double)this.heightOfLogo_b / maxRatio);
            }
        }
    }

    public void drawOnWhite(Graphics g, int x, int y, ImageObserver observer) {
    }

    public void drawOnBlack(Graphics g, int x, int y, ImageObserver observer) {
        this.draw(g, x, y, observer, true);
    }

    public void draw(Graphics g, int x, int y, ImageObserver observer, boolean blackBackground) {
        if (!blackBackground) {
            if (this.logoIcon_w != null) {
                g.drawImage(this.logoIcon_w.getImage(), x, y, this.widthOfLogo_w, this.heightOfLogo_w, observer);
            }
        } else if (this.logoIcon_b != null) {
            g.drawImage(this.logoIcon_b.getImage(), x, y, this.widthOfLogo_b, this.heightOfLogo_b, observer);
        }
    }

    public ImageIcon getLogo(boolean blackBackground) {
        if (!blackBackground) {
            return this.logoIcon_w;
        }
        return this.logoIcon_b;
    }

    public int getWidth(boolean blackBackground) {
        if (!blackBackground) {
            return this.widthOfLogo_w;
        }
        return this.widthOfLogo_b;
    }

    public int getHeight(boolean blackBackground) {
        if (!blackBackground) {
            return this.heightOfLogo_w;
        }
        return this.heightOfLogo_b;
    }
}

