/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.MonitorTableIx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class MonitorTableColorRenderer {
    private Color notSelectedFgColor = Color.BLACK;
    private Color notSelectedBgColor = Color.WHITE;
    private Color notSelectedOrderedAscFgColor = Color.BLACK;
    private Color notSelectedOrderedAscBgColor = new Color(255, 255, 230);
    private Color notSelectedOrderedDescFgColor = Color.BLACK;
    private Color notSelectedOrderedDescBgColor = new Color(255, 247, 244);
    private Color normalHeaderFgColor = Color.BLACK;
    private Color normalHeaderBgColor = new Color(217, 217, 217);
    private Color normalHeaderAscFgColor = Color.BLACK;
    private Color normalHeaderAscBgColor = new Color(255, 255, 170);
    private Color normalHeaderDescFgColor = Color.BLACK;
    private Color normalHeaderDescBgColor = new Color(255, 224, 213);
    private Color mouseOverHeaderFgColor = Color.BLACK;
    private Color mouseOverHeaderBgColor = new Color(200, 200, 200);
    private Color mouseOverHeaderAscFgColor = Color.BLACK;
    private Color mouseOverHeaderAscBgColor = new Color(255, 255, 140);
    private Color mouseOverHeaderDescFgColor = Color.BLACK;
    private Color mouseOverHeaderDescBgColor = new Color(255, 200, 179);
    private Border normalHeaderBorder = BorderFactory.createEtchedBorder(1);
    private Border mouseOverHeaderBorder = BorderFactory.createRaisedBevelBorder();
    private Font normalHeaderFont;
    private Font mouseOverHeaderFont;

    public void setup(MonitorTableIx monitorTable) {
        ((Component)((Object)monitorTable)).getForeground();
        ((Component)((Object)monitorTable)).getBackground();
        this.normalHeaderFont = ((Component)((Object)monitorTable)).getFont();
        this.mouseOverHeaderFont = new Font(this.normalHeaderFont.getName(), 1, this.normalHeaderFont.getSize());
        CellRenderer cellRenderer = new CellRenderer(monitorTable);
        monitorTable.getTable().setDefaultRenderer(String.class, cellRenderer);
        monitorTable.getTable().setDefaultRenderer(Long.class, cellRenderer);
        monitorTable.getTable().setDefaultRenderer(Integer.class, cellRenderer);
        monitorTable.getTable().setDefaultRenderer(Double.class, cellRenderer);
        monitorTable.getTable().getTableHeader().setDefaultRenderer(new HeaderRenderer(monitorTable));
    }

    private class CellRenderer
    implements TableCellRenderer {
        private MonitorTableIx monitorTable;
        private TableCellRenderer stringCellRenderer;
        private TableCellRenderer longCellRenderer;
        private TableCellRenderer integerCellRenderer;
        private TableCellRenderer doubleCellRenderer;
        private TableCellRenderer renderer;

        public CellRenderer(MonitorTableIx monitorTable) {
            this.monitorTable = monitorTable;
            this.stringCellRenderer = monitorTable.getTable().getDefaultRenderer(String.class);
            this.longCellRenderer = monitorTable.getTable().getDefaultRenderer(Long.class);
            this.integerCellRenderer = monitorTable.getTable().getDefaultRenderer(Integer.class);
            this.doubleCellRenderer = monitorTable.getTable().getDefaultRenderer(Double.class);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer = value instanceof Long ? this.longCellRenderer : (value instanceof Integer ? this.integerCellRenderer : (value instanceof Double ? this.doubleCellRenderer : this.stringCellRenderer));
            Component component = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (this.monitorTable.getOrderColumn() == column) {
                    if (!this.monitorTable.isOrderDescending()) {
                        component.setForeground(MonitorTableColorRenderer.this.notSelectedOrderedAscFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.notSelectedOrderedAscBgColor);
                    } else {
                        component.setForeground(MonitorTableColorRenderer.this.notSelectedOrderedDescFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.notSelectedOrderedDescBgColor);
                    }
                } else {
                    component.setForeground(MonitorTableColorRenderer.this.notSelectedFgColor);
                    component.setBackground(MonitorTableColorRenderer.this.notSelectedBgColor);
                }
            }
            return component;
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        private MonitorTableIx monitorTable;
        private TableCellRenderer renderer;

        public HeaderRenderer(MonitorTableIx monitorTable) {
            this.monitorTable = monitorTable;
            this.renderer = monitorTable.getTable().getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int mouseOverIndex;
            Component component = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JComponent jComponent = null;
            if (component instanceof JComponent) {
                jComponent = (JComponent)component;
            }
            if ((mouseOverIndex = this.monitorTable.getMouseOverColumnHeaderIndex()) != column) {
                if (this.monitorTable.getOrderColumn() == column) {
                    if (!this.monitorTable.isOrderDescending()) {
                        component.setForeground(MonitorTableColorRenderer.this.normalHeaderAscFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.normalHeaderAscBgColor);
                    } else {
                        component.setForeground(MonitorTableColorRenderer.this.normalHeaderDescFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.normalHeaderDescBgColor);
                    }
                } else {
                    component.setForeground(MonitorTableColorRenderer.this.normalHeaderFgColor);
                    component.setBackground(MonitorTableColorRenderer.this.normalHeaderBgColor);
                }
                if (jComponent != null) {
                    jComponent.setBorder(MonitorTableColorRenderer.this.normalHeaderBorder);
                }
                component.setFont(MonitorTableColorRenderer.this.normalHeaderFont);
            } else {
                if (this.monitorTable.getOrderColumn() == column) {
                    if (!this.monitorTable.isOrderDescending()) {
                        component.setForeground(MonitorTableColorRenderer.this.mouseOverHeaderAscFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.mouseOverHeaderAscBgColor);
                    } else {
                        component.setForeground(MonitorTableColorRenderer.this.mouseOverHeaderDescFgColor);
                        component.setBackground(MonitorTableColorRenderer.this.mouseOverHeaderDescBgColor);
                    }
                } else {
                    component.setForeground(MonitorTableColorRenderer.this.mouseOverHeaderFgColor);
                    component.setBackground(MonitorTableColorRenderer.this.mouseOverHeaderBgColor);
                }
                if (jComponent != null) {
                    jComponent.setBorder(MonitorTableColorRenderer.this.mouseOverHeaderBorder);
                }
                component.setFont(MonitorTableColorRenderer.this.mouseOverHeaderFont);
            }
            return component;
        }
    }
}

