/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.graph.C16;
import edu.uml.lgdc.gui.ColorLegend_Ix;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PZADtoColor
implements ColorLegend_Ix {
    private static final int MAX_POLARIZATIONS = 2;
    public static final int MAX_ZENITHS = 3;
    public static final int MAX_DIRECTIONS = 13;
    public static final int MAX_DOPPLERS = 8;
    public static final int MAX_COLORS = 16;
    private static final String PZAD_PATH = new File(CommonConst.getShareResourcesDir(), "PZAD").getPath();
    private final String filename;
    private final String fullFilename;
    private static final Map<String, PZADtoColor> pzadToColors = new HashMap<String, PZADtoColor>(64);
    private final byte[][][][] color;
    private List<Integer> colorIdents = new ArrayList<Integer>();
    private final String[] identName;

    private PZADtoColor(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename == null");
        }
        this.filename = filename;
        this.fullFilename = new File(PZAD_PATH, filename).getPath();
        this.color = new byte[2][3][13][8];
        this.identName = new String[16];
    }

    public static synchronized PZADtoColor get(String filename) {
        PZADtoColor pzadToColor = pzadToColors.get(filename);
        if (pzadToColor == null) {
            pzadToColor = new PZADtoColor(filename);
            try {
                pzadToColor.readTable();
                pzadToColors.put(filename, pzadToColor);
            }
            catch (IOException ex) {
                pzadToColor = null;
                Console.printThreadStackTrace(ex);
            }
        }
        return pzadToColor;
    }

    /*
     * Unable to fully structure code
     */
    private void readTable() throws IOException {
        var1_1 = null;
        var2_3 = null;
        try {
            fr = new FileReader(this.fullFilename);
            try {
                br = new BufferedReader(fr);
                try {
                    numberOfCommentLinesRead = 0;
                    numberOfDataLinesRead = 0;
                    this.colorIdents.clear();
                    this.colorIdents.add(0);
                    this.identName[0] = "NoVal";
                    index = 0;
                    block7: while (true) {
                        if ((line = br.readLine()) == null) {
                            if (numberOfDataLinesRead == 0) {
                                if (numberOfCommentLinesRead == 0) {
                                    throw new IOException("file " + this.fullFilename + " is zero-length");
                                }
                                throw new IOException("file " + this.fullFilename + " contains only comment lines");
                            }
                            break;
                        }
                        if (line.length() < 2 || line.charAt(0) == ';') {
                            ++numberOfCommentLinesRead;
                            continue;
                        }
                        if (++numberOfDataLinesRead == 1) continue;
                        st = new StringTokenizer(line);
                        ident = Integer.parseInt(st.nextToken());
                        this.colorIdents.add(index, ident);
                        this.identName[index++] = new String(st.nextToken());
                        token1 = st.nextToken();
                        token2 = st.nextToken();
                        token3 = st.nextToken();
                        token4 = st.nextToken();
                        i1 = 0;
                        while (true) {
                            if (i1 < token1.length()) ** break;
                            continue block7;
                            i2 = 0;
                            while (i2 < token2.length()) {
                                i3 = 0;
                                while (i3 < token3.length()) {
                                    i4 = 0;
                                    while (i4 < token4.length()) {
                                        polarization = token1.charAt(i1) - 48;
                                        zenith = token2.charAt(i2) - 48;
                                        azimuth = token3.charAt(i3) <= '9' ? token3.charAt(i3) - 48 : token3.charAt(i3) - 97 + 10;
                                        doppler = token4.charAt(i4) - 48;
                                        this.color[polarization][zenith][azimuth][doppler] = (byte)ident;
                                        ++i4;
                                    }
                                    ++i3;
                                }
                                ++i2;
                            }
                            ++i1;
                        }
                        break;
                    }
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
                ** if (fr == null) goto lbl-1000
            }
            catch (Throwable var2_4) {
                if (var1_1 == null) {
                    var1_1 = var2_4;
                } else if (var1_1 != var2_4) {
                    var1_1.addSuppressed(var2_4);
                }
                if (fr != null) {
                    fr.close();
                }
                throw var1_1;
            }
lbl-1000:
            // 1 sources

            {
                fr.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var2_5) {
            if (var1_1 == null) {
                var1_1 = var2_5;
            } else if (var1_1 != var2_5) {
                var1_1.addSuppressed(var2_5);
            }
            throw var1_1;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public byte getColor(int polarization, int zenith, int azimuth, int doppler) {
        return this.color[polarization][zenith][azimuth][doppler];
    }

    public String[] getLegendNames() {
        return this.identName;
    }

    public String getFullFilename() {
        return this.fullFilename;
    }

    @Override
    public Color getColor(int ident) {
        return C16.get(ident);
    }

    @Override
    public String getName(int ident) {
        int i = this.getIndex(ident);
        return i >= 0 ? this.identName[i] : null;
    }

    @Override
    public void putColor(int ident, Color c) {
        C16.put(ident, c);
    }

    @Override
    public void putName(int ident, String s) {
        this.identName[this.getIndex((int)ident)] = s;
    }

    @Override
    public int totalColorIdents() {
        return this.colorIdents.size();
    }

    @Override
    public int getIdent(int index) {
        return this.colorIdents.get(index);
    }

    @Override
    public int getIndex(int ident) {
        int i = 0;
        while (i < this.totalColorIdents()) {
            if (this.colorIdents.get(i) == ident) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.totalColorIdents();
    }
}

