/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.PlayExecutor;
import edu.uml.lgdc.gui.PlayImage;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.project.Console;
import javax.swing.SwingUtilities;

public class PlayThread
extends Thread {
    private boolean stopCondition;
    private PlayExecutor executor;
    private PlayImage image;
    private int millisecPerFrame;
    private final transient MSQueue finished = new MSQueue(1);
    private transient boolean result;
    private final transient Object dummy = new Object();

    public PlayThread(PlayExecutor executor, PlayImage image, int millisecPerFrame) {
        this.executor = executor;
        this.image = image;
        this.millisecPerFrame = millisecPerFrame;
        this.start();
    }

    @Override
    public void run() {
        if (this.image != null) {
            this.image.setPlayMode(true);
        }
        long startTime = System.currentTimeMillis();
        try {
            while (this.moveToNextAndDraw()) {
                if (this.stopCondition) break;
                long nowTime = System.currentTimeMillis();
                if (nowTime < startTime + (long)this.millisecPerFrame) {
                    Thread.sleep(startTime + (long)this.millisecPerFrame - nowTime);
                    nowTime = System.currentTimeMillis();
                }
                startTime = nowTime;
            }
            if (this.image != null) {
                this.image.setPlayMode(false);
            }
            if (!this.stopCondition) {
                this.executor.stopPlay();
            }
        }
        catch (InterruptedException e) {
            Console.showError(e.toString());
        }
    }

    public void stopPlay() {
        this.stopCondition = true;
    }

    public void setMillisecPerFrame(int millisecPerFrame) {
        this.millisecPerFrame = millisecPerFrame;
    }

    private boolean moveToNextAndDraw() throws InterruptedException {
        this.result = false;
        SwingUtilities.invokeLater(new Runnable(){
            private boolean signaled = false;

            @Override
            public void run() {
                try {
                    PlayThread.this.result = PlayThread.this.executor.moveToNextAndDraw();
                    PlayThread.this.finished.post(PlayThread.this.dummy, 0);
                    this.signaled = true;
                }
                catch (InterruptedException e) {
                    Console.showError(e.toString());
                }
            }

            protected void finalize() {
                if (!this.signaled) {
                    try {
                        PlayThread.this.finished.post(PlayThread.this.dummy, 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.signaled = true;
                }
            }
        });
        while (this.finished.pend(500) == null) {
            System.gc();
        }
        return this.result;
    }
}

