/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.constants;

import java.util.HashMap;
import java.util.Map;

public enum DopplerPresentation {
    SINGLE_RANGE(0, "single range"),
    WATERFALL(1, "waterfall");

    private static final Map<Integer, DopplerPresentation> mapById;
    private static final Map<String, DopplerPresentation> mapByName;
    private static String[] names;
    private final int id;
    private final String name;

    static {
        mapById = new HashMap<Integer, DopplerPresentation>();
        mapByName = new HashMap<String, DopplerPresentation>();
        DopplerPresentation[] dopplerPresentationArray = DopplerPresentation.values();
        int n = dopplerPresentationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DopplerPresentation presentation = dopplerPresentationArray[n2];
            if (mapById.put(presentation.getId(), presentation) != null) {
                throw new RuntimeException("Design error: duplicated id, " + presentation.getId());
            }
            if (mapByName.put(presentation.getName(), presentation) != null) {
                throw new RuntimeException("Design error: duplicated name, " + presentation.getName());
            }
            ++n2;
        }
    }

    private DopplerPresentation(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static DopplerPresentation get(int id) {
        return mapById.get(id);
    }

    public static DopplerPresentation get(String name) {
        return mapByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getNames() {
        if (names != null) return names;
        Class<DopplerPresentation> clazz = DopplerPresentation.class;
        synchronized (DopplerPresentation.class) {
            if (names != null) return names;
            String[] tmpNames = new String[DopplerPresentation.values().length];
            DopplerPresentation[] dopplerPresentationArray = DopplerPresentation.values();
            int n = dopplerPresentationArray.length;
            int n2 = 0;
            while (n2 < n) {
                DopplerPresentation presentation = dopplerPresentationArray[n2];
                tmpNames[presentation.ordinal()] = presentation.getName();
                ++n2;
            }
            names = tmpNames;
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }
}

