/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.constants;

import java.util.HashMap;
import java.util.Map;

public enum EchogramAggregativeType {
    ATI_MAX(0, "max"),
    ATI_MIN(1, "min"),
    ATI_MEDIAN(2, "median"),
    ATI_MPA(3, "mpa");

    private static final Map<Integer, EchogramAggregativeType> MAP_INDEX;
    private static final Map<String, EchogramAggregativeType> MAP_NAME;
    private static EchogramAggregativeType[] values;
    private static String[] names;
    private final int index;
    private final String name;

    static {
        MAP_INDEX = new HashMap<Integer, EchogramAggregativeType>();
        MAP_NAME = new HashMap<String, EchogramAggregativeType>();
        EchogramAggregativeType[] echogramAggregativeTypeArray = values = EchogramAggregativeType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            EchogramAggregativeType aggregativeType = echogramAggregativeTypeArray[n2];
            if (aggregativeType.getIndex() < 0 || aggregativeType.getIndex() >= values.length) {
                throw new RuntimeException("Design error: aggregativeType.getIndex() < 0 || aggregativeType.getIndex() >= values.length");
            }
            if (MAP_INDEX.put(aggregativeType.getIndex(), aggregativeType) != null) {
                throw new RuntimeException("Design error: index " + aggregativeType.getIndex() + " is duplicated");
            }
            if (MAP_NAME.put(aggregativeType.getName().toUpperCase(), aggregativeType) != null) {
                throw new RuntimeException("Design error: name " + aggregativeType.getName() + " is duplicated");
            }
            ++n2;
        }
    }

    private EchogramAggregativeType(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static EchogramAggregativeType get(int index) {
        return MAP_INDEX.get(index);
    }

    public static EchogramAggregativeType get(String name) {
        return MAP_NAME.get(name.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getNames() {
        if (names != null) return names;
        Class<EchogramAggregativeType> clazz = EchogramAggregativeType.class;
        synchronized (EchogramAggregativeType.class) {
            if (names != null) return names;
            names = new String[values.length];
            EchogramAggregativeType[] echogramAggregativeTypeArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                EchogramAggregativeType aggregativeType = echogramAggregativeTypeArray[n2];
                EchogramAggregativeType.names[aggregativeType.getIndex()] = aggregativeType.getName();
                ++n2;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }

    public static int getQty() {
        return values.length;
    }
}

