/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.gui.dialogs.ThreeBtnMsgWin;
import edu.uml.lgdc.gui.dialogs.WarningMsg;
import java.io.File;

public class CommonDialogs {
    public static final int FILE_EXISTS_OVERWRITE = 0;
    public static final int FILE_EXISTS_TRY_ANOTHER = 1;
    public static final int FILE_EXISTS_CANCEL = 2;
    public static final int FILE_EXISTS = 0;
    public static final int FILE_DOES_NOT_EXIST_TRY_ANOTHER = 1;
    public static final int FILE_DOES_NOT_EXIST_ACCEPT_ANYWAY = 2;
    public static final int FILE_DOES_NOT_EXIST_CANCEL = 3;

    public static int askFileOverwrite(String filename, boolean deleteIfOverwrite) {
        File file = new File(filename);
        if (!file.exists()) {
            return 0;
        }
        int answer = 1;
        ThreeBtnMsgWin mesW = new ThreeBtnMsgWin(null, "WARNING window", true, "File " + filename + " already exists");
        mesW.setYesButtonText("Overwrite");
        mesW.setNoButtonText("Try another");
        mesW.setVisible(true);
        if (mesW.getExitCode() == 0) {
            answer = 0;
        } else if (mesW.getExitCode() == 2) {
            answer = 2;
        }
        if (answer == 0 && deleteIfOverwrite && !file.delete()) {
            new WarningMsg("Can not delete file " + filename, 4);
            answer = 1;
        }
        return answer;
    }

    public static int askOpenFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return 0;
        }
        int answer = 1;
        ThreeBtnMsgWin mesW = new ThreeBtnMsgWin(null, "WARNING window", true, "File " + filename + " does not exist");
        mesW.setYesButtonText("Try another");
        mesW.setNoButtonText("Accept anyway");
        mesW.setCancelButtonText("Cancel");
        mesW.setVisible(true);
        answer = mesW.getExitCode() == 0 ? 1 : (mesW.getExitCode() == 1 ? 2 : 3);
        return answer;
    }
}

