/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import edu.uml.lgdc.gui.panels.FileCacheSettingsPanel;
import edu.uml.lgdc.gui.settings.FileCacheSettings_Ix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FileCacheSettingsDialog
extends JDialog {
    boolean ok = false;
    private KeyEventDispatcher keyEventDispatcher;
    private BorderLayout borderLayout = new BorderLayout();
    private FlowLayout pnlOK_CancelLayout = new FlowLayout(1, 40, 5);
    private Border borderPnlOK_Cancel = BorderFactory.createBevelBorder(0);
    private FileCacheSettingsPanel pnlOptions = new FileCacheSettingsPanel();
    private JPanel pnlOK_Cancel = new JPanel();
    private JButton btnOK = new JButton("OK");
    private JButton btnCancel = new JButton("Cancel");

    public FileCacheSettingsDialog() {
        this((Frame)null);
    }

    public FileCacheSettingsDialog(Frame frame) {
        this(frame, (FileCacheSettingsPanel)null);
    }

    public FileCacheSettingsDialog(Frame frame, FileCacheSettingsPanel pnlOptions) {
        this(frame, pnlOptions, "Cache Options");
    }

    public FileCacheSettingsDialog(Frame frame, FileCacheSettingsPanel pnlOptions, String title) {
        super(frame, title, true);
        if (pnlOptions != null) {
            this.pnlOptions = pnlOptions;
        }
        this.guiInit();
        this.pack();
        Draw.centerPosition(this, frame);
        this.keyEventDispatcher = new KeyboardEventDispatcher(this, true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        this.requestFocus();
    }

    private void guiInit() {
        this.pnlOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheSettingsDialog.this.pnlOptions_actionPerformed(e);
            }
        });
        this.btnOK.setToolTipText("<HTML>Accept changes and close window, <b>Ctrl-Enter</b></HTML>");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheSettingsDialog.this.btnOK_actionPerformed(e);
            }
        });
        this.btnOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                FileCacheSettingsDialog.this.btnOK_keyTyped(e);
            }
        });
        this.btnCancel.setToolTipText("<HTML>Cancel changes and close window, <b>Esc</b></HTML>");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheSettingsDialog.this.btnCancel_actionPerformed(e);
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                FileCacheSettingsDialog.this.btnCancel_keyTyped(e);
            }
        });
        this.pnlOK_Cancel.setBorder(this.borderPnlOK_Cancel);
        this.pnlOK_Cancel.setLayout(this.pnlOK_CancelLayout);
        this.pnlOK_Cancel.add((Component)this.btnOK, null);
        this.pnlOK_Cancel.add((Component)this.btnCancel, null);
        this.getContentPane().setLayout(this.borderLayout);
        this.getContentPane().add((Component)this.pnlOptions, "Center");
        this.getContentPane().add((Component)this.pnlOK_Cancel, "South");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                FileCacheSettingsDialog.this.keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                FileCacheSettingsDialog.this.keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FileCacheSettingsDialog.this.keyReleased(e);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.ok = false;
        }
        super.setVisible(visible);
    }

    @Override
    public void requestFocus() {
        this.pnlOptions.requestFocus();
    }

    public void setFields(FileCacheSettings_Ix options) {
        this.pnlOptions.setFields(options);
    }

    public FileCacheSettingsPanel getPanel() {
        return this.pnlOptions;
    }

    public FileCacheSettings_Ix getOptions() {
        return this.pnlOptions.getOptions();
    }

    public boolean isAccepted() {
        return this.ok;
    }

    private void accept() {
        this.pnlOptions.accept();
        this.exit(true);
    }

    private void cancel() {
        this.pnlOptions.reset();
        this.exit(false);
    }

    private void exit(boolean ok) {
        this.ok = ok;
        this.setVisible(false);
    }

    private void btnOK_actionPerformed(ActionEvent e) {
        this.accept();
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    private void pnlOptions_actionPerformed(ActionEvent e) {
        this.accept();
    }

    private void btnOK_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.accept();
        }
    }

    private void btnCancel_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.cancel();
        }
    }

    private void keyTyped(KeyEvent e) {
    }

    private void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (keyCode == 27 && modifiers == 0 || keyCode == 115 && modifiers == 512) {
            this.cancel();
            e.consume();
        } else if (keyCode == 10 && modifiers == 128) {
            if (this.btnOK.isVisible() && this.btnOK.isEnabled()) {
                this.accept();
            }
            e.consume();
        }
    }

    private void keyReleased(KeyEvent e) {
    }

    protected void finalize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }
}

