/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.format.C;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.KeyPressedAware;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Closeable;
import javax.swing.JDialog;

public abstract class SimpleDialog
extends JDialog
implements Closeable,
KeyPressedAware {
    private static final int MIN_FRAME_WIDTH = 100;
    private static final int MIN_FRAME_HEIGHT = 100;
    protected Rectangle rectangle;
    protected BorderLayout borderLayout1 = new BorderLayout();
    private EventEnabledPanel panel;
    private KeyEventDispatcher keyEventDispatcher;
    private boolean redispatchEscape;

    public SimpleDialog(Frame frame, boolean modal) {
        this(frame, modal, false);
    }

    public SimpleDialog(Frame frame, boolean modal, boolean redispatchEscape) {
        super(frame, modal);
        this.redispatchEscape = redispatchEscape;
        this.enableEvents(64L);
        this.jbInit();
        this.init();
    }

    protected void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    protected void setPanel(EventEnabledPanel panel) {
        this.panel = panel;
    }

    private void jbInit() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SimpleDialog.this.keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SimpleDialog.this.keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SimpleDialog.this.keyReleased(e);
            }
        });
    }

    public void saveSizeAndPos() {
        if (this.rectangle != null) {
            this.rectangle.setRect(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    public void close() {
        if (this.panel != null) {
            this.panel.close();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.panel != null) {
            this.panel.keyTyped(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (this.redispatchEscape && keyCode == 27 && modifiers == 0 || keyCode == 115 && modifiers == 512) {
            e.consume();
            this.close();
            this.setVisible(false);
        } else if (this.panel != null) {
            this.panel.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.panel != null) {
            this.panel.keyReleased(e);
        }
    }

    public boolean cleanup() {
        this.saveSizeAndPos();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        this.close();
        return true;
    }

    protected void setSizeAndPos() {
        this.setSizeAndPos(null);
    }

    protected void setSizeAndPos(Dimension size) {
        if (this.rectangle == null) {
            return;
        }
        if (this.rectangle.width < 0) {
            if (size == null) {
                this.pack();
                size = this.getSize();
            } else {
                this.setSize(size);
            }
            Dimension mainMonitorScrSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (size.width < mainMonitorScrSize.width && size.height < mainMonitorScrSize.height) {
                Draw.centerPosition(this);
            } else {
                this.setLocation(0, 0);
            }
        } else {
            this.correctWinSize(this.rectangle);
            this.setSize(this.rectangle.width, this.rectangle.height);
            this.setLocation(this.rectangle.x, this.rectangle.y);
        }
    }

    private void init() {
        this.keyEventDispatcher = new KeyboardEventDispatcher(this, this.redispatchEscape);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    protected void correctWinSize(Rectangle rectangle) {
        Rectangle scr = C.getVirtScrSize();
        if (rectangle.width < 100) {
            rectangle.width = 100;
        } else if (rectangle.width > scr.width) {
            rectangle.width = scr.width;
        }
        if (rectangle.x + rectangle.width < scr.x + 100) {
            rectangle.x = scr.x;
        } else if (rectangle.x > scr.x + scr.width - 100) {
            rectangle.x = scr.x + scr.width - rectangle.width;
        }
        if (rectangle.height < 100) {
            rectangle.height = 100;
        } else if (rectangle.height > scr.height) {
            rectangle.height = scr.height;
        }
        if (rectangle.y + rectangle.height < scr.y + 100) {
            rectangle.y = scr.y;
        } else if (rectangle.y > scr.y + scr.height - 100) {
            rectangle.y = scr.y + scr.height - rectangle.height;
        }
    }
}

