/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.editors;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.graph.Draw;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FlexListEditor
extends JDialog {
    private static final int NO_VALUE = Integer.MIN_VALUE;
    private static final String TITLE = "Flexible List of freqs, in kHz. Total count = ";
    private static final String STUMP = "";
    private DefaultTableModel tableModel;
    private JTable table = null;
    private JScrollPane spTable = new JScrollPane(20, 30);
    public static final int ERR_NO_VALUE_WAS_SET = 1;
    public static final int ERR_ILLEGAL_SYMBOLS = 2;

    public FlexListEditor() {
        this((Frame)null);
    }

    public FlexListEditor(Frame owner) {
        this(owner, (int[])null);
    }

    public FlexListEditor(Frame owner, int[] intValues) {
        super(owner, TITLE + (intValues == null ? 0 : intValues.length), true);
        this.jbInit();
        this.setIntegerValues(intValues);
        this.pack();
        Draw.centerPosition(this, owner);
        this.table.requestFocus();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.tableModel.getRowCount() > 0 && this.table.getSelectedRow() < 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        super.setVisible(visible);
    }

    private void jbInit() {
        this.table = new JTable();
        this.tableModel = (DefaultTableModel)this.table.getModel();
        this.tableModel.setColumnCount(1);
        this.table.setRowHeight(25);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FlexListEditor.this.table_keyPressed(e);
            }
        });
        this.spTable.getViewport().setView(this.table);
        this.getContentPane().add((Component)this.spTable, "Center");
    }

    public void setIntegerValues(int[] values) {
        Object[][] data = new Object[1][1];
        Object[] columns = new Object[]{"List Entries, one per row"};
        if (values != null) {
            data = new Object[values.length][1];
            int i = 0;
            while (i < values.length) {
                data[i][0] = STUMP + values[i];
                ++i;
            }
        }
        this.tableModel.setDataVector(data, columns);
        this.showInfo();
    }

    private void showInfo() {
        this.setTitle(TITLE + this.table.getRowCount());
    }

    public void clear() {
        this.tableModel.setDataVector(new Object[0][], new String[]{"List Entries, one per row"});
        this.tableModel.addRow(new Object[]{STUMP});
    }

    public int getNumberOfItems() {
        return this.getIntegerArray().length;
    }

    private int getIntegerValue(int index) {
        return FC.StringToInteger((String)this.table.getValueAt(index, 0), -1, Integer.MIN_VALUE);
    }

    public int[] getIntegerArray() {
        int[] flexListValues = null;
        int totalInTable = this.table.getRowCount();
        if (totalInTable > 0) {
            int countNotEmpty = 0;
            int i = 0;
            while (i < totalInTable) {
                if (this.getIntegerValue(i) > 0) {
                    ++countNotEmpty;
                }
                ++i;
            }
            flexListValues = new int[countNotEmpty];
            int index = 0;
            int i2 = 0;
            while (i2 < totalInTable) {
                int value = this.getIntegerValue(i2);
                if (value != Integer.MIN_VALUE) {
                    flexListValues[index++] = value;
                }
                ++i2;
            }
        }
        return flexListValues;
    }

    public void table_keyPressed(KeyEvent e) {
        boolean redrawTitle = true;
        switch (e.getKeyCode()) {
            case 40: {
                if (this.table.getSelectedRow() < this.table.getRowCount() - 1) break;
                this.tableModel.addRow(new Object[]{STUMP});
                int addRowIndex = this.table.getRowCount() - 1;
                this.table.setRowSelectionInterval(addRowIndex, addRowIndex);
                break;
            }
            case 155: {
                if (this.table.getSelectedRow() < this.table.getRowCount()) {
                    int addRowIndex = this.table.getSelectedRow();
                    this.tableModel.insertRow(addRowIndex, new Object[]{STUMP});
                    this.table.setRowSelectionInterval(addRowIndex, addRowIndex);
                }
                e.consume();
                break;
            }
            case 127: {
                int selectedRow = this.table.getSelectedRow();
                this.tableModel.removeRow(selectedRow);
                if (this.table.getRowCount() == 0) {
                    this.tableModel.addRow(new Object[]{STUMP});
                }
                if (selectedRow > this.table.getRowCount() - 1) {
                    --selectedRow;
                }
                this.table.setRowSelectionInterval(selectedRow, selectedRow);
                e.consume();
                break;
            }
            default: {
                redrawTitle = false;
            }
        }
        if (redrawTitle) {
            this.showInfo();
        }
    }
}

