/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.frames;

import edu.uml.lgdc.gui.frames.SingleFrame;
import edu.uml.lgdc.gui.panels.AppInfoPanel;
import edu.uml.lgdc.project.LogTail;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AppInfoFrame
extends SingleFrame {
    private static final int DEFAULT_FRAME_WIDTH = 700;
    private static final int DEFAULT_FRAME_HEIGHT = 300;
    private final AppInfoPanel infoPanel;
    private final JPanel pnlControl = new JPanel();
    private final JButton btnClose = new JButton("Close");

    public AppInfoFrame() {
        this(new Rectangle(0, 0, -1, -1), null);
    }

    public AppInfoFrame(Rectangle rectangle, LogTail logTail) {
        super(true);
        this.infoPanel = new AppInfoPanel(logTail);
        this.setPanel(this.infoPanel);
        this.guiInit();
        this.setRectangle(rectangle);
        this.setSizeAndPos(new Dimension(700, 300));
        this.setVisible(true);
    }

    private void guiInit() {
        this.setTitle("Application information and statistics");
        this.btnClose.setToolTipText("<HTML>Close this window, <b>Esc</b></HTML>");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppInfoFrame.this.setVisible(false);
            }
        });
        this.pnlControl.add(this.btnClose);
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.infoPanel, "Center");
        this.getContentPane().add((Component)this.pnlControl, "South");
    }

    public void refresh() {
        this.infoPanel.refresh();
    }

    public AppInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (e.isConsumed()) {
            return;
        }
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (modifiers == 128 && keyCode == 34) {
            this.infoPanel.moveToNextTab();
            e.consume();
        } else if (modifiers == 128 && keyCode == 33) {
            this.infoPanel.moveToPrevTab();
            e.consume();
        } else if (modifiers == 128 && keyCode == 81) {
            e.consume();
            this.infoPanel.moveToNextTab();
        } else if (modifiers == 192 && keyCode == 81) {
            e.consume();
            this.infoPanel.moveToPrevTab();
        } else if (modifiers == 0) {
            if (keyCode == 39 || keyCode == 227) {
                e.consume();
                this.infoPanel.moveToNextTab();
            } else if (keyCode == 37 || keyCode == 226) {
                e.consume();
                this.infoPanel.moveToPrevTab();
            }
        }
        if (!e.isConsumed()) {
            this.infoPanel.keyPressed(e);
        }
    }
}

