/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.frames;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.time.TimeScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class WaitWindow
extends JFrame
implements Runnable {
    public static final int ACT_BTN_NONE = 0;
    public static final int ACT_BTN_STOP = 1;
    private static final int REPEAT_DELAY = 1;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 100;
    private static final String TITLE_START = "remain - ";
    private static final String UNKNOWN = "UNKNOWN";
    private boolean automode = false;
    private int maxAutoCount;
    private int autoCount;
    private String titleStart = "remain - ";
    private TimeScale start;
    private TimeScale now;
    private int progressBarValue = 100;
    private int prevProgressBarValue = -1;
    private boolean stopCondition;
    private boolean showTimeInTitle = true;
    private Thread thread;
    public int action = 0;
    private JPanel pnlMain = new JPanel();
    private JPanel pnlText = new JPanel();
    private JPanel pnlProgBar = new JPanel();
    private JLabel lblText = new JLabel();
    private BorderLayout borderLayoutProgBar = new BorderLayout();
    private BorderLayout borderLayoutText = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JProgressBar progressBar = new JProgressBar();
    private JPanel pnlPercent = new JPanel(new FlowLayout(1));
    private JLabel lblPercent = new JLabel("0");
    private JPanel pnlPadEast = new JPanel();
    private JPanel pnlPadWest = new JPanel();
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel pnlPadSouth = new JPanel();
    private JPanel pnlPadNorth = new JPanel();
    private JPanel pnlControl = new JPanel();
    private JButton btnStop = new JButton();

    public WaitWindow(Frame frame, String text) {
        this(frame, text, 0, true);
    }

    public WaitWindow(Frame frame, String text, boolean showTimeInTitle) {
        this(frame, text, 0, showTimeInTitle);
    }

    public WaitWindow(Frame frame, String text, int buttons, boolean showTimeInTitle) {
        this.showTimeInTitle = showTimeInTitle;
        this.automode = false;
        this.stopCondition = false;
        this.guiInit();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.lblText.setText(text);
        this.setTitle(String.valueOf(this.titleStart) + UNKNOWN);
        this.start = new TimeScale();
        if (buttons != 0) {
            if (buttons == 1) {
                this.btnStop.setText("Stop");
                this.btnStop.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WaitWindow.this.btnStop_actionPerformed(e);
                    }
                });
                this.pnlControl.add((Component)this.btnStop, null);
            }
            this.getContentPane().add((Component)this.pnlControl, "South");
        }
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.width + 40, size.height);
        this.setSize(size);
        Draw.centerPosition(this, frame);
        this.toFront();
    }

    private void guiInit() {
        this.lblText.setText("title");
        this.lblText.setHorizontalAlignment(0);
        this.lblText.setFont(new Font("Dialog", 1, 18));
        this.pnlText.setLayout(this.borderLayoutText);
        this.pnlText.add((Component)this.lblText, "Center");
        this.pnlPadEast.setPreferredSize(new Dimension(10, 8));
        this.pnlPadWest.setPreferredSize(new Dimension(10, 8));
        this.pnlPercent.add(this.lblPercent);
        this.pnlProgBar.setLayout(this.borderLayoutProgBar);
        this.pnlProgBar.add((Component)this.progressBar, "Center");
        this.pnlProgBar.add((Component)this.pnlPadEast, "East");
        this.pnlProgBar.add((Component)this.pnlPadWest, "West");
        this.pnlProgBar.add((Component)this.pnlPadSouth, "South");
        this.pnlProgBar.add((Component)this.pnlPadNorth, "North");
        this.pnlMain.setLayout(this.borderLayoutMain);
        this.pnlMain.add((Component)this.pnlText, "Center");
        this.pnlMain.add((Component)this.pnlProgBar, "South");
        this.getContentPane().setLayout(this.borderLayout4);
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.setDefaultCloseOperation(0);
        this.setTitle(this.titleStart);
        this.setCursor(new Cursor(3));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.prevProgressBarValue = -1;
            this.stopCondition = false;
            this.setTitle(String.valueOf(this.titleStart) + UNKNOWN);
            this.start = new TimeScale();
            if (this.automode && this.thread == null) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }

    @Override
    public void run() {
        this.prevProgressBarValue = -1;
        do {
            if (this.automode) {
                this.setProgressBarValue((double)this.autoCount / (double)this.maxAutoCount);
                this.autoCount = this.autoCount == this.maxAutoCount ? 0 : ++this.autoCount;
            }
            if (this.progressBarValue != this.prevProgressBarValue) {
                this.prevProgressBarValue = this.progressBarValue;
                if (this.progressBarValue > 0 && !this.automode && this.showTimeInTitle) {
                    this.showTimeInTitle();
                }
                this.progressBar.setValue(this.progressBarValue);
                this.update(this.getGraphics());
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.isStoped());
    }

    @Override
    public void dispose() {
        this.stopDisplay();
        super.dispose();
    }

    public void stopDisplay() {
        this.progressBarValue = 100;
        if (this.automode && this.thread != null) {
            this.stopIt();
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }
        super.setVisible(false);
    }

    public String getText() {
        return this.lblText.getText();
    }

    public void setText(String text) {
        this.lblText.setText(text);
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g);
        }
    }

    public synchronized boolean isStoped() {
        return this.stopCondition;
    }

    public void setProgressBarValue(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.progressBarValue = (int)Math.round(value * 100.0);
        if (!this.automode && this.progressBarValue != this.prevProgressBarValue) {
            this.prevProgressBarValue = this.progressBarValue;
            if (this.progressBarValue > 0 && this.showTimeInTitle) {
                this.showTimeInTitle();
            }
            this.progressBar.setValue(this.progressBarValue);
            this.update(this.getGraphics());
        }
    }

    private void showTimeInTitle() {
        this.now = new TimeScale();
        long elapsed = (this.now.getTimeInMilliSeconds() - this.start.getTimeInMilliSeconds()) * (long)(100 - this.progressBarValue + 1) / (long)this.progressBarValue;
        this.setTitle(String.valueOf(this.titleStart) + TimeScale.millisToHHMMSS(elapsed));
    }

    public void setAutomode(int time_sec) {
        this.automode = true;
        this.maxAutoCount = time_sec * 1000 / 1;
        this.autoCount = 0;
    }

    public void setTitleStart(String titleStart) {
        this.titleStart = titleStart;
    }

    public void clearAutomode() {
        this.automode = false;
    }

    public boolean isWorking() {
        return this.thread != null && this.thread.isAlive();
    }

    private void btnStop_actionPerformed(ActionEvent e) {
        this.action = 1;
    }

    private void stopIt() {
        this.stopCondition = true;
    }
}

