/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JavaConsole
extends JPanel {
    private static final String LOG_EXT = ".log";
    private static final int PIPE_BUFFER_SIZE = 8192;
    private static final int IDEAL_SIZE = 1000000;
    private static final int MAX_EXCESS = 100000;
    private static final Color OUT_COLOR = new Color(60, 150, 80);
    private static final Color ADIEU_OUT_COLOR = new Color(0, 0, 180);
    private static final Color ERR_COLOR = Color.red;
    private static final Color ADIEU_ERR_COLOR = new Color(180, 0, 180);
    private String logFilename;
    private boolean append;
    private PipedInputStream piOut;
    private PipedInputStream piErr;
    private PipedOutputStreamN21 poOut;
    private PipedOutputStreamN21 poErr;
    private BorderLayout borderLayout = new BorderLayout();
    private DefaultStyledDocument doc = new DefaultStyledDocument();
    private JTextPane textPane = new JTextPane(this.doc);
    private JScrollPane scrollPane;
    private FileRW logFileRW;
    private final Object syncTextOperations = new Object();
    private final Object syncLogFile = new Object();

    public JavaConsole() throws IOException {
        this(new File(CommonConst.getUserDir(), String.valueOf(CommonConst.getApplicationName()) + LOG_EXT).getPath());
    }

    public JavaConsole(boolean append) throws IOException {
        this(new File(CommonConst.getUserDir(), String.valueOf(CommonConst.getApplicationName()) + LOG_EXT).getPath(), append);
    }

    public JavaConsole(String logFilename) throws IOException {
        this(logFilename, false);
    }

    public JavaConsole(String logFilename, boolean append) throws IOException {
        this.logFilename = logFilename;
        this.append = append;
        this.textPane.setEditable(false);
        this.scrollPane = new JScrollPane(this.textPane);
        this.scrollPane.setAutoscrolls(true);
        int height = this.textPane.getFontMetrics(this.textPane.getFont()).getHeight();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(height);
        this.setLayout(this.borderLayout);
        this.add((Component)this.scrollPane, "Center");
        this.setVisible(true);
        this.piOut = new PipedInputStream(8192);
        this.poOut = new PipedOutputStreamN21(this.piOut);
        new Thread((Runnable)this.poOut, "JCPipedOut").start();
        System.setOut(new PrintStream(this.poOut));
        this.piErr = new PipedInputStream(8192);
        this.poErr = new PipedOutputStreamN21(this.piErr);
        new Thread((Runnable)this.poErr, "JCPipedErr").start();
        System.setErr(new PrintStream(this.poErr));
        SimpleAttributeSet attrSetOut = new SimpleAttributeSet();
        StyleConstants.setForeground(attrSetOut, OUT_COLOR);
        Font font = new Font("Courier", 1, 12);
        StyleConstants.setFontFamily(attrSetOut, font.getFamily());
        StyleConstants.setFontSize(attrSetOut, font.getSize());
        StyleConstants.setItalic(attrSetOut, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrSetOut, (font.getStyle() & 1) != 0);
        SimpleAttributeSet adieuAttrSetOut = new SimpleAttributeSet();
        StyleConstants.setForeground(adieuAttrSetOut, ADIEU_OUT_COLOR);
        StyleConstants.setBold(adieuAttrSetOut, true);
        ReaderThread output = new ReaderThread(this.piOut, this.textPane, attrSetOut, adieuAttrSetOut);
        output.setName("output");
        output.start();
        SimpleAttributeSet attrSetErr = new SimpleAttributeSet();
        StyleConstants.setForeground(attrSetErr, ERR_COLOR);
        StyleConstants.setBold(attrSetErr, true);
        SimpleAttributeSet adieuAttrSetErr = new SimpleAttributeSet();
        StyleConstants.setForeground(adieuAttrSetErr, ADIEU_ERR_COLOR);
        StyleConstants.setBold(adieuAttrSetErr, true);
        ReaderThread error = new ReaderThread(this.piErr, this.textPane, attrSetErr, adieuAttrSetErr);
        error.setName("error");
        error.start();
    }

    private class PipedOutputStreamN21
    extends PipedOutputStream
    implements Runnable {
        private MSQueue queue;

        public PipedOutputStreamN21(PipedInputStream snk) throws IOException {
            super(snk);
            this.queue = new MSQueue(100, 0);
        }

        @Override
        public void run() {
            Object object = null;
            try {
                while (true) {
                    if ((object = this.queue.pend(0)) != null) {
                        if (object instanceof byte[]) {
                            byte[] bytes = (byte[])object;
                            super.write(bytes, 0, bytes.length);
                            continue;
                        }
                        if (object instanceof Integer) {
                            super.write((Integer)object);
                            continue;
                        }
                        Console.showError("PipedOutputStreamN21.run(): unknown object, " + object.getClass().getName() + ", in queue!");
                        continue;
                    }
                    Console.showError("PipedOutputStreamN21.run(): null object in queue!");
                }
            }
            catch (IOException e) {
                Console.showError("PipedOutputStreamN21.run(): " + e.toString());
            }
            catch (InterruptedException e) {
                Console.showWarn("PipedOutputStreamN21.run(): interrupted!");
            }
        }

        @Override
        public void write(int b) {
            try {
                this.queue.post(new Integer(b), 0);
            }
            catch (InterruptedException e) {
                Console.showError("PipedOutputStreamN21.write(int b): interrupted!");
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.queue.post(Arrays.copyOfRange(b, off, off + len), 0);
            }
            catch (InterruptedException e) {
                Console.showError("PipedOutputStreamN21.write(byte b[],int off,int len): interrupted!");
            }
        }

        @Override
        public void write(byte[] b) {
            try {
                this.queue.post(Arrays.copyOf(b, b.length), 0);
            }
            catch (InterruptedException e) {
                Console.showError("PipedOutputStreamN21.write(byte b[]): interrupted!");
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private InputStream is;
        private JTextPane textPane;
        private SimpleAttributeSet attrSet;
        private SimpleAttributeSet adieuAttrSet;

        ReaderThread(InputStream is, JTextPane textPane, SimpleAttributeSet attrSet, SimpleAttributeSet adieuAttrSet) {
            this.is = is;
            this.textPane = textPane;
            this.attrSet = attrSet;
            this.adieuAttrSet = adieuAttrSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block34: {
                byte[] buf = new byte[1024];
                int LEN_OF_EOL = "\n".length();
                String text = "";
                String unfinishedLine = "";
                try {
                    try {
                        int len2;
                        while ((len2 = this.is.read(buf)) != -1) {
                            if (len2 == 0) continue;
                            text = new String(buf, 0, len2);
                            int posOfEOL = text.lastIndexOf("\n");
                            if (posOfEOL >= 0) {
                                String tmp = text;
                                text = unfinishedLine.length() == 0 ? text.substring(0, posOfEOL + LEN_OF_EOL) : String.valueOf(unfinishedLine) + text.substring(0, posOfEOL + LEN_OF_EOL);
                                unfinishedLine = tmp.substring(posOfEOL + LEN_OF_EOL);
                            } else {
                                unfinishedLine = String.valueOf(unfinishedLine) + text;
                                text = "";
                            }
                            if (text.length() == 0) continue;
                            Object object = JavaConsole.this.syncLogFile;
                            synchronized (object) {
                                if (JavaConsole.this.logFileRW == null) {
                                    this.openLogFile();
                                }
                                JavaConsole.this.logFileRW.write(buf, 0, len2);
                            }
                            object = JavaConsole.this.syncTextOperations;
                            synchronized (object) {
                                try {
                                    JavaConsole.this.doc.insertString(JavaConsole.this.doc.getLength(), text, this.attrSet);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                                int excess = JavaConsole.this.doc.getLength() - 1000000;
                                try {
                                    if (excess >= 100000) {
                                        JavaConsole.this.doc.replace(0, 100000, "", null);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                                this.textPane.setCaretPosition(JavaConsole.this.doc.getLength());
                            }
                        }
                        JavaConsole.this.logFileRW.write("... Exit ...\n");
                        JavaConsole.this.logFileRW.close();
                        JavaConsole.this.logFileRW = null;
                        if (text.length() > 0) {
                            text = String.valueOf(text) + "\n";
                            try {
                                JavaConsole.this.doc.insertString(JavaConsole.this.doc.getLength(), text, this.attrSet);
                            }
                            catch (BadLocationException len2) {
                                // empty catch block
                            }
                        }
                        text = "EOS encountered!\nADIEU\n";
                        try {
                            JavaConsole.this.doc.insertString(JavaConsole.this.doc.getLength(), text, this.adieuAttrSet);
                        }
                        catch (BadLocationException len2) {
                            // empty catch block
                        }
                        this.textPane.setCaretPosition(JavaConsole.this.doc.getLength());
                    }
                    catch (IOException e) {
                        try {
                            JavaConsole.this.doc.insertString(JavaConsole.this.doc.getLength(), String.valueOf(e.toString()) + "\n" + "ADIEU" + "\n", this.adieuAttrSet);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (JavaConsole.this.logFileRW == null) break block34;
                        try {
                            JavaConsole.this.logFileRW.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (JavaConsole.this.logFileRW != null) {
                        try {
                            JavaConsole.this.logFileRW.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void openLogFile() {
            block14: {
                JavaConsole.this.logFileRW = null;
                boolean ok = false;
                try {
                    try {
                        JavaConsole.this.logFileRW = new FileRW(JavaConsole.this.logFilename, "rw");
                        if (JavaConsole.this.append) {
                            JavaConsole.this.logFileRW.seek(JavaConsole.this.logFileRW.length());
                        } else {
                            JavaConsole.this.logFileRW.setLength(0L);
                        }
                        ok = true;
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                        if (ok || JavaConsole.this.logFileRW == null) break block14;
                        try {
                            JavaConsole.this.logFileRW.close();
                        }
                        catch (IOException ex2) {
                            Console.printThreadStackTrace(ex2);
                        }
                    }
                }
                finally {
                    if (!ok && JavaConsole.this.logFileRW != null) {
                        try {
                            JavaConsole.this.logFileRW.close();
                        }
                        catch (IOException ex) {
                            Console.printThreadStackTrace(ex);
                        }
                    }
                }
            }
        }
    }
}

