/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.project.LogViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class LogPane
extends JPanel
implements LogViewer {
    private static final int IDEAL_SIZE = 500000;
    private static final int MAX_EXCESS = 50000;
    private static final int LEN_OF_EOL = "\n".length();
    private static final int MAX_LINE_SIZE = 500;
    private static final Font FONT = new Font("Courier", 1, 12);
    private static final Color OUT_COLOR = new Color(60, 150, 80);
    private static final Color ADIEU_OUT_COLOR = new Color(0, 0, 180);
    private static final Color ERR_COLOR = Color.red;
    private static final Color ADIEU_ERR_COLOR = new Color(180, 0, 180);
    private static final SimpleAttributeSet ATTR_SET_OUT = new SimpleAttributeSet();
    private static final SimpleAttributeSet ADIEU_ATTR_SET_OUT = new SimpleAttributeSet();
    private static final SimpleAttributeSet ATTR_SET_ERR = new SimpleAttributeSet();
    private static final SimpleAttributeSet ADIEU_ATTR_SET_ERR = new SimpleAttributeSet();
    private BorderLayout borderLayout = new BorderLayout();
    private DefaultStyledDocument doc = new DefaultStyledDocument();
    private JTextPane textPane = new JTextPane(this.doc);
    private JScrollPane scrollPane = new JScrollPane(this.textPane);
    private String outUnfinishedLine = "";
    private String errUnfinishedLine = "";
    private Throwable throwable;

    public LogPane() {
        this.scrollPane.setAutoscrolls(true);
        int height = this.textPane.getFontMetrics(this.textPane.getStyledDocument().getFont(ATTR_SET_OUT)).getHeight();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(height);
        this.setLayout(this.borderLayout);
        this.add((Component)this.scrollPane, "Center");
        this.textPane.setEditable(false);
        this.setVisible(true);
        StyleConstants.setForeground(ATTR_SET_OUT, OUT_COLOR);
        StyleConstants.setFontFamily(ATTR_SET_OUT, FONT.getFamily());
        StyleConstants.setFontSize(ATTR_SET_OUT, FONT.getSize());
        StyleConstants.setItalic(ATTR_SET_OUT, (FONT.getStyle() & 2) != 0);
        StyleConstants.setBold(ATTR_SET_OUT, (FONT.getStyle() & 1) != 0);
        StyleConstants.setForeground(ADIEU_ATTR_SET_OUT, ADIEU_OUT_COLOR);
        StyleConstants.setBold(ADIEU_ATTR_SET_OUT, true);
        StyleConstants.setForeground(ATTR_SET_ERR, ERR_COLOR);
        StyleConstants.setFontFamily(ATTR_SET_ERR, FONT.getFamily());
        StyleConstants.setFontSize(ATTR_SET_ERR, FONT.getSize());
        StyleConstants.setItalic(ATTR_SET_ERR, (FONT.getStyle() & 2) != 0);
        StyleConstants.setBold(ATTR_SET_ERR, (FONT.getStyle() & 1) != 0);
        StyleConstants.setForeground(ADIEU_ATTR_SET_ERR, ADIEU_ERR_COLOR);
        StyleConstants.setBold(ADIEU_ATTR_SET_ERR, true);
    }

    @Override
    public synchronized void add(final boolean err, byte[] buffer, final int start, final int length) throws Throwable {
        if (this.throwable != null) {
            throw new Throwable("Unexpected error in LogPane", this.throwable);
        }
        final byte[] buf = Arrays.copyOf(buffer, length);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPane.this.add0(err, buf, start, length);
            }
        });
    }

    @Override
    public synchronized void flush(final boolean err) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPane.this.flush0(err);
            }
        });
    }

    @Override
    public synchronized void adieu(final boolean err) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPane.this.adieu0(err);
            }
        });
    }

    private void add0(boolean err, byte[] buffer, int start, int length) {
        String unfinishedLine;
        SimpleAttributeSet attrSet;
        if (this.throwable != null) {
            return;
        }
        if (!err) {
            attrSet = ATTR_SET_OUT;
            unfinishedLine = this.outUnfinishedLine;
        } else {
            attrSet = ATTR_SET_ERR;
            unfinishedLine = this.errUnfinishedLine;
        }
        String text = new String(buffer, start, length);
        int posOfEOL = text.lastIndexOf("\n");
        if (posOfEOL >= 0) {
            String tmp = text;
            text = unfinishedLine.length() == 0 ? text.substring(0, posOfEOL + LEN_OF_EOL) : String.valueOf(unfinishedLine) + text.substring(0, posOfEOL + LEN_OF_EOL);
            unfinishedLine = tmp.substring(posOfEOL + LEN_OF_EOL);
        } else {
            unfinishedLine = String.valueOf(unfinishedLine) + text;
            text = "";
        }
        boolean startOfLine = true;
        while (text.length() > 0 || unfinishedLine.length() > 500) {
            String line = startOfLine ? "" : "  ";
            if (text.length() == 0) {
                line = String.valueOf(line) + unfinishedLine.substring(0, 500) + "\n";
                unfinishedLine = unfinishedLine.substring(500);
                startOfLine = false;
            } else if (text.length() <= 500) {
                line = String.valueOf(line) + text;
                text = "";
                startOfLine = true;
            } else {
                int pos2;
                block18: {
                    pos2 = 0;
                    do {
                        int pos1;
                        if ((pos2 = text.indexOf("\n", pos1 = pos2) + LEN_OF_EOL) - pos1 <= 500 + LEN_OF_EOL) continue;
                        pos2 = pos1 + 500;
                        startOfLine = false;
                        break block18;
                    } while (pos2 != text.length());
                    startOfLine = true;
                }
                line = String.valueOf(line) + text.substring(0, pos2) + (startOfLine ? "" : "\n");
                text = text.substring(pos2);
            }
            try {
                this.doc.insertString(this.doc.getLength(), line, attrSet);
            }
            catch (Throwable ex) {
                this.throwable = ex;
                return;
            }
        }
        try {
            if (this.doc.getLength() - 500000 >= 50000) {
                this.doc.replace(0, 50000, "", null);
            }
            if (!err) {
                this.outUnfinishedLine = unfinishedLine;
            } else {
                this.errUnfinishedLine = unfinishedLine;
            }
            this.textPane.setCaretPosition(this.doc.getLength());
        }
        catch (Throwable ex) {
            this.throwable = ex;
        }
    }

    private void flush0(boolean err) {
        String unfinishedLine;
        SimpleAttributeSet attrSet;
        if (this.throwable != null) {
            return;
        }
        if (!err) {
            attrSet = ATTR_SET_OUT;
            unfinishedLine = this.outUnfinishedLine;
        } else {
            attrSet = ATTR_SET_ERR;
            unfinishedLine = this.errUnfinishedLine;
        }
        if (unfinishedLine.length() > 0) {
            unfinishedLine = String.valueOf(unfinishedLine) + "\n";
            try {
                this.doc.insertString(this.doc.getLength(), unfinishedLine, attrSet);
                this.textPane.setCaretPosition(this.doc.getLength());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!err) {
            this.outUnfinishedLine = "";
        } else {
            this.errUnfinishedLine = "";
        }
    }

    private void adieu0(boolean err) {
        if (this.throwable != null) {
            return;
        }
        SimpleAttributeSet attrSet = !err ? ADIEU_ATTR_SET_OUT : ADIEU_ATTR_SET_ERR;
        try {
            this.doc.insertString(this.doc.getLength(), "ADIEU\n", attrSet);
            this.textPane.setCaretPosition(this.doc.getLength());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

