/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.SaveImage;
import edu.uml.lgdc.gui.controls.PosIntegerField;
import edu.uml.lgdc.gui.controls.RealField;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.project.options.SavePictureOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class SavePicturePanel
extends EventEnabledPanel {
    public static final int LAYOUT_HORIZONTAL = 0;
    public static final int LAYOUT_VERTICAL = 1;
    private static final String NINES = "9999999999999999999";
    private static final int MAX_PICTURE_PIXELS = 9999;
    private static final int MAX_PICTURE_PIXELS_DIGITS_QTY = "9999".length();
    private static final String maxPicturePixelsStrFillValue = "9999999999".substring(0, MAX_PICTURE_PIXELS_DIGITS_QTY);
    private static final double MIN_SCALE = 0.01;
    private static final double MAX_SCALE = 50.0;
    private static final int MAX_SCALE_LENGTH = 5;
    private static final int MAX_SCALE_DECIMALS = 2;
    private static final String maxScaleStrValue = String.valueOf("9999999999999999999".substring(0, 2)) + "." + "9999999999999999999".substring(0, 2);
    protected SavePictureOptions options = null;
    protected SavePictureOptions prevOptions = null;
    protected boolean changed = false;
    protected int layout = 1;
    private int prevPictureWidth = -1;
    private int prevPictureHeight = -1;
    private double prevXScale = 1.0;
    private double prevYScale = 1.0;
    private Border border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), "Save Picture Options", 2, 2);
    protected FlowLayout flowLayout = new FlowLayout();
    protected GridLayout gridLayout = new GridLayout(2, 4);
    private JLabel lblWidth = new JLabel();
    private PosIntegerField tfWidth = new PosIntegerField();
    private FlowLayout pnlWidthFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlWidth = new JPanel();
    private JLabel lblHeight = new JLabel();
    private PosIntegerField tfHeight = new PosIntegerField();
    private FlowLayout pnlHeightFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlHeight = new JPanel();
    private JLabel lblUseFixSize = new JLabel();
    protected JCheckBox ckbUseFixSize = new JCheckBox();
    private FlowLayout pnlUseFixSizeFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlUseFixSize = new JPanel();
    private JLabel lblFormat = new JLabel();
    private JComboBox<SaveImage.Format> cbFormat = new JComboBox<SaveImage.Format>(SaveImage.Format.values());
    private FlowLayout pnlFormatFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlFormat = new JPanel();
    private JLabel lblXScale = new JLabel("XScale", 4);
    private RealField tfXScale = new RealField(maxScaleStrValue, 5);
    private FlowLayout pnlXScaleFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlXScale = new JPanel(this.pnlXScaleFlowLayout);
    private JLabel lblYScale = new JLabel("YScale", 4);
    private RealField tfYScale = new RealField(maxScaleStrValue, 5);
    private FlowLayout pnlYScaleFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlYScale = new JPanel(this.pnlYScaleFlowLayout);
    private JLabel lblKeepRatio = new JLabel("Keep ratio", 4);
    private JCheckBox ckbKeepRatio = new JCheckBox();
    private FlowLayout pnlKeepRatioFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlKeepRatio = new JPanel(this.pnlKeepRatioFlowLayout);
    private JLabel lblPresentationQuality = new JLabel("Quality", 4);
    private JCheckBox ckbPresentationQuality = new JCheckBox();
    private FlowLayout pnlPresentationQualityFlowLayout = new FlowLayout(4, 4, 0);
    protected JPanel pnlPresentationQuality = new JPanel(this.pnlPresentationQualityFlowLayout);

    public SavePicturePanel() {
        this((SavePictureOptions)null);
    }

    public SavePicturePanel(SavePictureOptions options) {
        this.init(options);
    }

    public void setFields(SavePictureOptions options) {
        this.options = options;
        this.prevOptions = (SavePictureOptions)options.clone();
        this.changed = false;
        this.tfWidth.setEnabled(options.getUseFixedPictureSizeForOutputEnable());
        this.tfHeight.setEnabled(options.getUseFixedPictureSizeForOutputEnable());
        this.setText(this.tfWidth, "" + options.getPictureWidth());
        this.setText(this.tfHeight, "" + options.getPictureHeight());
        this.ckbUseFixSize.setSelected(options.getUseFixedPictureSizeForOutputEnable());
        this.cbFormat.setSelectedItem((Object)options.getPictureFormat());
        if (this.cbFormat.getSelectedIndex() == -1) {
            this.cbFormat.setSelectedItem((Object)SaveImage.Format.PNG);
        }
        this.ckbUseFixSize_actionPerformed(null);
        this.setText(this.tfXScale, Formatter.format(Formatter.getFFormat(5, 2), options.getXScale()));
        Formatter.checkNumericFieldValue(this.tfXScale, 0.01, 50.0, this.prevXScale, 5, 2);
        this.setText(this.tfYScale, Formatter.format(Formatter.getFFormat(5, 2), options.getYScale()));
        Formatter.checkNumericFieldValue(this.tfYScale, 0.01, 50.0, this.prevYScale, 5, 2);
        this.ckbKeepRatio.setSelected(options.getKeepRatioEnable());
        this.ckbPresentationQuality.setSelected(options.getPresentationQualityEnable());
        this.ckbKeepRatio_actionPerformed(null);
        this.cbFormat_actionPerformed(null);
    }

    protected boolean init(SavePictureOptions options) {
        boolean result = true;
        this.guiInit();
        this.addComponents();
        if (options != null) {
            this.setFields(options);
        }
        this.tfWidth.requestFocus();
        return result;
    }

    protected void guiInit() {
        this.lblWidth.setText("Width");
        this.lblWidth.setHorizontalAlignment(4);
        this.lblWidth.setLabelFor(this.tfWidth);
        this.tfWidth.setColumns(MAX_PICTURE_PIXELS_DIGITS_QTY);
        this.tfWidth.setText("9999");
        this.tfWidth.setText(maxPicturePixelsStrFillValue);
        this.tfWidth.setHorizontalAlignment(4);
        this.tfWidth.setToolTipText("Set width of picture in pixels");
        this.tfWidth.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.tfWidth_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.tfWidth_focusLost(e);
            }
        });
        this.tfWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.tfWidth_actionPerformed(e);
            }
        });
        this.pnlWidth.setLayout(this.pnlWidthFlowLayout);
        this.pnlWidth.add(this.lblWidth);
        this.pnlWidth.add(this.tfWidth);
        this.lblHeight.setText("Height");
        this.lblHeight.setHorizontalAlignment(4);
        this.lblHeight.setLabelFor(this.tfHeight);
        this.tfHeight.setColumns(MAX_PICTURE_PIXELS_DIGITS_QTY);
        this.tfHeight.setText("9999");
        this.tfHeight.setText(maxPicturePixelsStrFillValue);
        this.tfHeight.setHorizontalAlignment(4);
        this.tfHeight.setToolTipText("Set height of picture in pixels");
        this.tfHeight.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.tfHeight_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.tfHeight_focusLost(e);
            }
        });
        this.tfHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.tfHeight_actionPerformed(e);
            }
        });
        this.pnlHeight.setLayout(this.pnlHeightFlowLayout);
        this.pnlHeight.add(this.lblHeight);
        this.pnlHeight.add(this.tfHeight);
        this.lblUseFixSize.setText("Use fixed sizes");
        this.ckbUseFixSize.setToolTipText("Check it if you want to use your own width and height");
        this.ckbUseFixSize.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.focusLost(e);
            }
        });
        this.ckbUseFixSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.ckbUseFixSize_actionPerformed(e);
            }
        });
        this.pnlUseFixSize.setLayout(this.pnlUseFixSizeFlowLayout);
        this.pnlUseFixSize.add(this.lblUseFixSize);
        this.pnlUseFixSize.add(this.ckbUseFixSize);
        this.lblFormat.setText("Format");
        this.lblFormat.setHorizontalAlignment(4);
        this.lblFormat.setLabelFor(this.cbFormat);
        this.cbFormat.setPreferredSize(new Dimension(60, 20));
        this.cbFormat.setToolTipText("Choose format for picture");
        this.cbFormat.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.focusLost(e);
            }
        });
        this.cbFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.cbFormat_actionPerformed(e);
            }
        });
        this.pnlFormat.setLayout(this.pnlFormatFlowLayout);
        this.pnlFormat.add(this.lblFormat);
        this.pnlFormat.add(this.cbFormat);
        this.tfXScale.setHorizontalAlignment(4);
        this.tfXScale.setToolTipText("Set Scale to resize or change resolution");
        this.lblXScale.setLabelFor(this.tfXScale);
        this.tfXScale.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.tfXScale_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.tfXScale_focusLost(e);
            }
        });
        this.tfXScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.tfXScale_actionPerformed(e);
            }
        });
        this.pnlXScale.add(this.lblXScale);
        this.pnlXScale.add(this.tfXScale);
        this.tfYScale.setHorizontalAlignment(4);
        this.tfYScale.setToolTipText("Set Scale to resize or change resolution");
        this.lblYScale.setLabelFor(this.tfYScale);
        this.tfYScale.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.tfYScale_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.tfYScale_focusLost(e);
            }
        });
        this.tfYScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.tfYScale_actionPerformed(e);
            }
        });
        this.pnlYScale.add(this.lblYScale);
        this.pnlYScale.add(this.tfYScale);
        this.ckbKeepRatio.setToolTipText("Uncheck if you \"don't want keep ratio\"");
        this.ckbKeepRatio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.focusLost(e);
            }
        });
        this.ckbKeepRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePicturePanel.this.ckbKeepRatio_actionPerformed(e);
            }
        });
        this.pnlKeepRatio.add(this.lblKeepRatio);
        this.pnlKeepRatio.add(this.ckbKeepRatio);
        this.ckbPresentationQuality.setToolTipText("Check for quality rendering");
        this.ckbPresentationQuality.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SavePicturePanel.this.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SavePicturePanel.this.focusLost(e);
            }
        });
        this.pnlPresentationQuality.add(this.lblPresentationQuality);
        this.pnlPresentationQuality.add(this.ckbPresentationQuality);
        this.setToolTipText("Here you set various parameters/options for saving picture onto file");
        this.setBorder(this.border);
    }

    protected void addComponents() {
        if (this.layout == 0) {
            this.setLayout(this.flowLayout);
            this.add((Component)this.pnlWidth, null);
            this.add((Component)this.pnlHeight, null);
            this.add((Component)this.pnlXScale, null);
            this.add((Component)this.pnlYScale, null);
            this.add((Component)this.pnlKeepRatio, null);
            this.add((Component)this.pnlPresentationQuality, null);
            this.add((Component)this.pnlFormat, null);
            this.add((Component)this.pnlUseFixSize, null);
        } else {
            this.setLayout(this.gridLayout);
            this.add((Component)this.pnlWidth, null);
            this.add((Component)this.pnlXScale, null);
            this.add((Component)this.pnlKeepRatio, null);
            this.add((Component)this.pnlFormat, null);
            this.add((Component)this.pnlHeight, null);
            this.add((Component)this.pnlYScale, null);
            this.add((Component)this.pnlPresentationQuality, null);
            this.add((Component)this.pnlUseFixSize, null);
        }
    }

    public void setLayoutType(int type) {
        if (type != this.layout) {
            this.removeAll();
            this.layout = type;
            this.addComponents();
        }
    }

    public void accept() {
        this.options.setPictureWidth(Integer.parseInt(this.tfWidth.getText()));
        this.options.setPictureHeight(Integer.parseInt(this.tfHeight.getText()));
        this.options.setUseFixedPictureSizeForOutputEnable(this.ckbUseFixSize.isSelected());
        this.options.setPictureFormat((SaveImage.Format)((Object)this.cbFormat.getSelectedItem()));
        this.options.setXScale(Double.parseDouble(this.tfXScale.getText()));
        this.options.setYScale(Double.parseDouble(this.tfXScale.getText()));
        this.options.setKeepRatioEnable(this.ckbKeepRatio.isSelected());
        this.options.setPresentationQualityEnable(this.ckbPresentationQuality.isSelected());
        this.changed = !this.options.equals(this.prevOptions);
    }

    public void reset() {
        this.setFields(this.options);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public SavePictureOptions getOptions() {
        return this.options;
    }

    public boolean isChangedWidth() {
        return this.options.getPictureWidth() != this.prevOptions.getPictureWidth();
    }

    public boolean isChangedHeight() {
        return this.options.getPictureHeight() != this.prevOptions.getPictureHeight();
    }

    public boolean isChangedUseFixedSizeForOutput() {
        return this.options.getUseFixedPictureSizeForOutputEnable() ^ this.prevOptions.getUseFixedPictureSizeForOutputEnable();
    }

    public boolean isChangedFormat() {
        return !this.options.getPictureFormat().equals((Object)this.prevOptions.getPictureFormat());
    }

    public boolean isChangedPath() {
        return !this.options.getPicturePath().equals(this.prevOptions.getPicturePath());
    }

    @Override
    public void requestFocus() {
        this.tfWidth.requestFocus();
    }

    protected void setText(JTextField tf, String text) {
        tf.setText(text);
        if (tf.isEnabled()) {
            tf.setCaretPosition(text.length());
            tf.moveCaretPosition(0);
        }
    }

    protected void common_actionPerformed(ActionEvent e) {
        this.generateExternal_actionPerformed(e);
    }

    protected void focusGained(FocusEvent e) {
        this.runFocusMonitor();
        this.isFocused = true;
    }

    protected void focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void tfWidth_actionPerformed(ActionEvent e) {
        Formatter.checkNumericFieldValue(this.tfWidth, 1, 9999, this.prevPictureWidth);
        this.generateExternal_actionPerformed(e);
    }

    private void tfWidth_focusLost(FocusEvent e) {
        Formatter.checkNumericFieldValue(this.tfWidth, 1, 9999, this.prevPictureWidth);
        this.isFocused = false;
    }

    private void tfHeight_actionPerformed(ActionEvent e) {
        Formatter.checkNumericFieldValue(this.tfHeight, 1, 9999, this.prevPictureHeight);
        this.generateExternal_actionPerformed(e);
    }

    private void tfHeight_focusLost(FocusEvent e) {
        Formatter.checkNumericFieldValue(this.tfHeight, 1, 9999, this.prevPictureHeight);
        this.isFocused = false;
    }

    protected void ckbUseFixSize_actionPerformed(ActionEvent e) {
        this.lblWidth.setEnabled(this.ckbUseFixSize.isSelected());
        this.tfWidth.setEnabled(this.ckbUseFixSize.isSelected());
        this.lblHeight.setEnabled(this.ckbUseFixSize.isSelected());
        this.tfHeight.setEnabled(this.ckbUseFixSize.isSelected());
    }

    private void tfWidth_focusGained(FocusEvent e) {
        this.prevPictureWidth = Integer.parseInt(this.tfWidth.getText());
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void tfHeight_focusGained(FocusEvent e) {
        this.prevPictureHeight = Integer.parseInt(this.tfHeight.getText());
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void tfXScale_actionPerformed(ActionEvent e) {
        this.prevXScale = Formatter.checkNumericFieldValue(this.tfXScale, 0.0, 50.0, this.prevXScale, 5, 2);
        if (this.ckbKeepRatio.isSelected()) {
            this.tfYScale.setText(this.tfXScale.getText());
        }
        this.common_actionPerformed(e);
    }

    private void tfXScale_focusGained(FocusEvent e) {
        this.prevXScale = Double.parseDouble(this.tfXScale.getText());
        this.focusGained(e);
    }

    private void tfXScale_focusLost(FocusEvent e) {
        this.prevXScale = Formatter.checkNumericFieldValue(this.tfXScale, 0.0, 50.0, this.prevXScale, 5, 2);
        if (this.ckbKeepRatio.isSelected()) {
            this.tfYScale.setText(this.tfXScale.getText());
        }
        this.focusLost(e);
    }

    private void tfYScale_actionPerformed(ActionEvent e) {
        this.prevYScale = Formatter.checkNumericFieldValue(this.tfYScale, 0.0, 50.0, this.prevYScale, 5, 2);
        if (this.ckbKeepRatio.isSelected()) {
            this.tfXScale.setText(this.tfYScale.getText());
        }
        this.common_actionPerformed(e);
    }

    private void tfYScale_focusGained(FocusEvent e) {
        this.prevYScale = Double.parseDouble(this.tfYScale.getText());
        this.focusGained(e);
    }

    private void tfYScale_focusLost(FocusEvent e) {
        this.prevYScale = Formatter.checkNumericFieldValue(this.tfYScale, 0.0, 50.0, this.prevYScale, 5, 2);
        if (this.ckbKeepRatio.isSelected()) {
            this.tfXScale.setText(this.tfYScale.getText());
        }
        this.focusLost(e);
    }

    private void ckbKeepRatio_actionPerformed(ActionEvent e) {
        if (this.ckbKeepRatio.isSelected()) {
            if (Double.parseDouble(this.tfXScale.getText()) < Double.parseDouble(this.tfYScale.getText())) {
                this.setText(this.tfYScale, Formatter.format(Formatter.getFFormat(5, 2), this.options.getXScale()));
                Formatter.checkNumericFieldValue(this.tfYScale, 0.01, 50.0, this.prevYScale, 5, 2);
            } else if (Double.parseDouble(this.tfYScale.getText()) < Double.parseDouble(this.tfXScale.getText())) {
                this.setText(this.tfXScale, Formatter.format(Formatter.getFFormat(5, 2), this.options.getYScale()));
                Formatter.checkNumericFieldValue(this.tfXScale, 0.01, 50.0, this.prevYScale, 5, 2);
            }
        }
    }

    private void cbFormat_actionPerformed(ActionEvent e) {
        boolean eps = this.cbFormat.getSelectedItem() == SaveImage.Format.EPS;
        Draw.setEnabled(this.pnlXScale, !eps);
        Draw.setEnabled(this.pnlYScale, !eps);
        this.ckbKeepRatio.setEnabled(!eps);
    }
}

