/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.C;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.MessageWindow;
import edu.uml.lgdc.gui.HotKeyButton;
import edu.uml.lgdc.gui.HotKeyButtons;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import edu.uml.lgdc.gui.MonitorTableColorRenderer;
import edu.uml.lgdc.gui.MonitorTableIx;
import edu.uml.lgdc.gui.OrderableTable;
import edu.uml.lgdc.gui.SunBug4783068Fixer;
import edu.uml.lgdc.gui.config.ThreadInfoPanelOptions_Ix;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Sort;
import edu.uml.lgdc.project.Console;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ThreadInfoPanel
extends EventEnabledPanel
implements MonitorTableIx {
    private static final int H_GAP = 5;
    private static final int V_GAP = 5;
    private static final int DEFAULT_REFR_PERIOD = 4;
    private static final int MIN_REFR_PERIOD = 1;
    private static final int MAX_REFR_PERIOD = 100;
    private static final int STEP_REFR_PERIOD = 1;
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private static final boolean CPU_SUPPORTED = THREAD_MX.isThreadCpuTimeSupported();
    private static final boolean CONTENTION_SUPPORTED = THREAD_MX.isThreadContentionMonitoringSupported();
    private static final int COL_IND_IDENT = 0;
    private static final int COL_IND_NAME = 1;
    private static final int COL_IND_STATE = 2;
    private static final int COL_IND_CPU_TIME = 3;
    private static final int COL_IND_BLOCKED_COUNT = 4;
    private static final int COL_IND_BLOCKED_TIME = 5;
    private static final int COL_IND_WAITED_COUNT = 6;
    private static final int COL_IND_WAITED_TIME = 7;
    private static final int COL_IND_LOCK_NAME = 8;
    private static final int COL_IND_LOCK_OWNER_NAME = 9;
    private static final int QTY_OF_COLS = 10;
    private static final String[] COLUMN_NAMES = new String[]{"TID", "Name", "State", "CPU", "BlockedCnt", "BlockedTime", "WaitedCnt", "WaitedTime", "LockName", "LockOwnerName"};
    private static final String[] COLUMN_TITLES = new String[]{"TID", "Name", "State", "CPU, ms", "Blocked count", "Blocked time, ms", "Waited count", "Waited time, ms", "Lock name", "Lock owner name"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Long.class, String.class, String.class, Long.class, Long.class, Long.class, Long.class, Long.class, String.class, String.class};
    private ThreadInfoPanelOptions_Ix threadInfoPanelOptions;
    private HotKeyButtons hotKeyButtons;
    private HotKeyButton startStopRefresh;
    private boolean[] columnsEnabled;
    private int[] columnsIndexInTable;
    private int qtyOfCols;
    private String[] columnTitles;
    private Class<?>[] columnClasses;
    private int[] columnIndexes;
    private int numberOfThreads;
    private long[] _TIDs;
    private ThreadInfo[] threadInfo;
    private long[] _CPU;
    private int prevNumberOfThreads;
    private long[] prevTIDs;
    private ThreadInfo[] prevThreadInfo;
    private long[] prevCPU;
    private boolean dataModelChanged;
    private long selectedThreadIdent;
    private String selectedThreadName;
    private boolean deltaOutputMode;
    private JTable table;
    private OrderableTable data;
    private MonitorTableColorRenderer renderer;
    private Object syncRefresh;
    private int orderIndex;
    private boolean descending;
    private int mouseOverColumnHeaderIndex;
    private int interval_msec;
    private PeriodicRefreshing periodicRefreshing;
    private Object syncPeriodicRefreshing;
    private BorderLayout borderLayout;
    private JScrollPane spTable;
    private Border borderControl;
    private JPanel pnlControl;
    private JPanel pnlGeneralInfo;
    private JPanel pnlThreadCount;
    private JLabel lblThreadCount;
    private JLabel lblThreadCountVal;
    private JPanel pnlPeakThreadCount;
    private JLabel lblPeakThreadCount;
    private JLabel lblPeakThreadCountVal;
    private JPanel pnlTotalStartedThreadCount;
    private JLabel lblTotalStartedThreadCount;
    private JLabel lblTotalStartedThreadCountVal;
    private JPanel pnlRefreshPeriod;
    private JButton btnStartStop;
    private JLabel lblRefreshPeriod;
    private JSpinner spnRefreshPeriod;
    private JLabel lblRefreshPeriodSec;
    private JCheckBox ckbShowAccumulative;
    private JCheckBox ckbCPUMonitoring;
    private JCheckBox ckbContentionMonitoring;
    private JButton btnShowStack;
    private JFrame frmStack;
    private KeyEventDispatcher keyEventDispatcher;
    private JTextArea taStack;
    private JScrollPane scpStack;
    private static final int[] INT_SEQ = new int[]{75, 73, 76, 76};
    private transient int nextCharOfIntSeq;

    public static int getColIndex(String name) {
        int index = Search.scanStrIgnoreCase(COLUMN_NAMES, name);
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public static String getColName(int index) {
        if (index >= 0 && index < 10) {
            return COLUMN_NAMES[index];
        }
        return COLUMN_NAMES[0];
    }

    public ThreadInfoPanel(ThreadInfoPanelOptions_Ix threadInfoPanelOptions) {
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[8] = true;
        blArray[9] = true;
        this.columnsEnabled = blArray;
        this.columnsIndexInTable = new int[10];
        this.numberOfThreads = 0;
        this.prevNumberOfThreads = 0;
        this.deltaOutputMode = true;
        this.data = new OrderableTable(0, 0);
        this.renderer = new MonitorTableColorRenderer();
        this.syncRefresh = new Object();
        this.mouseOverColumnHeaderIndex = -1;
        this.interval_msec = 4000;
        this.syncPeriodicRefreshing = new Object();
        this.borderLayout = new BorderLayout(5, 5);
        this.spTable = new JScrollPane();
        this.borderControl = BorderFactory.createEtchedBorder();
        this.pnlControl = new JPanel();
        this.pnlGeneralInfo = new JPanel(new FlowLayout(1, 10, 5));
        this.pnlThreadCount = new JPanel(new FlowLayout(1, 5, 5));
        this.lblThreadCount = new JLabel("Current thread count:");
        this.lblThreadCountVal = new JLabel("");
        this.pnlPeakThreadCount = new JPanel(new FlowLayout(1, 5, 5));
        this.lblPeakThreadCount = new JLabel("Peak thread count:");
        this.lblPeakThreadCountVal = new JLabel("");
        this.pnlTotalStartedThreadCount = new JPanel(new FlowLayout(1, 5, 5));
        this.lblTotalStartedThreadCount = new JLabel("Total started thread count:");
        this.lblTotalStartedThreadCountVal = new JLabel("");
        this.pnlRefreshPeriod = new JPanel();
        this.btnStartStop = new JButton();
        this.lblRefreshPeriod = new JLabel("with period ");
        this.spnRefreshPeriod = new JSpinner();
        this.lblRefreshPeriodSec = new JLabel(" sec ");
        this.ckbShowAccumulative = new JCheckBox();
        this.ckbCPUMonitoring = new JCheckBox();
        this.ckbContentionMonitoring = new JCheckBox();
        this.btnShowStack = new JButton();
        this.frmStack = new JFrame();
        this.taStack = new JTextArea();
        this.nextCharOfIntSeq = 0;
        this.threadInfoPanelOptions = threadInfoPanelOptions;
        this.columnsEnabled[3] = this.getThreadInfoShowCPUEnabled();
        this.deltaOutputMode = !this.getThreadInfoShowAccumulativeEnabled();
        this.orderIndex = this.getThreadInfoOrderedColumn();
        this.descending = this.getThreadInfoDescendingOrderEnabled();
        if (!this.columnsEnabled[this.orderIndex]) {
            this.orderIndex = 0;
            this.descending = false;
        } else {
            int last = this.orderIndex;
            int i = 0;
            while (i < last) {
                if (!this.columnsEnabled[i]) {
                    --this.orderIndex;
                }
                ++i;
            }
        }
        this.guiInit();
        this.refresh();
    }

    private void createDataModel() {
        int[] prevColumnIndexes = this.columnIndexes;
        this.saveSelectedRow();
        this.qtyOfCols = 0;
        int i = 0;
        while (i < 10) {
            if (this.columnsEnabled[i]) {
                ++this.qtyOfCols;
            }
            ++i;
        }
        this.columnIndexes = new int[this.qtyOfCols];
        this.columnTitles = new String[this.qtyOfCols];
        this.columnClasses = new Class[this.qtyOfCols];
        int index = 0;
        int i2 = 0;
        while (i2 < 10) {
            if (this.columnsEnabled[i2]) {
                this.columnsIndexInTable[i2] = index;
                this.columnIndexes[index] = i2;
                this.columnTitles[index] = COLUMN_TITLES[i2];
                this.columnClasses[index] = COLUMN_CLASSES[i2];
                ++index;
            } else {
                this.columnsIndexInTable[i2] = -1;
            }
            ++i2;
        }
        if (prevColumnIndexes != null) {
            while (true) {
                if (this.columnsIndexInTable[prevColumnIndexes[this.orderIndex]] >= 0) {
                    this.orderIndex = this.columnsIndexInTable[prevColumnIndexes[this.orderIndex]];
                    break;
                }
                if (this.orderIndex <= 0) break;
                --this.orderIndex;
            }
        }
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return ThreadInfoPanel.this.qtyOfCols;
            }

            @Override
            public int getRowCount() {
                return ThreadInfoPanel.this.data.getNumberOfRows();
            }

            @Override
            public Object getValueAt(int row, int col) {
                return ThreadInfoPanel.this.data.get(row, col);
            }

            @Override
            public String getColumnName(int column) {
                if (ThreadInfoPanel.this.orderIndex != column) {
                    return ThreadInfoPanel.this.columnTitles[column];
                }
                if (!ThreadInfoPanel.this.descending) {
                    return String.valueOf('\u2191') + ThreadInfoPanel.this.columnTitles[column];
                }
                return String.valueOf('\u2193') + ThreadInfoPanel.this.columnTitles[column];
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return ThreadInfoPanel.this.columnClasses[column];
            }
        };
        this.table.setModel(dataModel);
        this.renderer.setup(this);
        this.dataModelChanged = true;
    }

    private void guiInit() {
        ArrayList<HotKeyButton> lstHotKeyButtons = new ArrayList<HotKeyButton>();
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setShowGrid(true);
        this.createDataModel();
        this.pnlThreadCount.add(this.lblThreadCount);
        this.pnlThreadCount.add(this.lblThreadCountVal);
        this.pnlPeakThreadCount.add(this.lblPeakThreadCount);
        this.pnlPeakThreadCount.add(this.lblPeakThreadCountVal);
        this.pnlTotalStartedThreadCount.add(this.lblTotalStartedThreadCount);
        this.pnlTotalStartedThreadCount.add(this.lblTotalStartedThreadCountVal);
        this.pnlGeneralInfo.add(this.pnlThreadCount);
        this.pnlGeneralInfo.add(this.pnlPeakThreadCount);
        this.pnlGeneralInfo.add(this.pnlTotalStartedThreadCount);
        SunBug4783068Fixer.attach(this.btnStartStop);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreadInfoPanel.this.switchAutoRefreshing(true);
            }
        };
        this.startStopRefresh = new HotKeyButton((AbstractButton)this.btnStartStop, new String[]{"Start refsresh", "Stop refsresh"}, 'S', 128, (KeyListener)keyListener);
        lstHotKeyButtons.add(this.startStopRefresh);
        this.btnStartStop.setToolTipText("<HTML>Push to start periodic refreshing, hot key: <b>Ctrl-S</b></HTML>");
        this.btnStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadInfoPanel.this.switchAutoRefreshing(false);
            }
        });
        this.btnStartStop.setEnabled(true);
        keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreadInfoPanel.this.ckbCPUMonitoring.setSelected(!ThreadInfoPanel.this.ckbCPUMonitoring.isSelected());
                ThreadInfoPanel.this.actionPerpormed_ckbCPUMonitoring(null);
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.ckbCPUMonitoring, "CPU monitoring", 'P', 128, (KeyListener)keyListener));
        this.ckbCPUMonitoring.setToolTipText("<HTML>Show/hide CPU time column, hot key: <b>Ctrl-P</b></HTML>");
        this.ckbCPUMonitoring.setSelected(this.getThreadInfoShowCPUEnabled());
        this.ckbCPUMonitoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadInfoPanel.this.actionPerpormed_ckbCPUMonitoring(e);
            }
        });
        this.setCPUMonitoringEnabled(this.ckbCPUMonitoring.isSelected());
        keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreadInfoPanel.this.ckbContentionMonitoring.setSelected(!ThreadInfoPanel.this.ckbContentionMonitoring.isSelected());
                ThreadInfoPanel.this.actionPerpormed_ckbContentionMonitoring(null);
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.ckbContentionMonitoring, "Contention monitoring", 'e', 128, (KeyListener)keyListener));
        this.ckbContentionMonitoring.setToolTipText("<HTML>Show/hide contention time column, hot key: <b>Ctrl-E</b></HTML>");
        this.ckbContentionMonitoring.setSelected(false);
        this.ckbContentionMonitoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadInfoPanel.this.actionPerpormed_ckbContentionMonitoring(e);
            }
        });
        this.setContentionMonitoringEnabled(this.ckbContentionMonitoring.isSelected());
        this.spnRefreshPeriod.setToolTipText("hot input: 1,2,...,9");
        this.spnRefreshPeriod.setModel(new SpinnerNumberModel(4, 1, 100, 1));
        int refreshPeriod_sec = this.getThreadInfoRefreshPeriod_sec();
        if (refreshPeriod_sec < 1) {
            refreshPeriod_sec = 1;
        } else if (refreshPeriod_sec > 100) {
            refreshPeriod_sec = 100;
        }
        this.spnRefreshPeriod.getModel().setValue(refreshPeriod_sec);
        this.spnRefreshPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThreadInfoPanel.this.refreshPeriod_stateChanged();
            }
        });
        keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreadInfoPanel.this.ckbShowAccumulative.setSelected(!ThreadInfoPanel.this.ckbShowAccumulative.isSelected());
                ThreadInfoPanel.this.actionPerpormed_ckbShowAccumulative(null);
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.ckbShowAccumulative, "Show Accumulative", 'h', 128, (KeyListener)keyListener));
        this.ckbShowAccumulative.setToolTipText("<HTML>On/Off accumulative values in columns, hot key: <b>Ctrl-H</b></HTML>");
        this.ckbShowAccumulative.setSelected(!this.deltaOutputMode);
        this.ckbShowAccumulative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadInfoPanel.this.actionPerpormed_ckbShowAccumulative(e);
            }
        });
        keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreadInfoPanel.this.showStack();
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.btnShowStack, "Stack", 't', 128, (KeyListener)keyListener));
        this.btnShowStack.setEnabled(true);
        this.btnShowStack.setToolTipText("<HTML>Shows calling stack of selected thread, hot key: <b>Ctrl-T</b></HTML>");
        this.btnShowStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadInfoPanel.this.showStack();
            }
        });
        this.pnlRefreshPeriod.setBackground(Color.LIGHT_GRAY);
        this.pnlRefreshPeriod.add(this.btnStartStop);
        this.pnlRefreshPeriod.add(this.lblRefreshPeriod);
        this.pnlRefreshPeriod.add(this.spnRefreshPeriod);
        this.pnlRefreshPeriod.add(this.lblRefreshPeriodSec);
        this.pnlControl.setBorder(this.borderControl);
        this.pnlControl.add(this.pnlRefreshPeriod);
        this.pnlControl.add(this.ckbShowAccumulative);
        if (CPU_SUPPORTED) {
            this.pnlControl.add(this.ckbCPUMonitoring);
        }
        if (CONTENTION_SUPPORTED) {
            this.pnlControl.add(this.ckbContentionMonitoring);
        }
        this.pnlControl.add(this.btnShowStack);
        this.setPreferredSize(new Dimension(1024, 500));
        this.table.setAutoResizeMode(4);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ThreadInfoPanel.this.clickOverHeader(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ThreadInfoPanel.this.thisMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ThreadInfoPanel.this.thisMouseExited(e);
            }
        });
        this.table.getTableHeader().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ThreadInfoPanel.this.thisMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ThreadInfoPanel.this.mouseMovedOverTable(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.spTable.getViewport().add(this.table);
        this.setLayout(this.borderLayout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.pnlGeneralInfo, "North");
        this.add((Component)this.spTable, "Center");
        this.add((Component)this.pnlControl, "South");
        this.taStack.setEditable(false);
        this.taStack.setTabSize(2);
        this.scpStack = new JScrollPane();
        this.scpStack.getViewport().add((Component)this.taStack, null);
        this.frmStack.getContentPane().setLayout(new BorderLayout());
        this.frmStack.getContentPane().add((Component)this.scpStack, "Center");
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = new KeyboardEventDispatcher(this.frmStack, true);
        keyboardFocusManager.addKeyEventDispatcher(this.keyEventDispatcher);
        this.frmStack.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ThreadInfoPanel.this.frmStack.setVisible(false);
            }
        });
        this.frmStack.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                int modifiers = e.getModifiersEx();
                if (keyCode == 27 && modifiers == 0 || keyCode == 115 && modifiers == 512) {
                    ThreadInfoPanel.this.frmStack.setVisible(false);
                }
            }
        });
        this.frmStack.setSize(600, 400);
        Draw.centerPosition(this.frmStack);
        this.hotKeyButtons = new HotKeyButtons(lstHotKeyButtons, true, true, true);
        this.hotKeyButtons.setColor(C.COLOR_HOT_KEY);
        this.hotKeyButtons.removeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStack() {
        int selectedRow = -1;
        ThreadInfo info = null;
        Object object = this.syncRefresh;
        synchronized (object) {
            selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0) {
                info = this.threadInfo[selectedRow];
            }
        }
        if (selectedRow >= 0) {
            this.showStack(info);
        } else {
            new MessageWindow("No selected thread", 20).setVisible(true);
        }
    }

    private void showStack(ThreadInfo info) {
        StackTraceElement[] stack = info.getStackTrace();
        StringBuilder strBuf = new StringBuilder(2000);
        strBuf.append("Thread \"" + info.getThreadName() + "\" Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            strBuf.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            strBuf.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            strBuf.append(" (suspended)");
        }
        if (info.isInNative()) {
            strBuf.append(" (in native)");
        }
        strBuf.append("\n\n");
        int i = 0;
        while (i < stack.length) {
            strBuf.append("\tat " + stack[i]);
            if (i == 0 || i < stack.length - 1) {
                strBuf.append('\n');
            }
            ++i;
        }
        this.taStack.setText(strBuf.toString());
        this.frmStack.setTitle("Thread \"" + info.getThreadName() + "\"");
        this.frmStack.setVisible(true);
        this.frmStack.setState(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport viewport = ThreadInfoPanel.this.scpStack.getViewport();
                Rectangle rectangle = viewport.getViewRect();
                if (rectangle.x != 0 || rectangle.y != 0) {
                    viewport.scrollRectToVisible(new Rectangle(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRefreshPeriod(int interval_msec) {
        Object object = this.syncPeriodicRefreshing;
        synchronized (object) {
            this.interval_msec = interval_msec;
            if (this.periodicRefreshing != null) {
                this.periodicRefreshing.setInterval(interval_msec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchAutoRefreshing(boolean hotKeyUsed) {
        Object object = this.syncPeriodicRefreshing;
        synchronized (object) {
            try {
                if (this.periodicRefreshing == null) {
                    this.startAutoRefreshing(hotKeyUsed);
                } else {
                    this.stopAutoRefreshing(hotKeyUsed);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAutoRefreshing(boolean hotKeyUsed) {
        Object object = this.syncPeriodicRefreshing;
        synchronized (object) {
            if (!hotKeyUsed) {
                this.startStopRefresh.advanceTextIndex();
                this.btnStartStop.setText("Stop refresh");
            }
            this.btnStartStop.setToolTipText("<HTML>Push to stop periodic refreshing, hot key: <b>Ctrl-S</b></HTML>");
            this.lblRefreshPeriod.setText("change period ");
            this.periodicRefreshing = new PeriodicRefreshing(this.interval_msec);
            this.periodicRefreshing.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAutoRefreshing(boolean hotKeyUsed) throws InterruptedException {
        Object object = this.syncPeriodicRefreshing;
        synchronized (object) {
            if (this.periodicRefreshing == null) {
                return;
            }
            this.periodicRefreshing.interrupt();
            this.periodicRefreshing.join();
            this.periodicRefreshing = null;
            if (!hotKeyUsed) {
                this.startStopRefresh.advanceTextIndex();
                this.btnStartStop.setText("Start refresh");
            }
            this.btnStartStop.setToolTipText("<HTML>Push to start periodic refreshing, hot key: <b>Ctrl-S</b></HTML>");
            this.lblRefreshPeriod.setText("with period ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionPerpormed_ckbCPUMonitoring(ActionEvent e) {
        Object object = this.syncRefresh;
        synchronized (object) {
            this.setCPUMonitoringEnabled(this.ckbCPUMonitoring.isSelected());
            this.createDataModel();
            this.refresh();
            this.setThreadInfoShowCPUEnabled(this.ckbCPUMonitoring.isSelected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionPerpormed_ckbContentionMonitoring(ActionEvent e) {
        Object object = this.syncRefresh;
        synchronized (object) {
            this.setContentionMonitoringEnabled(this.ckbContentionMonitoring.isSelected());
            this.createDataModel();
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionPerpormed_ckbShowAccumulative(ActionEvent e) {
        Object object = this.syncRefresh;
        synchronized (object) {
            this.deltaOutputMode = !this.ckbShowAccumulative.isSelected();
            this.refresh();
            this.setThreadInfoShowAccumulativeEnabled(this.ckbShowAccumulative.isSelected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.syncRefresh;
        synchronized (object) {
            this._refresh();
        }
    }

    private void _refresh() {
        if (!this.dataModelChanged) {
            this.saveSelectedRow();
        } else {
            this.dataModelChanged = false;
        }
        this._TIDs = THREAD_MX.getAllThreadIds();
        this.threadInfo = THREAD_MX.getThreadInfo(this._TIDs, Integer.MAX_VALUE);
        this.numberOfThreads = 0;
        int i = 0;
        while (i < this.threadInfo.length) {
            if (this.threadInfo[i] != null) {
                if (i > this.numberOfThreads) {
                    this.threadInfo[this.numberOfThreads] = this.threadInfo[i];
                    this._TIDs[this.numberOfThreads] = this._TIDs[i];
                }
                ++this.numberOfThreads;
            }
            ++i;
        }
        this.lblThreadCountVal.setText("" + this.numberOfThreads);
        this.lblPeakThreadCountVal.setText("" + THREAD_MX.getPeakThreadCount());
        this.lblTotalStartedThreadCountVal.setText("" + THREAD_MX.getTotalStartedThreadCount());
        this._CPU = new long[this.numberOfThreads];
        boolean useDeltaMode = this.deltaOutputMode && this.prevThreadInfo != null;
        int[] tidIndexes = null;
        if (useDeltaMode) {
            tidIndexes = new int[this.numberOfThreads];
            i = 0;
            while (i < this.numberOfThreads) {
                tidIndexes[i] = Search.scan(this.prevTIDs, this._TIDs[i], 0, this.prevNumberOfThreads - 1);
                ++i;
            }
        }
        OrderableTable data = new OrderableTable(this.numberOfThreads, this.qtyOfCols);
        i = 0;
        while (i < 10) {
            if (this.columnsEnabled[i]) {
                int colIndex = this.columnsIndexInTable[i];
                switch (i) {
                    case 0: {
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            data.put(j, colIndex, new Long(this._TIDs[j]));
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            data.put(j, colIndex, this.threadInfo[j].getThreadName());
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            data.put(j, colIndex, this.threadInfo[j].getThreadState().toString());
                            ++j;
                        }
                        break;
                    }
                    case 3: {
                        Object val;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            long nanoseconds;
                            this._CPU[j] = nanoseconds = THREAD_MX.getThreadCpuTime(this._TIDs[j]);
                            if (nanoseconds == -1L) {
                                val = "undefined";
                            } else {
                                if (useDeltaMode && tidIndexes[j] >= 0 && this.prevCPU[tidIndexes[j]] >= 0L && (nanoseconds -= this.prevCPU[tidIndexes[j]]) < 0L) {
                                    nanoseconds = 0L;
                                }
                                val = new Long(nanoseconds / 1000000L);
                            }
                            data.put(j, colIndex, val);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        long count;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            count = this.threadInfo[j].getBlockedCount();
                            if (useDeltaMode && tidIndexes[j] >= 0 && (count -= this.prevThreadInfo[tidIndexes[j]].getBlockedCount()) < 0L) {
                                count = 0L;
                            }
                            data.put(j, colIndex, new Long(count));
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        long milliseconds;
                        Object val;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            milliseconds = this.threadInfo[j].getBlockedTime();
                            if (milliseconds == -1L) {
                                val = "undefined";
                            } else {
                                if (useDeltaMode && tidIndexes[j] >= 0 && this.prevThreadInfo[tidIndexes[j]].getBlockedTime() >= 0L && (milliseconds -= this.prevThreadInfo[tidIndexes[j]].getBlockedTime()) < 0L) {
                                    milliseconds = 0L;
                                }
                                val = new Long(milliseconds);
                            }
                            data.put(j, colIndex, val);
                            ++j;
                        }
                        break;
                    }
                    case 6: {
                        long count;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            count = this.threadInfo[j].getWaitedCount();
                            if (useDeltaMode && tidIndexes[j] >= 0 && (count -= this.prevThreadInfo[tidIndexes[j]].getWaitedCount()) < 0L) {
                                count = 0L;
                            }
                            data.put(j, colIndex, new Long(count));
                            ++j;
                        }
                        break;
                    }
                    case 7: {
                        long milliseconds;
                        Object val;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            milliseconds = this.threadInfo[j].getWaitedTime();
                            if (milliseconds == -1L) {
                                val = "undefined";
                            } else {
                                if (useDeltaMode && tidIndexes[j] >= 0 && this.prevThreadInfo[tidIndexes[j]].getWaitedTime() >= 0L && (milliseconds -= this.prevThreadInfo[tidIndexes[j]].getWaitedTime()) < 0L) {
                                    milliseconds = 0L;
                                }
                                val = new Long(milliseconds);
                            }
                            data.put(j, colIndex, val);
                            ++j;
                        }
                        break;
                    }
                    case 8: {
                        String tmpStr;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            tmpStr = this.threadInfo[j].getLockName();
                            tmpStr = tmpStr != null ? tmpStr : "";
                            data.put(j, colIndex, tmpStr);
                            ++j;
                        }
                        break;
                    }
                    case 9: {
                        String tmpStr;
                        int j = 0;
                        while (j < this.numberOfThreads) {
                            tmpStr = this.threadInfo[j].getLockOwnerName();
                            tmpStr = tmpStr != null ? tmpStr : "";
                            data.put(j, colIndex, tmpStr);
                            ++j;
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("Illegal column: " + COLUMN_TITLES[i]);
                    }
                }
            }
            ++i;
        }
        this.prevTIDs = this._TIDs;
        this.prevThreadInfo = this.threadInfo;
        this.prevNumberOfThreads = this.numberOfThreads;
        this.prevCPU = this._CPU;
        this.data = data;
        this.order();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.getTableHeader().repaint();
        this.restoreSelectedRow();
    }

    private void saveSelectedRow() {
        int selectedRow = -1;
        this.selectedThreadIdent = -1L;
        this.selectedThreadName = null;
        if (this.columnIndexes != null && (selectedRow = this.table.getSelectedRow()) >= 0) {
            this.selectedThreadIdent = this.threadInfo[selectedRow].getThreadId();
            this.selectedThreadName = this.threadInfo[selectedRow].getThreadName();
        }
    }

    private void restoreSelectedRow() {
        if (this.selectedThreadIdent >= 0L) {
            int idRow = -1;
            int nameRow = -1;
            int i = 0;
            while (i < this.numberOfThreads) {
                if (this.threadInfo[i].getThreadId() == this.selectedThreadIdent) {
                    idRow = i;
                    break;
                }
                if (nameRow == -1 && this.threadInfo[i].getThreadName().equals(this.selectedThreadName)) {
                    nameRow = i;
                }
                ++i;
            }
            if (idRow >= 0) {
                this.table.setRowSelectionInterval(idRow, idRow);
            } else if (nameRow >= 0) {
                this.table.setRowSelectionInterval(nameRow, nameRow);
            }
        }
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    @Override
    public int getOrderColumn() {
        return this.orderIndex;
    }

    @Override
    public boolean isOrderDescending() {
        return this.descending;
    }

    @Override
    public int getMouseOverColumnHeaderIndex() {
        return this.mouseOverColumnHeaderIndex;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char keyChar = e.getKeyChar();
        int modifiers = e.getModifiersEx();
        if (modifiers == 0 && Character.isDigit(keyChar) && keyChar != '0') {
            this.spnRefreshPeriod.getModel().setValue(Character.digit(keyChar, 10));
            this.refreshPeriod_stateChanged();
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.hotKeyButtons.keyPressed(e);
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (modifiers != 128) {
            this.nextCharOfIntSeq = 0;
            return;
        }
        if (keyCode == INT_SEQ[this.nextCharOfIntSeq]) {
            ++this.nextCharOfIntSeq;
            if (this.nextCharOfIntSeq == INT_SEQ.length) {
                this.nextCharOfIntSeq = 0;
                this.interruptSelectedThread();
            }
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.hotKeyButtons.keyReleased(e);
        if (e.getKeyCode() == 17) {
            this.nextCharOfIntSeq = 0;
        }
    }

    private void refreshPeriod_stateChanged() {
        this.setRefreshPeriod(1000 * (Integer)this.spnRefreshPeriod.getValue());
        this.setThreadInfoRefreshPeriod_sec((Integer)this.spnRefreshPeriod.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptSelectedThread() {
        int currentRow = -1;
        ThreadInfo info = null;
        Object object = this.syncRefresh;
        synchronized (object) {
            currentRow = this.table.getSelectedRow();
            if (currentRow >= 0) {
                info = this.threadInfo[currentRow];
            }
        }
        if (info != null) {
            long tid = info.getThreadId();
            Thread[] threads = new Thread[500];
            int numberOfThreads = Thread.enumerate(threads);
            int index = -1;
            int i = 0;
            while (i < numberOfThreads) {
                if (threads[i].getId() == tid) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                threads[index].interrupt();
                Console.showWarn("Operator attempts to interrupt thread " + threads[index].getName());
            } else {
                new MessageWindow("Thread " + info.getThreadName() + " (Id=" + info.getThreadId() + ") either already dead " + "or inaccessible", 3).setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickOverHeader(MouseEvent e) {
        Object object = this.syncRefresh;
        synchronized (object) {
            JTableHeader header = this.table.getTableHeader();
            int col = header.columnAtPoint(e.getPoint());
            if (col == -1) {
                return;
            }
            TableColumn column = header.getColumnModel().getColumn(col);
            if (col == this.orderIndex) {
                this.descending = !this.descending;
                this.setThreadInfoDescendingOrderEnabled(this.descending);
            } else {
                header.getColumnModel().getColumn(this.orderIndex).setHeaderValue(this.columnTitles[this.orderIndex]);
                this.orderIndex = col;
                this.descending = this.columnClasses[col] == Long.class && this.columnIndexes[col] != 0;
                this.setThreadInfoOrderedColumn(this.columnIndexes[this.orderIndex]);
                this.setThreadInfoDescendingOrderEnabled(this.descending);
            }
            if (!this.descending) {
                column.setHeaderValue(String.valueOf('\u2191') + this.columnTitles[col]);
            } else {
                column.setHeaderValue(String.valueOf('\u2193') + this.columnTitles[col]);
            }
            this.saveSelectedRow();
            this.order();
            this.restoreSelectedRow();
            this.table.repaint();
        }
    }

    private void thisMouseEntered(MouseEvent e) {
        JTableHeader header = this.table.getTableHeader();
        int col = header.columnAtPoint(e.getPoint());
        if (this.mouseOverColumnHeaderIndex == col) {
            return;
        }
        this.mouseOverColumnHeaderIndex = col;
        this.table.getTableHeader().repaint();
    }

    private void thisMouseExited(MouseEvent e) {
        this.mouseOverColumnHeaderIndex = -1;
        this.table.getTableHeader().repaint();
    }

    private void thisMouseMoved(MouseEvent e) {
        JTableHeader tableHeader = this.table.getTableHeader();
        int col = tableHeader.columnAtPoint(e.getPoint());
        if (this.mouseOverColumnHeaderIndex == col) {
            return;
        }
        this.mouseOverColumnHeaderIndex = col;
        this.table.getTableHeader().repaint();
    }

    public void mouseMovedOverTable(MouseEvent e) {
        int col = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1) {
            return;
        }
        Rectangle rect = this.table.getCellRect(row, col, false);
        TableCellRenderer renderer = this.table.getCellRenderer(row, col);
        Component component = this.table.prepareRenderer(renderer, row, col);
        if (component != null && component instanceof JLabel) {
            JLabel label = (JLabel)component;
            String val = label.getText();
            if (val != null && (double)label.getFontMetrics(label.getFont()).stringWidth(val) > rect.getWidth() - 2.0) {
                label.setToolTipText(val);
            } else {
                label.setToolTipText(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCPUMonitoringEnabled(boolean value) {
        Object object = this.syncRefresh;
        synchronized (object) {
            if (CPU_SUPPORTED) {
                THREAD_MX.setThreadCpuTimeEnabled(value);
                this.columnsEnabled[3] = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContentionMonitoringEnabled(boolean value) {
        Object object = this.syncRefresh;
        synchronized (object) {
            if (CONTENTION_SUPPORTED) {
                THREAD_MX.setThreadContentionMonitoringEnabled(value);
                this.columnsEnabled[5] = value;
                this.columnsEnabled[7] = value;
            }
        }
    }

    private void order() {
        Sort sort = this.data.order(this.orderIndex, this.descending);
        ThreadInfo[] sortedThreadInfo = new ThreadInfo[this.numberOfThreads];
        int i = 0;
        while (i < this.numberOfThreads) {
            sortedThreadInfo[i] = this.threadInfo[sort.elementAt(i)];
            ++i;
        }
        this.threadInfo = sortedThreadInfo;
    }

    private boolean getThreadInfoShowCPUEnabled() {
        if (this.threadInfoPanelOptions != null) {
            return CPU_SUPPORTED && this.threadInfoPanelOptions.getThreadInfoShowCPUEnabled();
        }
        return false;
    }

    private void setThreadInfoShowCPUEnabled(boolean flag) {
        if (this.threadInfoPanelOptions != null) {
            this.threadInfoPanelOptions.setThreadInfoShowCPUEnabled(flag);
        }
    }

    private boolean getThreadInfoShowAccumulativeEnabled() {
        if (this.threadInfoPanelOptions != null) {
            return this.threadInfoPanelOptions.getThreadInfoShowAccumulativeEnabled();
        }
        return false;
    }

    private void setThreadInfoShowAccumulativeEnabled(boolean flag) {
        if (this.threadInfoPanelOptions != null) {
            this.threadInfoPanelOptions.setThreadInfoShowAccumulativeEnabled(flag);
        }
    }

    private int getThreadInfoOrderedColumn() {
        if (this.threadInfoPanelOptions != null) {
            return this.threadInfoPanelOptions.getThreadInfoOrderedColumn();
        }
        return 0;
    }

    private void setThreadInfoOrderedColumn(int value) {
        if (this.threadInfoPanelOptions != null) {
            this.threadInfoPanelOptions.setThreadInfoOrderedColumn(value);
        }
    }

    private boolean getThreadInfoDescendingOrderEnabled() {
        if (this.threadInfoPanelOptions != null) {
            return this.threadInfoPanelOptions.getThreadInfoDescendingOrderEnabled();
        }
        return false;
    }

    private void setThreadInfoDescendingOrderEnabled(boolean flag) {
        if (this.threadInfoPanelOptions != null) {
            this.threadInfoPanelOptions.setThreadInfoDescendingOrderEnabled(flag);
        }
    }

    private int getThreadInfoRefreshPeriod_sec() {
        if (this.threadInfoPanelOptions != null) {
            return this.threadInfoPanelOptions.getThreadInfoRefreshPeriod_sec();
        }
        return 4;
    }

    private void setThreadInfoRefreshPeriod_sec(int value) {
        if (this.threadInfoPanelOptions != null) {
            this.threadInfoPanelOptions.setThreadInfoRefreshPeriod_sec(value);
        }
    }

    private class PeriodicRefreshing
    extends Thread {
        private int interval_msec;
        private boolean internalInterrupt;

        PeriodicRefreshing(int interval_msec) {
            super("TM_refresh");
            this.interval_msec = interval_msec;
        }

        void setInterval(int interval_msec) {
            this.interval_msec = interval_msec;
            if (ThreadInfoPanel.this.periodicRefreshing == null) {
                return;
            }
            this.internalInterrupt = true;
            ThreadInfoPanel.this.periodicRefreshing.interrupt();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ThreadInfoPanel.this.refresh();
                        Thread.sleep(this.interval_msec);
                    }
                }
                catch (InterruptedException e) {
                    if (this.internalInterrupt) {
                        this.internalInterrupt = false;
                        continue;
                    }
                    return;
                }
                break;
            }
        }
    }
}

