/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.instrument.BadPacketLengthException;
import edu.uml.lgdc.instrument.PacketStreamOptions;
import edu.uml.lgdc.instrument.Payload;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BasicParser {
    public static final String PAR_PAYLOAD_MIN_LENGTH = "PayloadMinLength";
    public static final String PAR_PAYLOAD_MAX_LENGTH = "PayloadMaxLength";
    public static final String PAR_PACKET_LENGTH_FIELD_BYTES = "PacketLengthField_bytes";
    public static final String PAR_PACKET_TYPE_FIELD_BYTES = "PacketTypeField_bytes";
    public static int NUMBER_OF_BYTES_FOR_TYPE_FIELD;
    public static int NUMBER_OF_BYTES_FOR_LEN_FIELD;
    protected static int PAYLOAD_MIN_LENGTH;
    protected static int PAYLOAD_MAX_LENGTH;
    public static int PACKET_AUX_LENGTH;
    protected static int PACKET_MIN_LENGTH;
    protected static int PACKET_MAX_LENGTH;
    private static final int PKT_K1 = 0;
    private static final int PKT_K2 = 1;
    private static final int PKT_T = 2;
    private static final int PKT_D = 3;
    private static final int PKT_FIN = 1000;
    protected InputStream is;
    protected PacketStreamOptions psOptions;
    protected transient Payload payload;
    protected transient int parseState = 0;
    protected transient int pktCount;
    protected transient int payloadIndex;
    protected transient long lastPacketOffset;
    protected transient long currentOffset;
    protected boolean fileChecking;

    public BasicParser(InputStream is) {
        this.is = is;
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        PAYLOAD_MIN_LENGTH = 0;
        PAYLOAD_MAX_LENGTH = 65532;
        NUMBER_OF_BYTES_FOR_TYPE_FIELD = 1;
        NUMBER_OF_BYTES_FOR_LEN_FIELD = 2;
        PACKET_AUX_LENGTH = NUMBER_OF_BYTES_FOR_LEN_FIELD + NUMBER_OF_BYTES_FOR_TYPE_FIELD;
        PACKET_MIN_LENGTH = PAYLOAD_MIN_LENGTH + PACKET_AUX_LENGTH;
        PACKET_MAX_LENGTH = PAYLOAD_MAX_LENGTH + PACKET_AUX_LENGTH;
    }

    protected void refreshProperties(Properties properties) {
        PAYLOAD_MAX_LENGTH = (Integer)properties.get(PAR_PAYLOAD_MAX_LENGTH);
        PAYLOAD_MIN_LENGTH = (Integer)properties.get(PAR_PAYLOAD_MIN_LENGTH);
        NUMBER_OF_BYTES_FOR_TYPE_FIELD = (Integer)properties.get(PAR_PACKET_TYPE_FIELD_BYTES);
        NUMBER_OF_BYTES_FOR_LEN_FIELD = (Integer)properties.get(PAR_PACKET_LENGTH_FIELD_BYTES);
        PACKET_AUX_LENGTH = NUMBER_OF_BYTES_FOR_LEN_FIELD + NUMBER_OF_BYTES_FOR_TYPE_FIELD;
        PACKET_MIN_LENGTH = PAYLOAD_MIN_LENGTH + PACKET_AUX_LENGTH;
        PACKET_MAX_LENGTH = PAYLOAD_MAX_LENGTH + PACKET_AUX_LENGTH;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void setFileCheckingMode() {
        this.fileChecking = true;
    }

    public boolean receive(Payload payload) throws IOException {
        this.payload = payload;
        payload.setReadyToReceive();
        this.parseState = 0;
        this.lastPacketOffset += (long)this.pktCount;
        this.pktCount = 0;
        if (this.parseState == 1000) {
            return true;
        }
        block5: while (true) {
            int c;
            if ((c = this.is.read()) == -1) {
                if (this.pktCount > 0) {
                    Console.showError("Premature End Of Packet");
                    this.countError();
                }
                return false;
            }
            ++this.pktCount;
            switch (this.parseState) {
                case 0: 
                case 1: {
                    ++this.parseState;
                    payload.length = payload.length << 8 | c & 0xFF;
                    if (this.parseState <= 1) continue block5;
                    if (payload.length > PACKET_MAX_LENGTH) {
                        this.countError();
                        throw new BadPacketLengthException("Packet Size, " + payload.length + " (>" + PACKET_MAX_LENGTH + ")");
                    }
                    if (payload.length < PACKET_MIN_LENGTH) {
                        this.countError();
                        throw new BadPacketLengthException("Packet Size, " + payload.length + " (<" + PACKET_MIN_LENGTH + ")");
                    }
                    payload.length -= PACKET_AUX_LENGTH;
                    this.payloadIndex = 0;
                    continue block5;
                }
                case 2: {
                    payload.type = c;
                    this.parseState = 3;
                    if (payload.length != 0) continue block5;
                    return true;
                }
                case 3: {
                    payload.data[this.payloadIndex++] = (byte)c;
                    if (this.payloadIndex != payload.length) continue block5;
                    this.parseState = 1000;
                    if (!this.fileChecking && this.psOptions != null && this.psOptions.getSaveInboundEnabled()) {
                        this.duplicateToFile();
                    }
                    return true;
                }
            }
        }
    }

    public long getLastPacketOffset() {
        return this.lastPacketOffset;
    }

    public int getLastPacketLength() {
        return this.pktCount;
    }

    protected void countError() {
    }

    protected void countBadPreambleBytes(long badPreambleBytes) {
    }

    protected String bytesToHexString(byte[] data, int offset, int length) {
        String s = "";
        int i = 0;
        while (i < length) {
            s = String.valueOf(s) + FC.int2HexStr(data[offset + i], 2);
            ++i;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void duplicateToFile() {
        int length = this.payload.getLength() + PACKET_AUX_LENGTH;
        try {
            Object object = this.psOptions.inboundLock;
            synchronized (object) {
                int shift = 8 * (NUMBER_OF_BYTES_FOR_LEN_FIELD - 1);
                int i = 0;
                while (i < NUMBER_OF_BYTES_FOR_LEN_FIELD) {
                    this.psOptions.writeInbound((byte)(length >> shift));
                    shift -= 8;
                    ++i;
                }
                this.psOptions.writeInbound((byte)this.payload.getType());
                this.psOptions.writeInbound(this.payload.getData(), this.payload.getLength());
            }
        }
        catch (IOException e) {
            Console.showError("Parser.duplicateToFile(): " + e);
        }
    }
}

