/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import java.util.HashMap;
import java.util.Map;

public enum ConnectStatus {
    DISCONNECTED(0, "disconnected"),
    CONNECTING(1, "connecting"),
    CONNECTED(2, "connected");

    private static final Map<Integer, ConnectStatus> mapById;
    private static final Map<String, ConnectStatus> mapByName;
    private final int id;
    private final String name;

    static {
        mapById = new HashMap<Integer, ConnectStatus>();
        mapByName = new HashMap<String, ConnectStatus>();
        ConnectStatus[] connectStatusArray = ConnectStatus.values();
        int n = connectStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectStatus status = connectStatusArray[n2];
            if (mapById.put(status.getId(), status) != null) {
                throw new RuntimeException("design error: id " + status.getId() + " is duplicated");
            }
            if (mapByName.put(status.getName(), status) != null) {
                throw new RuntimeException("design error: name " + status.getName() + " is duplicated");
            }
            ++n2;
        }
    }

    private ConnectStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static ConnectStatus get(int id) {
        return mapById.get(id);
    }

    public static ConnectStatus get(String name) {
        return mapByName.get(name);
    }
}

