/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.dashboard.ByteBufferUtil;
import edu.uml.lgdc.time.TimeScale;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class InstrumentStatus {
    private int connectStatus;
    private int currentSched;
    private int opState;
    private long badPktCounter;
    private String lastConnectedTime;
    private String progschedUpdatedTime;
    private int dac1Cmd;
    private int dac2Cmd;

    public InstrumentStatus(int connectStatus, int currentSched, int opState, long badPktCounter, String lastConnectedTime, String progUpTime, int dac1Cmd, int dac2Cmd) {
        this.connectStatus = connectStatus;
        this.currentSched = currentSched;
        this.opState = opState;
        this.badPktCounter = badPktCounter;
        this.lastConnectedTime = lastConnectedTime;
        this.progschedUpdatedTime = progUpTime;
        this.dac1Cmd = dac1Cmd;
        this.dac2Cmd = dac2Cmd;
    }

    public InstrumentStatus(byte[] data) {
        ByteBufferUtil bUtil = new ByteBufferUtil();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.connectStatus = bUtil.removeIntFromBuffer(buffer);
        this.currentSched = bUtil.removeIntFromBuffer(buffer);
        this.opState = bUtil.removeIntFromBuffer(buffer);
        this.badPktCounter = bUtil.removeLongFromBuffer(buffer);
        this.lastConnectedTime = bUtil.removeStringFromBuffer(buffer);
        this.progschedUpdatedTime = bUtil.removeStringFromBuffer(buffer);
        this.dac1Cmd = bUtil.removeIntFromBuffer(buffer);
        this.dac2Cmd = bUtil.removeIntFromBuffer(buffer);
    }

    public byte[] getBytes() {
        ByteBufferUtil bUtil = new ByteBufferUtil();
        ByteBuffer buffer = ByteBuffer.allocate(0);
        buffer = bUtil.addToByteBuffer(this.connectStatus, buffer);
        buffer = bUtil.addToByteBuffer(this.currentSched, buffer);
        buffer = bUtil.addToByteBuffer(this.opState, buffer);
        buffer = bUtil.addToByteBuffer(this.badPktCounter, buffer);
        buffer = bUtil.addToByteBuffer(this.lastConnectedTime, Charset.defaultCharset(), buffer);
        buffer = bUtil.addToByteBuffer(this.progschedUpdatedTime, Charset.defaultCharset(), buffer);
        buffer = bUtil.addToByteBuffer(this.dac1Cmd, buffer);
        buffer = bUtil.addToByteBuffer(this.dac2Cmd, buffer);
        return buffer.array();
    }

    public void setConnectStatus(int connectedStatus) {
        this.connectStatus = connectedStatus;
    }

    public void setLastConnectedTime(TimeScale time) {
        this.lastConnectedTime = time.getAsString();
    }

    public void setBadPktCounter(long num) {
        this.badPktCounter = num;
    }

    public void setCurrentSched(int sched) {
        this.currentSched = sched;
    }

    public void setProgschedUpdatedTime(TimeScale time) {
        this.progschedUpdatedTime = time.getAsString();
    }

    public void setOpState(int opstate) {
        this.opState = opstate;
    }

    public int getOpState() {
        return this.opState;
    }

    public int getDac1Cmd() {
        return this.dac1Cmd;
    }

    public int getDac2Cmd() {
        return this.dac2Cmd;
    }
}

