/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.fileio.PortablePath;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ApplicationProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PacketStreamOptions {
    public static final String INBOUND_FILENAME = "InboundPackets.pkt";
    public static final String OUTBOUND_FILENAME = "OutboundPackets.pkt";
    private static File userDirFile = new File(CommonConst.getUserDir());
    private boolean saveInbound = false;
    private boolean saveOutbound = false;
    private PortablePath inboundFilename = new PortablePath(userDirFile, "InboundPackets.pkt");
    private PortablePath outboundFilename = new PortablePath(userDirFile, "OutboundPackets.pkt");
    private BufferedOutputStream ibs;
    private BufferedOutputStream obs;
    public final Object inboundLock = new Object();
    public final Object outboundLock = new Object();
    private String prefix = "";

    public PacketStreamOptions() {
        this("");
    }

    public PacketStreamOptions(String prefix) {
        this.prefix = prefix;
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.saveInbound = false;
        this.saveOutbound = false;
        this.inboundFilename = new PortablePath(userDirFile, INBOUND_FILENAME);
        this.outboundFilename = new PortablePath(userDirFile, INBOUND_FILENAME);
    }

    public void get(ApplicationProperties properties) {
        this.saveInbound = properties.get(String.valueOf(this.prefix) + "SaveInboundPackets", this.saveInbound);
        this.saveOutbound = properties.get(String.valueOf(this.prefix) + "SaveOutboundPackets", this.saveOutbound);
        this.inboundFilename = (PortablePath)properties.get(String.valueOf(this.prefix) + "InboundPacketsFilename", this.inboundFilename);
        this.outboundFilename = (PortablePath)properties.get(String.valueOf(this.prefix) + "OutboundPacketsFilename", this.outboundFilename);
    }

    public void put(ApplicationProperties properties) {
        properties.put(String.valueOf(this.prefix) + "SaveInboundPackets", this.saveInbound);
        properties.put(String.valueOf(this.prefix) + "SaveOutboundPackets", this.saveOutbound);
        properties.put(String.valueOf(this.prefix) + "InboundPacketsFilename", this.inboundFilename);
        properties.put(String.valueOf(this.prefix) + "OutboundPacketsFilename", this.outboundFilename);
    }

    public void set(PacketStreamOptions options) {
        this.prefix = options.prefix;
        this.saveInbound = options.saveInbound;
        this.saveOutbound = options.saveOutbound;
        this.inboundFilename = options.inboundFilename;
        this.outboundFilename = options.outboundFilename;
    }

    public Object clone() {
        PacketStreamOptions options = new PacketStreamOptions();
        options.set(this);
        return options;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof PacketStreamOptions) {
            PacketStreamOptions options = (PacketStreamOptions)obj;
            result = this.saveInbound == options.saveInbound && this.saveOutbound == options.saveOutbound && this.inboundFilename.equals(options.inboundFilename) && this.outboundFilename.equals(options.outboundFilename);
        }
        return result;
    }

    public boolean getSaveInboundEnabled() {
        return this.saveInbound;
    }

    public void setSaveInboundEnabled(boolean value) {
        this.saveInbound = value;
    }

    public boolean getSaveOutboundEnabled() {
        return this.saveOutbound;
    }

    public void setSaveOutboundEnabled(boolean value) {
        this.saveOutbound = value;
    }

    public String getInboundFilename() {
        return this.inboundFilename.getInternal();
    }

    public void setInboundFilename(String value) {
        this.inboundFilename.setInternal(value);
    }

    public String getOutboundFilename() {
        return this.outboundFilename.getInternal();
    }

    public void setOutboundFilename(String value) {
        this.outboundFilename.setInternal(value);
    }

    public void openInbound() throws IOException {
        this.closeInbound();
        this.ibs = new BufferedOutputStream(new FileOutputStream(this.inboundFilename.getInternal()));
    }

    public void closeInbound() {
        if (this.ibs != null) {
            try {
                this.ibs.close();
            }
            catch (IOException ex) {
                Console.printThreadStackTrace(ex);
            }
            this.ibs = null;
        }
    }

    public void writeInbound(byte oneByte) throws IOException {
        this.ibs.write(oneByte);
    }

    public void writeInbound(byte[] data, int len) throws IOException {
        this.ibs.write(data, 0, len);
    }

    public void openOutbound() throws IOException {
        this.closeOutbound();
        this.obs = new BufferedOutputStream(new FileOutputStream(this.outboundFilename.getInternal()));
    }

    public void closeOutbound() {
        if (this.obs != null) {
            try {
                this.obs.close();
            }
            catch (IOException ex) {
                Console.printThreadStackTrace(ex);
            }
            this.obs = null;
        }
    }

    public void writeOutbound(byte oneByte) throws IOException {
        this.obs.write(oneByte);
    }

    public void writeOutbound(byte[] data, int len) throws IOException {
        this.obs.write(data, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStreams() throws IOException {
        Object object = this.inboundLock;
        synchronized (object) {
            if (this.saveInbound) {
                this.openInbound();
            }
        }
        object = this.outboundLock;
        synchronized (object) {
            if (this.saveOutbound) {
                this.openOutbound();
            }
        }
    }
}

