/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.MessageWindow;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import edu.uml.lgdc.instrument.PacketStreamOptions;
import edu.uml.lgdc.instrument.PacketStreamOptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PacketStreamOptionsDialog
extends JDialog {
    boolean ok = false;
    private KeyEventDispatcher keyEventDispatcher;
    private Border borderPnlOK_Cancel = BorderFactory.createBevelBorder(0);
    private BorderLayout pnlMainBorderLayout = new BorderLayout();
    private FlowLayout pnlOK_CancelLayout = new FlowLayout(1, 40, 5);
    private PacketStreamOptionsPanel pnlOptions = new PacketStreamOptionsPanel();
    private JPanel pnlOK_Cancel = new JPanel();
    private JPanel pnlMain = new JPanel();
    private JButton btnOK = new JButton("OK");
    private JButton btnCancel = new JButton("Cancel");

    public PacketStreamOptionsDialog(Frame frame, PacketStreamOptionsPanel pnlOptions) {
        this(frame, pnlOptions, "Packet Stream Options");
    }

    public PacketStreamOptionsDialog(Frame frame, PacketStreamOptionsPanel pnlOptions, String title) {
        super(frame, title, true);
        if (pnlOptions == null) {
            throw new RuntimeException("PacketStreamOptionsDialog.init(): *pnlOptions* is null");
        }
        this.pnlOptions = pnlOptions;
        this.pnlOptions.setBorder(null);
        this.pnlOptions.setFrame(frame);
        this.jbInit();
        this.pack();
        Draw.centerPosition(this, frame);
        this.requestFocus();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = new KeyboardEventDispatcher(this, true);
        keyboardFocusManager.addKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void jbInit() {
        this.pnlMain.setLayout(this.pnlMainBorderLayout);
        this.pnlOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsDialog.this.pnlOptions_actionPerformed(e);
            }
        });
        this.btnOK.setToolTipText("<HTML>Accept changes and close window, <b>Ctrl-Enter</b></HTML>");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsDialog.this.btnOK_actionPerformed(e);
            }
        });
        this.btnOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PacketStreamOptionsDialog.this.btnOK_keyTyped(e);
            }
        });
        this.btnCancel.setToolTipText("<HTML>Cancel changes and close window, <b>Esc</b></HTML>");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsDialog.this.btnCancel_actionPerformed(e);
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PacketStreamOptionsDialog.this.btnCancel_keyTyped(e);
            }
        });
        this.pnlOK_Cancel.setBorder(this.borderPnlOK_Cancel);
        this.pnlOK_Cancel.setLayout(this.pnlOK_CancelLayout);
        this.pnlOK_Cancel.add((Component)this.btnOK, null);
        this.pnlOK_Cancel.add((Component)this.btnCancel, null);
        this.pnlMain.add((Component)this.pnlOptions, "Center");
        this.pnlMain.add((Component)this.pnlOK_Cancel, "South");
        this.getContentPane().add(this.pnlMain);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PacketStreamOptionsDialog.this.keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                PacketStreamOptionsDialog.this.keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PacketStreamOptionsDialog.this.keyReleased(e);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.ok = false;
        }
        super.setVisible(visible);
    }

    @Override
    public void requestFocus() {
        this.pnlOptions.requestFocus();
    }

    public void setFields(PacketStreamOptions options) {
        this.pnlOptions.setFields(options);
    }

    public PacketStreamOptions getOptions() {
        return this.pnlOptions.getOptions();
    }

    public boolean isAccepted() {
        return this.ok;
    }

    private void accept() {
        String errMsg = this.pnlOptions.check();
        if (errMsg == null) {
            this.pnlOptions.accept();
            this.exit(true);
        } else {
            new MessageWindow(errMsg).setVisible(true);
        }
    }

    private void cancel() {
        this.pnlOptions.reset();
        this.exit(false);
    }

    private void exit(boolean ok) {
        this.ok = ok;
        this.setVisible(false);
    }

    private void btnOK_actionPerformed(ActionEvent e) {
        this.accept();
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    private void pnlOptions_actionPerformed(ActionEvent e) {
        this.accept();
    }

    private void btnOK_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.accept();
        }
    }

    private void btnCancel_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.cancel();
        }
    }

    private void keyTyped(KeyEvent e) {
    }

    private void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (keyCode == 27 && modifiers == 0 || keyCode == 115 && modifiers == 512) {
            e.consume();
            this.setVisible(false);
        } else if (keyCode == 10 && modifiers == 128) {
            if (this.btnOK.isVisible() && this.btnOK.isEnabled()) {
                this.accept();
            }
            e.consume();
        }
    }

    private void keyReleased(KeyEvent e) {
    }
}

