/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.datatype.MutableLong;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.time.TimeScale;

public class Payload {
    public static final int ERR_NO_ERROR = 0;
    public static final int ERR_UNKNOWN_PACKET = 1;
    public static final int ERR_BAD_LENGTH = 2;
    public static final int ERR_PAYLOAD_CHECK_ERROR = 3;
    public static final int ERR_UNKNOWN_TYPE = 4;
    public static final String[] ERR_MES = new String[]{"", "Unknown packet", "Bad length", "Error(s) detected inside of payload", "Unknown reply type"};
    public static final int PAYLOAD_MAX_LENGTH = 65532;
    protected int type;
    protected int length;
    protected int maxLength;
    protected byte[] data;
    protected boolean urgent;
    protected boolean out;
    protected Cat category = Cat.MS;
    protected int error = 0;
    protected String errMsg;
    protected boolean checksumError;
    protected boolean escEmulator;
    protected String name;
    protected int minTypeLength;
    protected int maxTypeLength;
    private transient String className;

    public Payload() {
        this.maxLength = 65532;
        this.data = new byte[this.maxLength];
        this.setReadyToReceive();
    }

    public Payload(int maxLength) {
        this.maxLength = maxLength;
        this.data = new byte[maxLength];
        this.setReadyToReceive();
    }

    public Payload(int type, int length, byte[] data) {
        this.setPayload(type, length, data, true);
    }

    public void setPayload(int type, int length, byte[] data, boolean out) {
        this.type = type;
        this.length = length;
        this.data = data;
        this.maxLength = data.length;
        this.out = out;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        this.type = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean getOut() {
        return this.out;
    }

    public String getName() {
        return this.name;
    }

    public void setESCEmulator() {
        this.escEmulator = true;
    }

    public void setReadyToReceive() {
        this.setReadyToReceive(this.data.length);
    }

    public void setReadyToReceive(int payloadMaxLength) {
        if (payloadMaxLength < 0) {
            throw new IllegalArgumentException("payloadMaxLength is negative!");
        }
        if (payloadMaxLength > this.data.length) {
            throw new IllegalArgumentException("payloadMaxLength is too big!");
        }
        this.maxLength = payloadMaxLength;
        this.type = -1;
        this.length = 0;
        this.out = false;
        this.checksumError = false;
    }

    public void setOut(boolean flag) {
        this.out = flag;
    }

    public void setReadyToSend() {
        this.out = true;
    }

    public void setReadyToSend(int type, int length) {
        this.setReadyToSend(type, length, null);
    }

    public void setReadyToSend(int type, int length, byte[] data) {
        if (data != null) {
            this.data = data;
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative!");
        }
        if (length > this.data.length) {
            throw new IllegalArgumentException("length is too big!");
        }
        this.type = type;
        this.length = length;
        this.out = true;
    }

    public boolean getUrgent() {
        return this.urgent;
    }

    public void handle() throws InterruptedException {
        this.handle(null);
    }

    public void handle(MSQueue queue) throws InterruptedException {
    }

    public int check() {
        return 0;
    }

    public void process() throws InterruptedException {
    }

    public void visualize() throws InterruptedException {
    }

    public Cat getCategory() {
        return this.category;
    }

    public boolean isMessage() {
        return this.category == Cat.MS;
    }

    public boolean isMeasurement() {
        return this.category != Cat.MS;
    }

    public void release() throws InterruptedException {
    }

    public void prematureEndOfMeasurement() throws InterruptedException {
    }

    public void finishing() {
    }

    public boolean isPacketTimeAvailable() {
        return false;
    }

    public TimeScale getPacketTime() {
        throw new RuntimeException("illegal call");
    }

    public int getError() {
        return this.error;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String value) {
        this.errMsg = value;
    }

    public String getErrText() {
        return "";
    }

    protected Payload getAckPacket() {
        return null;
    }

    public String getInfoStart() {
        if (this.out) {
            return "sent ";
        }
        return "received ";
    }

    public String getInfoPreposition() {
        if (this.out) {
            return " for ";
        }
        return " from ";
    }

    public void setSpecificPacketTypeParam(String name, int minTypeLength, int maxTypeLength) {
        this.name = name;
        this.minTypeLength = minTypeLength;
        this.maxTypeLength = maxTypeLength;
    }

    public boolean getChecksumError() {
        return this.checksumError;
    }

    public void setChecksumError(boolean checksumError) {
        this.checksumError = checksumError;
    }

    private String getClassName() {
        if (this.className == null) {
            this.className = this.getClass().getName();
            int pos = this.className.lastIndexOf(46);
            if (pos >= 0) {
                this.className = this.className.substring(pos + 1);
            }
        }
        return this.className;
    }

    public static String getErrText(int err, String[] myErrMes) {
        String msg = null;
        if (err >= 0 && err < ERR_MES.length) {
            msg = ERR_MES[err];
        } else {
            int myMesLen;
            int n = myMesLen = myErrMes != null ? myErrMes.length : 0;
            if (err >= ERR_MES.length && err < ERR_MES.length + myMesLen) {
                msg = myErrMes[err - ERR_MES.length];
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextIdent(MutableLong oIdent) {
        long nextIdent = 0L;
        MutableLong mutableLong = oIdent;
        synchronized (mutableLong) {
            long ident;
            nextIdent = ident = oIdent.get();
            ident = ident != Long.MAX_VALUE ? ++ident : 0L;
            oIdent.put(ident);
        }
        return nextIdent;
    }

    public static String getRangeMessage(int start, int end) {
        if (start >= 0 && end >= 0) {
            if (start != end) {
                return "between " + start + " and " + end;
            }
            return "" + start;
        }
        if (end == -1) {
            return "greater or equal than " + start;
        }
        return "less or equal than " + end;
    }

    public static enum Cat {
        SC,
        HK,
        MS;

    }
}

