/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.instrument.RFTransmitter;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.instrument.constants.TxType;
import edu.uml.lgdc.time.TimeScale;
import edu.uml.lgdc.time.TimeType;

public abstract class Platform
implements AbstractPlatform {
    public boolean equals(Object object) {
        boolean result = false;
        String str = null;
        if (object instanceof String) {
            str = (String)object;
        } else if (object instanceof AbstractPlatform) {
            str = !this.isMobile() ? ((AbstractPlatform)object).getUrsi() : ((AbstractPlatform)object).getName();
        }
        if (str != null) {
            result = this.getUniqueName().equalsIgnoreCase(str);
        }
        return result;
    }

    public int hashCode() {
        return this.getUniqueName().toUpperCase().hashCode();
    }

    public String toString() {
        if (!this.isMobile()) {
            return this.getUrsi();
        }
        return this.getName();
    }

    public String toFullString() {
        return "[" + this.getUniqueName() + "," + this.getName() + "," + this.getLatitude() + "," + this.getLongitude() + "]";
    }

    @Override
    public int compareTo(AbstractPlatform station) {
        if (!this.isMobile()) {
            return this.getUrsi().compareToIgnoreCase(station.getUrsi());
        }
        return this.getName().compareToIgnoreCase(station.getName());
    }

    @Override
    public double getLatitude(TimeScale time) {
        if (!this.isMobile()) {
            return this.getLatitude();
        }
        throw new RuntimeException("Should be reimplemented for mobile stations");
    }

    @Override
    public double getLongitude(TimeScale time) {
        if (!this.isMobile()) {
            return this.getLongitude();
        }
        throw new RuntimeException("Should be reimplemented for mobile stations");
    }

    @Override
    public double getLocalTimeShiftInMin(TimeType localTimeType) {
        return TimeScale.getLocalTimeShiftInMin(this.getLongitude(), localTimeType);
    }

    @Override
    public double[] getGEIPosition(TimeScale time) {
        Geopack geopack = new Geopack();
        geopack.recalc(time);
        double[] geo = this.getGEOPosition(time);
        double[] gei = new double[3];
        geopack.GeoToGei(geo, gei);
        return gei;
    }

    public double[] getMagmapPosition(TimeScale time) {
        Geopack geopack = new Geopack();
        geopack.recalc(time);
        double[] geo = this.getGEOPosition(time);
        double[] magmap = new double[3];
        geopack.GeoToMag(geo, magmap);
        Geopack.cartToSpher(magmap);
        Geopack.spherToGeomap(magmap);
        return magmap;
    }

    public double[] getGeomapPosition(TimeScale time) {
        double[] coord = this.getGEOPosition(time);
        Geopack.cartToSpher(coord);
        Geopack.spherToGeomap(coord);
        return coord;
    }

    @Override
    public String getUniqueName() {
        if (!this.isMobile()) {
            return this.getUrsi();
        }
        return this.getName();
    }

    public String getGeographicCoordinatesAsString() {
        return this.getGeographicCoordinatesAsString(false);
    }

    public String getGeographicCoordinatesAsString(boolean fullName) {
        return String.valueOf(Formatter.format("%4.1f", Math.abs(this.getLatitude())).trim()) + " " + Platform.getDirName(this.getLatitude() >= 0.0 ? (char)'N' : 'S', fullName) + "   " + (this.getLongitude() <= 180.0 ? String.valueOf(Formatter.format("%5.1f", Math.abs(this.getLongitude())).trim()) + " " + Platform.getDirName('E', fullName) : String.valueOf(Formatter.format("%5.1f", Math.abs(360.0 - this.getLongitude())).trim()) + " " + Platform.getDirName('W', fullName));
    }

    private static String getDirName(char dirCode, boolean fullName) {
        String dirName = "" + dirCode;
        if (fullName) {
            if (dirCode == 'N') {
                dirName = "North";
            } else if (dirCode == 'S') {
                dirName = "South";
            } else if (dirCode == 'E') {
                dirName = "East";
            } else if (dirCode == 'W') {
                dirName = "West";
            }
        }
        return dirName;
    }

    public RFTransmitter getAsRFTransmitter() {
        return new RFTransmitter(TxType.DIGISONDE, null, this.getUrsi(), this.getName(), this.getLatitude(), this.getLongitude(), -1);
    }

    public StationLocation getLoc() {
        return new StationLocation(this.getUrsi(), this.getName(), this.getLatitude(), this.getLongitude(), -1);
    }

    public abstract boolean getDigitalTransceiverEnabled(boolean var1);
}

