/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.instrument.constants.TxMode;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import edu.uml.lgdc.time.TimeScale;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class QuerySettings
extends SectionDescriptor<QuerySettings> {
    private static final String DEFAULT_SECTION_NAME = "Open Query";
    private static final String PAR_URSI = "StationURSI";
    private static final String PAR_TX_URSI = "TxStationURSI";
    private static final String PAR_START_TIME = "StartTime";
    private static final String PAR_END_TIME = "EndTime";
    private static final String PAR_TX_MODE = "TxMode";
    private static final String PAR_CONSTRAINT = "Constraint";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    protected final String secName;
    private String stationURSI;
    private String txStationURSI;
    private TimeScale startTime;
    private TimeScale endTime;
    private String constraint;
    private TxMode txMode;
    private boolean defaultTxMode = true;
    protected final Map<String, OptionDesc> descriptor;

    public QuerySettings() {
        this(DEFAULT_SECTION_NAME);
    }

    public QuerySettings(String secName) {
        this.secName = secName;
        this.descriptor = new HashMap<String, OptionDesc>();
        this.setDefaults();
        this.fillDescriptor();
    }

    protected void setDefaults() {
        this.stationURSI = "";
        this.txStationURSI = "";
        this.startTime = null;
        this.endTime = null;
        this.constraint = "";
        this.txMode = TxMode.TX_DISABLED_SYNCED_D2D;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(PAR_URSI, new OptionDesc((Object)this.stationURSI, ContentType.QUERY));
        this.descriptor.put(PAR_TX_URSI, new OptionDesc((Object)this.txStationURSI, ContentType.QUERY));
        this.descriptor.put(PAR_START_TIME, new OptionDesc((Object)"", ContentType.QUERY));
        this.descriptor.put(PAR_END_TIME, new OptionDesc((Object)"", ContentType.QUERY));
        this.descriptor.put(PAR_CONSTRAINT, new OptionDesc((Object)this.constraint, ContentType.QUERY));
        this.descriptor.put(PAR_TX_MODE, new OptionDesc((Object)"", ContentType.QUERY));
    }

    @Override
    public QuerySettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return this.secName;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] optionRenameHook(String unknowmParamName, String valueOfUnknownParamName) {
        switch (unknowmParamName) {
            case "stationURSI": {
                return new String[]{PAR_URSI, valueOfUnknownParamName};
            }
            case "txStationURSI": {
                return new String[]{PAR_TX_URSI, valueOfUnknownParamName};
            }
            case "startTime": {
                return new String[]{PAR_START_TIME, valueOfUnknownParamName};
            }
            case "endTime": {
                return new String[]{PAR_END_TIME, valueOfUnknownParamName};
            }
        }
        return null;
    }

    @Override
    public void getFrom(OptionsIO optionsIO) {
        this.stationURSI = optionsIO.get(this.secName, PAR_URSI);
        this.txStationURSI = optionsIO.get(this.secName, PAR_TX_URSI);
        this.startTime = QuerySettings.getTimestampFromString(optionsIO.get(this.secName, PAR_START_TIME), DATETIME_PATTERN);
        this.endTime = QuerySettings.getTimestampFromString(optionsIO.get(this.secName, PAR_END_TIME), DATETIME_PATTERN);
        this.constraint = optionsIO.get(this.secName, PAR_CONSTRAINT);
        String strTxMode = optionsIO.get(this.secName, PAR_TX_MODE);
        if (!strTxMode.isEmpty()) {
            String valueType;
            TxMode mode;
            if (!StrUtil.isOnlyDigits(strTxMode)) {
                mode = TxMode.get(strTxMode);
                valueType = "name";
            } else {
                mode = TxMode.get(Integer.parseInt(strTxMode));
                valueType = "id";
            }
            if (mode != null) {
                this.setTxMode(mode);
            } else {
                Console.showError("Section [" + this.getName() + "] options " + PAR_TX_MODE + ": illegal mode " + valueType + ", " + strTxMode + "\n   legal modes: " + TxMode.getNames());
                this.parsingOrIllegalValueError = true;
            }
        }
    }

    @Override
    public void putTo(OptionsIO optionsIO) {
        optionsIO.put(this.secName, PAR_URSI, this.stationURSI);
        optionsIO.put(this.secName, PAR_TX_URSI, this.txStationURSI);
        if (this.startTime != null) {
            optionsIO.put(this.secName, PAR_START_TIME, this.startTime.toFormatUT(DATETIME_PATTERN));
        } else {
            optionsIO.put(this.secName, PAR_START_TIME, "");
        }
        if (this.endTime != null) {
            optionsIO.put(this.secName, PAR_END_TIME, this.endTime.toFormatUT(DATETIME_PATTERN));
        } else {
            optionsIO.put(this.secName, PAR_END_TIME, "");
        }
        optionsIO.put(this.secName, PAR_CONSTRAINT, this.constraint);
        optionsIO.put(this.secName, PAR_TX_MODE, this.txMode.getName());
    }

    private static TimeScale getTimestampFromString(String value, String timeFormat) {
        try {
            if (value.trim().length() > 0) {
                return TimeScale.getTimestampFromString(value, timeFormat);
            }
            return null;
        }
        catch (ParseException ex) {
            Console.printThreadStackTrace(ex);
            return null;
        }
    }

    public String getStationURSI() {
        return this.stationURSI;
    }

    public void setStationURSI(String stationURSI) {
        this.stationURSI = stationURSI;
    }

    public String getTxStationURSI() {
        return this.txStationURSI;
    }

    public void setTxStationURSI(String txStationURSI) {
        this.txStationURSI = txStationURSI;
    }

    public TimeScale getStartTime() {
        return this.startTime;
    }

    public void setStartTime(TimeScale startTime) {
        this.startTime = startTime;
    }

    public TimeScale getEndTime() {
        return this.endTime;
    }

    public void setEndTime(TimeScale endTime) {
        this.endTime = endTime;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public void setConstraint(String constraint) {
        this.constraint = constraint;
    }

    public TxMode getTxMode() {
        return this.txMode;
    }

    public void setTxMode(TxMode txMode) {
        this.txMode = txMode;
        this.defaultTxMode = false;
    }

    public void changeDefaultTxMode(TxMode txMode) {
        this.txMode = txMode;
    }

    public boolean isDefaultTxMode() {
        return this.defaultTxMode;
    }
}

