/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.instrument.constants.BeaconType;
import edu.uml.lgdc.instrument.constants.TxType;

public class RFTransmitter
implements Comparable<RFTransmitter> {
    private static final int MAX_LENGTH_CODE = 20;
    private static final int MAX_LENGTH_NAME = 50;
    private final TxType txType;
    private final BeaconType beaconType;
    private final String code;
    private final String name;
    private final double latitude_deg;
    private final double longitude_deg;
    private final int databaseIdent;

    public RFTransmitter(TxType txType, BeaconType beaconType, String code, String name, double latitude_deg, double longitude_deg, int id) {
        if (txType == null) {
            throw new RuntimeException("txType == null");
        }
        this.txType = txType;
        if (txType == TxType.BEACON) {
            if (beaconType == null) {
                throw new RuntimeException("txType is Beacon but beaconType == null");
            }
        } else {
            beaconType = null;
        }
        this.beaconType = beaconType;
        if (code == null) {
            throw new RuntimeException("code == null");
        }
        if ((code = code.trim()).length() == 0) {
            throw new RuntimeException("code is empty string");
        }
        if (code.length() > 20) {
            throw new RuntimeException("code.length() > 20");
        }
        this.code = code;
        if (name == null) {
            name = code;
        }
        if ((name = name.trim()).length() > 50) {
            name = name.substring(0, 50);
        } else if (name.length() == 0) {
            name = code;
        }
        this.name = name;
        if (latitude_deg < -90.0 || latitude_deg > 90.0) {
            throw new RuntimeException("latitude_deg < -90 || latitude_deg > 90, " + latitude_deg);
        }
        this.latitude_deg = latitude_deg;
        if (longitude_deg < 0.0 || longitude_deg > 360.0) {
            throw new RuntimeException("longitude_deg < 0 || longitude_deg > 360, " + longitude_deg);
        }
        this.longitude_deg = longitude_deg;
        this.databaseIdent = id;
    }

    public TxType getTxType() {
        return this.txType;
    }

    public BeaconType getBeaconType() {
        return this.beaconType;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude_deg() {
        return this.latitude_deg;
    }

    public double getLongitude_deg() {
        return this.longitude_deg;
    }

    public StationLocation getLoc() {
        return new StationLocation(this.getCode(), this.getName(), this.getLatitude_deg(), this.getLongitude_deg(), this.databaseIdent);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RFTransmitter obj = (RFTransmitter)object;
        if (obj.getTxType() != this.txType) {
            return false;
        }
        if (this.txType == TxType.DIGISONDE || this.beaconType == obj.getBeaconType()) {
            return this.code.equalsIgnoreCase(obj.getCode());
        }
        return false;
    }

    public int hashCode() {
        return (this.txType == TxType.DIGISONDE ? this.txType.getName() : this.beaconType.getName()).hashCode() ^ this.code.toLowerCase().hashCode();
    }

    @Override
    public int compareTo(RFTransmitter o) {
        if (this.txType != o.getTxType()) {
            return this.txType == TxType.DIGISONDE ? 1 : -1;
        }
        if (this.txType == TxType.DIGISONDE || this.beaconType == o.getBeaconType()) {
            return this.code.compareToIgnoreCase(o.getCode());
        }
        if (this.beaconType == BeaconType.RADAR) {
            return 1;
        }
        if (this.beaconType == BeaconType.OTHERS) {
            return -1;
        }
        return o.getBeaconType() == BeaconType.OTHERS ? 1 : -1;
    }

    public String toString() {
        return "[" + this.txType.getName() + (this.txType == TxType.BEACON ? "," + (Object)((Object)this.beaconType) : "") + "," + this.code + "," + this.name + "," + this.latitude_deg + "," + this.longitude_deg + "]";
    }
}

