/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

public class SoftwareVersion {
    private Style versionStyle = Style.MAJOR_MINOR_BUILD;
    private int majorVersion;
    private int minorVersion;
    private int protocolVersion;
    private int buildVersion;

    public SoftwareVersion() {
        this(Style.MAJOR_MINOR_BUILD);
    }

    public SoftwareVersion(Style style) {
        this.setStyle(style);
    }

    public void setStyle(Style style) {
        this.versionStyle = style;
    }

    public Style getStyle() {
        return this.versionStyle;
    }

    public void set(int version1) {
        this.set(version1, 0);
    }

    public void set(int version1, int version2) {
        this.set(version1, version2, 0);
    }

    public void set(int version1, int version2, int version3) {
        if (this.versionStyle == Style.MAJOR_PROTOCOL_MINOR || this.versionStyle == Style.MAJOR_PROTOCOL) {
            this.majorVersion = version1;
            this.protocolVersion = version2;
            this.minorVersion = version3;
            this.buildVersion = 0;
        } else {
            this.majorVersion = version1;
            this.minorVersion = version2;
            this.buildVersion = version3;
            this.protocolVersion = 0;
        }
    }

    public void set(SoftwareVersion input) {
        this.setStyle(input.versionStyle);
        this.unpack(input.pack());
    }

    public String toString() {
        switch (this.versionStyle) {
            case MAJOR: {
                return "" + this.majorVersion;
            }
            case MAJOR_MINOR: {
                return this.majorVersion + "." + this.minorVersion;
            }
            case MAJOR_MINOR_BUILD: {
                return this.majorVersion + "." + this.minorVersion + "." + this.buildVersion;
            }
            case MAJOR_PROTOCOL: {
                return this.majorVersion + "." + this.protocolVersion;
            }
            case MAJOR_PROTOCOL_MINOR: {
                return this.majorVersion + "." + this.protocolVersion + "." + this.minorVersion;
            }
        }
        return "";
    }

    public int pack() {
        switch (this.versionStyle) {
            case MAJOR: {
                return this.majorVersion;
            }
            case MAJOR_MINOR: {
                return (this.majorVersion << 8) + this.minorVersion;
            }
            case MAJOR_PROTOCOL: {
                return (this.majorVersion << 8) + this.protocolVersion;
            }
            case MAJOR_MINOR_BUILD: {
                return (this.majorVersion << 16) + (this.minorVersion << 8) + this.buildVersion;
            }
            case MAJOR_PROTOCOL_MINOR: {
                return (this.majorVersion << 16) + (this.protocolVersion << 8) + this.minorVersion;
            }
        }
        return 0;
    }

    public void unpack(int packedVersion) {
        switch (this.versionStyle) {
            case MAJOR: {
                this.set(packedVersion);
                break;
            }
            case MAJOR_MINOR: 
            case MAJOR_PROTOCOL: {
                this.set(packedVersion >> 8, packedVersion & 0xFF);
                break;
            }
            case MAJOR_MINOR_BUILD: 
            case MAJOR_PROTOCOL_MINOR: {
                this.set(packedVersion >> 16, packedVersion >> 8 & 0xFF, packedVersion & 0xFF);
            }
        }
    }

    public void parse(String strValue) {
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        String[] items = strValue.split("\\.");
        if (items.length > 0) {
            v1 = Integer.valueOf(items[0]);
        }
        if (items.length > 1) {
            v2 = Integer.valueOf(items[1]);
        }
        if (items.length > 2) {
            v3 = Integer.valueOf(items[2]);
        }
        this.set(v1, v2, v3);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public static enum Style {
        MAJOR,
        MAJOR_MINOR,
        MAJOR_PROTOCOL,
        MAJOR_MINOR_BUILD,
        MAJOR_PROTOCOL_MINOR;

    }
}

