/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.geospace.EarthSphere;
import edu.uml.lgdc.geospace.GroundCoord;
import edu.uml.lgdc.instrument.Platform;
import edu.uml.lgdc.instrument.RFTransmitter;
import java.util.Objects;

public class StationLink
implements Comparable<StationLink> {
    private final Platform rx;
    private final RFTransmitter tx;
    private GroundCoord midpointLocation;
    private double groundDistance_km;
    private EarthSphere earthSphere = new EarthSphere();
    private transient int hash;

    public StationLink(Platform rx, RFTransmitter tx) {
        this.tx = tx;
        this.rx = rx;
        this.groundDistance_km = this.earthSphere.distanceOnEarth_km(this.getRxStation().getLatitude(), this.getRxStation().getLongitude(), this.getTxStation().getLatitude_deg(), this.getTxStation().getLongitude_deg());
        double[] mid = new EarthSphere().midpointOnEarth(this.getRxStation().getLatitude(), this.getRxStation().getLongitude(), this.getTxStation().getLatitude_deg(), this.getTxStation().getLongitude_deg());
        this.midpointLocation = new GroundCoord(mid[0], mid[1]);
    }

    public String getTxCode() {
        return this.tx.getCode();
    }

    public String getRxCode() {
        return this.rx.getUrsi();
    }

    public String toString() {
        return String.valueOf(this.getTxCode()) + "-->" + this.getRxCode();
    }

    @Override
    public int compareTo(StationLink stationLink) {
        Objects.requireNonNull(stationLink, "radioLink must not be null");
        int comp = this.getRxCode().toLowerCase().compareTo(stationLink.getRxCode().toLowerCase());
        if (comp != 0) {
            return comp;
        }
        return this.getTxCode().toLowerCase().compareTo(stationLink.getTxCode().toLowerCase());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            StationLink link = (StationLink)obj;
            return this.getRxCode().equalsIgnoreCase(link.getRxCode()) && this.getTxCode().equalsIgnoreCase(link.getTxCode());
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 31 * h + this.getTxCode().toLowerCase().hashCode();
            this.hash = h = 31 * h + this.getRxCode().toLowerCase().hashCode();
        }
        return h;
    }

    public double[] getRxCoordinates() {
        return new double[]{this.rx.getLatitude(), this.rx.getLongitude()};
    }

    public double[] getTxCoordinates() {
        return new double[]{this.tx.getLatitude_deg(), this.tx.getLongitude_deg()};
    }

    public Platform getRxStation() {
        return this.rx;
    }

    public RFTransmitter getTxStation() {
        return this.tx;
    }

    public GroundCoord getMidpointLocation() {
        return this.midpointLocation;
    }

    public double getGroundDistance_km() {
        return this.groundDistance_km;
    }
}

