/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument.constants;

import java.util.HashMap;
import java.util.Map;

public enum BeaconType {
    RADAR(1, "Radar"),
    IONOSONDE(2, "Ionosonde"),
    OTHERS(3, "Others");

    private static final Map<Integer, BeaconType> mapById;
    private static final Map<String, BeaconType> mapByName;
    private final int id;
    private final String name;

    static {
        mapById = new HashMap<Integer, BeaconType>();
        mapByName = new HashMap<String, BeaconType>();
        BeaconType[] beaconTypeArray = BeaconType.values();
        int n = beaconTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeaconType beaconType = beaconTypeArray[n2];
            if (mapById.put(beaconType.getId(), beaconType) != null) {
                throw new RuntimeException("design error: duplicate id's " + beaconType.getId());
            }
            if (mapByName.put(beaconType.getName().toLowerCase(), beaconType) != null) {
                throw new RuntimeException("design error: duplicate name's " + beaconType.getName());
            }
            ++n2;
        }
    }

    private BeaconType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static BeaconType get(int id) {
        return mapById.get(id);
    }

    public static BeaconType get(String name) {
        return mapById.get(name.toLowerCase());
    }
}

