/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum TxMode {
    UNKNOWN_COMBINATION(0, "UnknownSoundingOperation", true, "unknown sounding operation"),
    NOT_SOUNDING_OPER(1, "NotSoundingOperation", true, "not sounding operation"),
    TX_ENABLED_VERTICAL(2, "TxEnabledVerticalListen", true, "Tx enabled, vertical"),
    TX_DISABLED_CW_LISTEN(3, "TxDisabledCWListen", false, "Tx disabled, CW listening"),
    TX_DISABLED_SYNCED_D2D(4, "TxDisabledOtherDigisondeListen", false, "Oblique D2D reception in sync to another Digisonde: listen only"),
    TX_ENABLED_SYNCED_D2D(5, "SyncedAndTransmitting", false, "Oblique D2D sounding in sync to another Digisonde: transmissions enabled");

    private static final Map<Integer, TxMode> MAP_BY_ID;
    private static final Map<String, TxMode> MAP_BY_NAME;
    private static final List<String> txModeNames;
    private static final Set<TxMode> txEnabledModes;
    private static final Set<TxMode> txDisabledModes;
    private static final Set<Integer> txEnabledModeIds;
    private static final Set<Integer> txDisabledModeIds;
    private final int id;
    private final String name;
    private final boolean txEnabled;
    private final String desc;

    static {
        MAP_BY_ID = new HashMap<Integer, TxMode>();
        MAP_BY_NAME = new HashMap<String, TxMode>();
        txModeNames = new ArrayList<String>();
        txEnabledModes = new HashSet<TxMode>();
        txDisabledModes = new HashSet<TxMode>();
        txEnabledModeIds = new HashSet<Integer>();
        txDisabledModeIds = new HashSet<Integer>();
        TxMode[] txModeArray = TxMode.values();
        int n = txModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TxMode txMode = txModeArray[n2];
            if (MAP_BY_ID.put(txMode.getId(), txMode) != null) {
                throw new RuntimeException("design error: duplicated id, " + txMode.getId());
            }
            if (MAP_BY_NAME.put(txMode.getName().toLowerCase(), txMode) != null) {
                throw new RuntimeException("design error: duplicated name, " + txMode.getName());
            }
            txModeNames.add(txMode.getName());
            if (txMode.txEnabled) {
                txEnabledModes.add(txMode);
                txEnabledModeIds.add(txMode.getId());
            } else {
                txDisabledModes.add(txMode);
                txDisabledModeIds.add(txMode.getId());
            }
            ++n2;
        }
    }

    private TxMode(int id, String name, boolean txEnabled, String desc) {
        this.id = id;
        this.name = name;
        this.txEnabled = txEnabled;
        this.desc = desc;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTxEnabled() {
        return this.txEnabled;
    }

    public String getDesc() {
        return this.desc;
    }

    public static TxMode get(int id) {
        return MAP_BY_ID.get(id);
    }

    public static TxMode get(String name) {
        return MAP_BY_NAME.get(name.toLowerCase());
    }

    public static List<String> getNames() {
        return txModeNames;
    }

    public static Set<TxMode> getTxEnabledModes() {
        return txEnabledModes;
    }

    public static Set<TxMode> getTxDisabledModes() {
        return txDisabledModes;
    }

    public static Set<Integer> getTxEnabledModeIds() {
        return txEnabledModeIds;
    }

    public static Set<Integer> getTxDisabledModeIds() {
        return txDisabledModeIds;
    }
}

