/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.BasicDataList;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.List;

public class CRB<S extends AbstractPlatform, E extends TimeOrderedMetric> {
    private BasicDataList<S, E> dl;
    private int stationIndex = -1;
    private int[] recordIndex = new int[0];
    private int stQty;
    private S bookmarkedStation;
    private List<S> bookmarkedStations = new ArrayList<S>();
    private List<E> bookmarkedRecords = new ArrayList();

    public CRB(BasicDataList<S, E> dl) {
        this.dl = dl;
        this.init();
    }

    public void init() {
        this.save();
        this.stationIndex = -1;
    }

    public void save() {
        this.bookmarkedStation = this.dl.getStation(this.stationIndex);
        int stInd = -1;
        int i = 0;
        while (i < this.stQty) {
            E record = this.dl.getRecord(i, this.recordIndex[i]);
            if (record != null) {
                S station = this.dl.getStation(i);
                stInd = this.bookmarkedStations.indexOf(station);
                if (stInd < 0) {
                    this.bookmarkedStations.add(station);
                    this.bookmarkedRecords.add(record);
                } else {
                    this.bookmarkedStations.add(stInd, station);
                    this.bookmarkedRecords.add(stInd, record);
                }
            }
            ++i;
        }
    }

    public void restore() {
        this.stationIndex = this.dl.getStationIndex(this.bookmarkedStation);
        this.stQty = this.dl.getStationsQty();
        this.recordIndex = new int[this.stQty];
        int i = 0;
        while (i < this.stQty) {
            this.recordIndex[i] = -1;
            ++i;
        }
        TimeOrderedMetric record = null;
        int i2 = 0;
        while (i2 < this.bookmarkedStations.size()) {
            int recInd;
            int stInd = this.dl.getStationIndex((AbstractPlatform)this.bookmarkedStations.get(i2));
            if (stInd >= 0 && (recInd = this.dl.indexOf(stInd, record = (TimeOrderedMetric)this.bookmarkedRecords.get(i2))) >= 0) {
                this.recordIndex[stInd] = recInd;
            }
            ++i2;
        }
    }

    public BasicDataList<S, E> getDataList() {
        return this.dl;
    }

    public int getStationIndex() {
        return this.stationIndex;
    }

    public void setStationIndex(int stInd) {
        if (stInd >= 0 && stInd < this.stQty) {
            this.stationIndex = stInd;
        }
    }

    public int getRecordIndex() {
        return this.getRecordIndex(this.stationIndex);
    }

    public int getRecordIndex(int stInd) {
        if (stInd >= 0 && stInd < this.stQty) {
            return this.recordIndex[stInd];
        }
        return -1;
    }

    public void setRecordIndex(int index) {
        this.setRecordIndex(this.stationIndex, index);
    }

    public void setRecordIndex(int stInd, int recInd) {
        if (stInd >= 0 && stInd < this.stQty) {
            this.recordIndex[stInd] = recInd;
        }
    }

    public void delete() {
        this.delete(this.stationIndex, this.recordIndex[this.stationIndex]);
    }

    public void delete(int stInd, int index) {
        int deleteCode = this.dl.delete(stInd, index);
        if (deleteCode == 1) {
            if (this.recordIndex[stInd] >= this.dl.getSize(stInd)) {
                this.recordIndex[stInd] = this.dl.getSize(stInd) - 1;
            }
        } else if (deleteCode == 2) {
            this.remove_Station(stInd);
        }
    }

    public void deleteStation() {
        this.dl.deleteStation(this.stationIndex);
    }

    public void deleteAll() {
        this.dl.initData();
        this.dl.restoreCurrents();
    }

    void remove_Station(int stInd) {
        --this.stQty;
        int[] newRecordIndex = new int[this.stQty];
        int j = 0;
        int i = 0;
        while (i <= this.stQty) {
            if (i != stInd) {
                newRecordIndex[j] = this.recordIndex[i];
                ++j;
            }
            ++i;
        }
        this.recordIndex = newRecordIndex;
        if (this.stationIndex > stInd) {
            --this.stationIndex;
        } else if (this.stationIndex == stInd && this.stationIndex >= this.stQty) {
            --this.stationIndex;
        }
    }

    public List<S> getStations() {
        return this.dl.getStations();
    }

    public int getStationsQty() {
        return this.stQty;
    }

    public BasicRecordList<E> getRecordList() {
        return this.getRecordList(this.stationIndex);
    }

    public BasicRecordList<E> getRecordList(int stInd) {
        return this.dl.getRecordList(stInd);
    }

    public int getSize() {
        return this.getSize(this.stationIndex);
    }

    public int getSize(int stInd) {
        return this.dl.getSize(this.stationIndex);
    }

    public int getTotalSize() {
        return this.dl.getTotalSize();
    }

    public double getFirstTimeInMinutes() {
        return this.getFirstTimeInMinutes(this.stationIndex);
    }

    public TimeScale getFirstTime() {
        return this.getFirstTime(this.stationIndex);
    }

    public double getFirstTimeInMinutes(int stInd) {
        return this.dl.getFirstTimeInMinutes(stInd);
    }

    public TimeScale getFirstTime(int stInd) {
        return this.dl.getFirstTime(stInd);
    }

    public double getLastTimeInMinutes() {
        return this.getLastTimeInMinutes(this.stationIndex);
    }

    public TimeScale getLastTime() {
        return this.getLastTime(this.stationIndex);
    }

    public double getLastTimeInMinutes(int stInd) {
        return this.dl.getLastTimeInMinutes(stInd);
    }

    public TimeScale getLastTime(int stInd) {
        return this.dl.getLastTime(stInd);
    }

    public int getRightNearest(TimeScale time) {
        return this.getRightNearest(this.stationIndex, time);
    }

    public int getRightNearest(int stInd, TimeScale time) {
        return this.dl.getRightNearest(stInd, time);
    }

    public int getLeftNearest(TimeScale time) {
        return this.getLeftNearest(this.stationIndex, time);
    }

    public int getLeftNearest(int stInd, TimeScale time) {
        return this.dl.getLeftNearest(stInd, time);
    }

    public int getClosest(TimeScale time) {
        return this.getClosest(this.stationIndex, time);
    }

    public int getClosest(int stInd, TimeScale time) {
        return this.getClosest(stInd, time);
    }

    public int indexOf(E record, int startInd, int endInd) {
        return this.indexOf(this.stationIndex, record, startInd, endInd);
    }

    public int indexOf(int stInd, E record, int startInd, int endInd) {
        return this.dl.indexOf(stInd, record, startInd, endInd);
    }

    public double getMostProbableInterval() {
        return this.getMostProbableInterval(this.stationIndex);
    }

    public double getMostProbableInterval(int stInd) {
        return this.dl.getMostProbableInterval(stInd);
    }

    public boolean isEmpty() {
        return this.isEmpty(this.stationIndex);
    }

    public boolean isEmpty(int stInd) {
        return this.dl.isEmpty(stInd);
    }

    public boolean isTotalEmpty() {
        return this.dl.isTotalEmpty();
    }

    public AbstractPlatform getStation() {
        return this.getStation(this.stationIndex);
    }

    public AbstractPlatform getStation(int stInd) {
        return this.dl.getStation(stInd);
    }

    public void leaveElements(TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        this.leaveElements(this.stationIndex, start, end, offsetInSeconds, stepInSeconds, windowInSeconds);
    }

    public double getSolarTimeShiftInMin() {
        return this.getSolarTimeShiftInMin(this.stationIndex);
    }

    public double getSolarTimeShiftInMin(int stInd) {
        throw new RuntimeException("not implemented");
    }

    public int getStationIndex(String ursi) {
        return this.dl.getStationIndex(ursi);
    }

    public int getStationIndex(S station) {
        return this.dl.getStationIndex(station);
    }

    public TimeOrderedMetric getRecord(String ursi, int ind) {
        return this.getRecord(this.getStationIndex(ursi), ind);
    }

    public TimeOrderedMetric getRecord(String timeStr) {
        return this.getRecord(this.stationIndex, timeStr);
    }

    public TimeOrderedMetric getRecord(int stInd, String timeStr) {
        return this.getRecord(stInd, new TimeScale(timeStr));
    }

    public TimeOrderedMetric getRecord(TimeScale time) {
        return this.getRecord(this.stationIndex, time);
    }

    public TimeOrderedMetric getRecord(int stInd, TimeScale time) {
        return this.getRecord(stInd, this.getRecordIndex(stInd, time));
    }

    public int getRecordIndex(String timeStr) {
        return this.getRecordIndex(this.stationIndex, timeStr);
    }

    public int getRecordIndex(int stInd, String timeStr) {
        return this.getRecordIndex(stInd, new TimeScale(timeStr));
    }

    public int getRecordIndex(TimeScale time) {
        return this.getRecordIndex(this.stationIndex, time);
    }

    public int getRecordIndex(int stInd, TimeScale time) {
        return this.getRecordIndex(stInd, this.dl.createRecord(time));
    }

    public int getRecordIndex(E record) {
        return this.getRecordIndex(this.stationIndex, record);
    }

    public int getRecordIndex(int stInd, E record) {
        return this.dl.indexOf(stInd, record);
    }

    public TimeOrderedMetric getRecord() {
        return this.getRecord(this.stationIndex);
    }

    public TimeOrderedMetric getRecord(int stInd) {
        if (stInd >= 0 && stInd < this.stQty) {
            return this.getRecord(stInd, this.recordIndex[stInd]);
        }
        return null;
    }

    public TimeOrderedMetric getRecord(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stQty) {
            return this.dl.getRecord(stInd, ind);
        }
        return null;
    }

    public void leaveElements(int stInd, TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        this.dl.leaveElements(stInd, start, end, offsetInSeconds, stepInSeconds, windowInSeconds);
    }

    public String createName(int entryType) {
        if (this.stationIndex < 0 && this.recordIndex[this.stationIndex] < 0) {
            return null;
        }
        return this.createName(this.stationIndex, this.recordIndex[this.stationIndex], entryType);
    }

    public String createTempName(int entryType) {
        if (this.stationIndex < 0 && this.recordIndex[this.stationIndex] < 0) {
            return null;
        }
        return this.createTempName(this.stationIndex, this.recordIndex[this.stationIndex], entryType);
    }

    public String createFileName(int entryType) {
        if (this.stationIndex < 0 && this.recordIndex[this.stationIndex] < 0) {
            return null;
        }
        return this.createFileName(this.stationIndex, this.recordIndex[this.stationIndex], entryType);
    }

    public String createTempFileName(int entryType) {
        if (this.stationIndex < 0 && this.recordIndex[this.stationIndex] < 0) {
            return null;
        }
        return this.createTempFileName(this.stationIndex, this.recordIndex[this.stationIndex], entryType);
    }

    public String createName(int stInd, int index, int entryType) {
        if (stInd < 0 && index < 0) {
            return null;
        }
        return this.dl.createName(stInd, index, entryType);
    }

    public String createTempName(int stInd, int index, int entryType) {
        if (stInd < 0 && index < 0) {
            return null;
        }
        return this.dl.createTempName(stInd, index, entryType);
    }

    public String createFileName(int stInd, int index, int entryType) {
        if (stInd < 0 && index < 0) {
            return null;
        }
        return this.dl.createFileName(stInd, index, entryType);
    }

    public String createTempFileName(int stInd, int index, int entryType) {
        if (stInd < 0 && index < 0) {
            return null;
        }
        return this.dl.createTempFileName(stInd, index, entryType);
    }
}

