/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.list.CapsuleDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Capsule<E extends TimeOrderedMetric>
extends TimeOrderedMetric {
    protected CapsuleDesc dsc;
    protected List<Map<Integer, E>> entries;
    protected double timeInMin;

    protected Capsule(CapsuleDesc dsc, double timeInMin) {
        this.dsc = dsc;
        this.timeInMin = timeInMin;
        int maxNumberOfEntries = dsc.getQtyOfEntryTypes();
        this.entries = new ArrayList<Map<Integer, E>>(maxNumberOfEntries);
        int i = 0;
        while (i < maxNumberOfEntries) {
            this.entries.add(null);
            ++i;
        }
    }

    @Override
    public double getTimeInMinutes() {
        return this.timeInMin;
    }

    public CapsuleDesc getCapsuleDesc() {
        return this.dsc;
    }

    public String getDescMnem() {
        return this.dsc.getMnem();
    }

    public boolean add(E entry, int type, int producerId) {
        this.checkType(type);
        Class<?> expectedClass = this.dsc.getClass(type);
        if (!expectedClass.isInstance(entry)) {
            throw new RuntimeException("illegal class, " + entry.getClass().getName() + ", not assignment-compatible with capsule element " + "of type " + expectedClass.getName() + ", of capsule index " + type);
        }
        Map<Integer, E> entryMap = this.entries.get(type);
        if (entryMap == null) {
            entryMap = new HashMap<Integer, E>();
        }
        entryMap.put(producerId, entry);
        this.entries.set(type, entryMap);
        return true;
    }

    public String toString() {
        return String.valueOf(this.getTime().toString()) + " " + this.getSignStr();
    }

    protected String getSignStr() {
        int qty = this.dsc.getQtyOfEntryTypes();
        char[] sign = new char[qty];
        int i = 0;
        while (i < qty) {
            sign[i] = this.entries.get(i) == null ? 95 : this.dsc.getCharIdent(i);
            ++i;
        }
        return new String(sign);
    }

    public boolean isEntryPresent(int type) {
        this.checkType(type);
        Map<Integer, E> entryMap = this.entries.get(type);
        return entryMap != null && !entryMap.isEmpty();
    }

    public E getEntry(int type, int producerId) {
        this.checkType(type);
        Map<Integer, E> entryMap = this.entries.get(type);
        if (entryMap == null || entryMap.isEmpty()) {
            return null;
        }
        if (producerId != -1) {
            return (E)((TimeOrderedMetric)entryMap.get(producerId));
        }
        return (E)((TimeOrderedMetric)entryMap.values().iterator().next());
    }

    public E getRawestEntry() {
        int i = 0;
        while (i < this.dsc.getQtyOfEntryTypes()) {
            if (this.entries.get(i) != null) {
                return this.getEntry(i, -1);
            }
            ++i;
        }
        return null;
    }

    private void checkType(int type) {
        if (!this.typeOK(type)) {
            throw new RuntimeException("type is out of range, " + type);
        }
    }

    private boolean typeOK(int type) {
        return type >= 0 && type < this.dsc.getQtyOfEntryTypes();
    }
}

