/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.list.EntryType;
import edu.uml.lgdc.math.Search;
import java.io.File;
import java.util.HashSet;

public abstract class CapsuleDesc {
    public static final int DATA_FILE_TYPE_UNKNOWN = -1;
    public static final int DATA_TYPE_UNKNOWN = -1;
    protected final String mnem;
    protected EntryType[] entryTypes;
    protected final String[] dataFileExtensions;

    public CapsuleDesc(String mnem, EntryType[] types) {
        EntryType type;
        if (mnem == null) {
            throw new IllegalArgumentException("mnem is null");
        }
        if (types == null) {
            throw new IllegalArgumentException("entry type array is null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("entry type array is empty");
        }
        int counter = 0;
        EntryType[] entryTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            type = entryTypeArray[n2];
            counter += type.getSuffixes().length;
            ++n2;
        }
        this.dataFileExtensions = new String[counter];
        counter = 0;
        entryTypeArray = types;
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            type = entryTypeArray[n2];
            String[] stringArray = type.getSuffixes();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String ext = stringArray[n4];
                this.dataFileExtensions[counter++] = ext;
                ++n4;
            }
            ++n2;
        }
        int[] parentIndeces = new int[types.length];
        counter = 0;
        EntryType[] entryTypeArray2 = types;
        int n5 = types.length;
        n = 0;
        while (n < n5) {
            EntryType type2 = entryTypeArray2[n];
            int n6 = counter++;
            parentIndeces[n6] = parentIndeces[n6] + type2.getParentIndex();
            ++n;
        }
        String errMsg = this.checkForLoops(parentIndeces);
        if (errMsg != null) {
            throw new IllegalArgumentException("Loop encountered in parentIndexes: " + errMsg);
        }
        this.mnem = mnem;
        this.entryTypes = types;
    }

    public String getMnem() {
        return this.mnem;
    }

    public int getQtyOfEntryTypes() {
        return this.entryTypes.length;
    }

    public String[] getGroupedDataFileExtensions(int entryIndex) {
        return this.entryTypes[entryIndex].getExtensions();
    }

    public String[] getDataFileExtensions() {
        return this.dataFileExtensions;
    }

    public Class<?> getClass(int entryIndex) {
        return this.entryTypes[entryIndex].getEntryClass();
    }

    public char getCharIdent(int entryIndex) {
        return this.entryTypes[entryIndex].getCharIdent();
    }

    public String getShortName(int entryIndex) {
        return this.entryTypes[entryIndex].getShortName();
    }

    public int getParentIndex(int entryIndex) {
        return this.entryTypes[entryIndex].getParentIndex();
    }

    public int getEntryIndex(String fileName) {
        String ext = FileRW.getExt(fileName);
        int i = 0;
        while (i < this.entryTypes.length) {
            if (Search.scanStrIgnoreCase(this.entryTypes[i].getExtensions(), ext) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getEntryIndex(Object entry) {
        int i = 0;
        while (i < this.entryTypes.length) {
            if (this.entryTypes[i].getClass().isInstance(entry)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String checkForLoops(int[] parentIndexes) {
        boolean[] checked = new boolean[parentIndexes.length];
        int[] loop = new int[parentIndexes.length];
        int i = 0;
        while (i < parentIndexes.length) {
            int next = i;
            int toCheckLoop = i;
            int loopLength = 0;
            while (true) {
                if (loopLength > 0 && next == toCheckLoop) {
                    return this.createLoopMes(loop, loopLength);
                }
                if (checked[next]) break;
                checked[next] = true;
                loop[loopLength++] = next;
                if (parentIndexes[next] == -1) break;
                next = parentIndexes[next];
            }
            ++i;
        }
        return null;
    }

    private String createLoopMes(int[] loop, int length) {
        String msg = "" + loop[0];
        int i = 1;
        while (i < length) {
            msg = String.valueOf(msg) + "," + loop[i];
            ++i;
        }
        return msg;
    }

    public EntryType findByFilename(String filename) {
        String lowcaseName = filename.toLowerCase();
        EntryType[] entryTypeArray = this.entryTypes;
        int n = this.entryTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EntryType type = entryTypeArray[n2];
            String[] stringArray = type.getSuffixes();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String suffix = stringArray[n4];
                if (lowcaseName.endsWith(suffix)) {
                    return type;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public String[] findCompanions(String filename) {
        HashSet<String> companions = new HashSet<String>();
        EntryType parentType = this.findByFilename(filename);
        if (parentType != null) {
            String prefixFilename = this.getFilenamePrefix(filename, parentType);
            EntryType[] entryTypeArray = this.entryTypes;
            int n = this.entryTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EntryType companionType = entryTypeArray[n2];
                if (!companionType.equals(parentType)) {
                    String[] stringArray = companionType.getSuffixes();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String companionSuffix = stringArray[n4];
                        String testFilename1 = String.valueOf(prefixFilename) + companionSuffix;
                        String testFilename2 = String.valueOf(prefixFilename) + companionSuffix.toUpperCase();
                        if (new File(testFilename1).isFile()) {
                            companions.add(testFilename1);
                            break;
                        }
                        if (new File(testFilename2).isFile()) {
                            companions.add(testFilename2);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return companions.toArray(new String[companions.size()]);
    }

    public String getFilenamePrefix(String filename, EntryType type) {
        String lowercaseName = filename.toLowerCase();
        String[] stringArray = type.getSuffixes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (lowercaseName.endsWith(suffix)) {
                return filename.substring(0, filename.length() - suffix.length());
            }
            ++n2;
        }
        return "";
    }
}

