/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.Capsule;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.time.TimeScale;

public abstract class CapsuleRecordList<E extends TimeOrderedMetric, T extends Capsule<E>>
extends BasicRecordList<T> {
    public T createCapsule(double timeInMinutes) {
        return (T)((Capsule)this.createRecord(timeInMinutes));
    }

    public T createCapsule(TimeScale time) {
        return this.createCapsule(time.getTimeInMinutes());
    }

    public boolean addEntry(E entry, int entryType, int producerId) {
        boolean result = false;
        T record = this.createCapsule(entry.getTimeInMinutes());
        int ind = Search.rightNearest(this.list, record);
        boolean addIt = true;
        if (ind == -1) {
            ind = this.list.size();
        } else if (((Capsule)this.list.get(ind)).getTimeInMinutes() == ((Capsule)record).getTimeInMinutes()) {
            addIt = false;
        }
        if (addIt) {
            result = ((Capsule)record).add(entry, entryType, producerId);
            if (result) {
                if (ind == this.list.size()) {
                    this.add_record(record);
                } else {
                    this.insert_record(record, ind);
                }
            }
        } else {
            result = this.addEntry(entry, entryType, producerId, ind);
        }
        return result;
    }

    public boolean isEntryPresent(int index, int entryType) {
        if (index >= 0 && index < this.totalRecords()) {
            return ((Capsule)this.getCapsule(index)).isEntryPresent(entryType);
        }
        return false;
    }

    public E getEntry(int index, int entryType) {
        if (index >= 0 && index < this.totalRecords()) {
            return ((Capsule)this.getCapsule(index)).getEntry(entryType, -1);
        }
        return null;
    }

    public T getCapsule(int index) {
        return (T)((Capsule)this.getRecord(index));
    }

    private boolean addEntry(E entry, int entryType, int producerId, int index) {
        Capsule record = (Capsule)this.list.get(index);
        return record.add(entry, entryType, producerId);
    }

    public int totalRecords(int entryType) {
        int count = 0;
        int i = 0;
        while (i < this.totalRecords()) {
            if (this.isEntryPresent(i, entryType)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getFirstIndex(int entryType) {
        int index = -1;
        int i = 0;
        while (i < this.totalRecords()) {
            if (this.isEntryPresent(i, entryType)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int getLastIndex(int entryType) {
        int index = -1;
        int i = this.totalRecords() - 1;
        while (i >= 0) {
            if (this.isEntryPresent(i, entryType)) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }
}

