/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.ClusteredRecord;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.time.TimeScale;

public abstract class ClusteredRecordList<E extends TimeOrderedMetric, T extends ClusteredRecord<E>>
extends BasicRecordList<T> {
    public T createClusteredRecord(double timeInMinutes) {
        return (T)((ClusteredRecord)this.createRecord(timeInMinutes));
    }

    public T createClusteredRecord(TimeScale time) {
        return this.createClusteredRecord(time.getTimeInMinutes());
    }

    public boolean addEntry(E entry, int entryType) {
        boolean result = false;
        T record = this.createClusteredRecord(entry.getTimeInMinutes());
        int ind = Search.rightNearest(this.list, record);
        boolean addIt = true;
        if (ind == -1) {
            ind = this.list.size();
        } else if (((ClusteredRecord)this.list.get(ind)).getTimeInMinutes() == ((ClusteredRecord)record).getTimeInMinutes()) {
            addIt = false;
        }
        if (addIt) {
            result = ((ClusteredRecord)record).add(entry, entryType);
            if (result) {
                if (ind == this.list.size()) {
                    this.add_record(record);
                } else {
                    this.insert_record(record, ind);
                }
            }
        } else {
            result = this.addEntry(entry, entryType, ind);
        }
        return result;
    }

    public boolean isEntryPresent(int index, int entryType) {
        if (index >= 0 && index < this.totalRecords()) {
            return ((ClusteredRecord)this.getClusteredRecord(index)).isEntryPresent(entryType);
        }
        return false;
    }

    public E getEntry(int index, int entryType) {
        if (index >= 0 && index < this.totalRecords()) {
            return ((ClusteredRecord)this.getClusteredRecord(index)).getEntry(entryType);
        }
        return null;
    }

    public T getClusteredRecord(int index) {
        return (T)((ClusteredRecord)this.getRecord(index));
    }

    private boolean addEntry(E entry, int entryType, int index) {
        ClusteredRecord record = (ClusteredRecord)this.list.get(index);
        return record.add(entry, entryType);
    }

    public int totalRecords(int entryType) {
        int count = 0;
        int i = 0;
        while (i < this.totalRecords()) {
            if (this.isEntryPresent(i, entryType)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getFirstIndex(int entryType) {
        int index = -1;
        int i = 0;
        while (i < this.totalRecords()) {
            if (this.isEntryPresent(i, entryType)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int getLastIndex(int entryType) {
        int index = -1;
        int i = this.totalRecords() - 1;
        while (i >= 0) {
            if (this.isEntryPresent(i, entryType)) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }
}

