/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.instrument.ReadSettings_Ix;
import edu.uml.lgdc.list.EntryLocation;
import edu.uml.lgdc.list.PersistentEntry;
import edu.uml.lgdc.project.IllegalDataFieldException;
import java.io.IOException;

public abstract class PersistentEntryData
implements Cloneable {
    protected PersistentEntry host = null;
    protected boolean produce = false;

    protected PersistentEntryData() {
    }

    protected PersistentEntryData(PersistentEntry host) throws IOException, IllegalDataFieldException {
        this.read(host);
    }

    protected abstract void read(ReadSettings_Ix var1) throws IOException, IllegalDataFieldException;

    public synchronized void read(PersistentEntry entry) throws IOException, IllegalDataFieldException {
        if (this.produce) {
            throw new IOException("Should close produced data first");
        }
        if (entry == null) {
            throw new IOException("Host entry shouldn't be null");
        }
        if (this.host != null && entry != this.host) {
            throw new IOException("EntryData.read: Previous host should explicitly close data before new one will use it as container");
        }
        this.host = entry;
        this.read(entry.getLocation().getReadSettings());
    }

    public void setHost(PersistentEntry entry) throws IOException {
        if (this.host == null) {
            EntryLocation location = entry.getLocation();
            if (location == null) {
                location = entry.createEmptyLocation();
                entry.setLocation(location);
            }
            if (location.getFileID() != -1 || location.getMeasurementId() != -1 || location.getRecalcEntryFile() != null) {
                throw new IOException("entry location should be empty");
            }
        } else {
            throw new IOException("this Entry Data is already bound to an Entry");
        }
        this.host = entry;
    }

    public synchronized void close(PersistentEntry entry) throws IOException {
        if (entry == null) {
            throw new IOException("entry shouldn't be null");
        }
        if (this.host != null && entry != this.host) {
            throw new IOException("Only host entry can explicitly close data");
        }
        this.host = null;
    }

    public synchronized void close() throws IOException {
        if (this.host != null) {
            throw new IOException("This is not produced data");
        }
        this.produce = false;
    }

    public synchronized Object clone(PersistentEntry entry) {
        try {
            PersistentEntryData dataEntry = (PersistentEntryData)super.clone();
            dataEntry.host = entry;
            return dataEntry;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

