/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.EmptyEntry;
import edu.uml.lgdc.list.EntryDataList;
import edu.uml.lgdc.list.PersistentEntryRecordList;
import edu.uml.lgdc.time.TimeScale;

public abstract class PersistentEntryDataList
extends EntryDataList {
    @Override
    public TimeOrderedMetric createRecord(double timeInMinutes) {
        if (this.getStationsQty() > 0) {
            return ((PersistentEntryRecordList)this.getRecordList(0)).createRecord(timeInMinutes);
        }
        return new EmptyEntry(timeInMinutes);
    }

    public BasicRecordList createRecordList() {
        return new PersistentEntryRecordList();
    }

    public void clear() {
        int stInd = 0;
        while (stInd < this.getStationsQty()) {
            this.clear(stInd);
            ++stInd;
        }
    }

    public void clear(int stInd) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            ((PersistentEntryRecordList)this.getRecordList(stInd)).clear();
            this.deleteStation(stInd);
        }
    }

    @Override
    public void leaveElements(int stInd, TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            PersistentEntryRecordList recordList = (PersistentEntryRecordList)this.getRecordList(stInd);
            recordList.leaveElements(start, end, offsetInSeconds, stepInSeconds, windowInSeconds);
            if (recordList.totalRecords() == 0) {
                this.deleteStation(stInd);
            }
        }
    }
}

