/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.EmptyEntry;
import edu.uml.lgdc.list.Entry;
import edu.uml.lgdc.list.EntryRecordList;
import edu.uml.lgdc.list.PersistentEntry;
import edu.uml.lgdc.time.TimeScale;

public class PersistentEntryRecordList
extends EntryRecordList {
    @Override
    public Entry createRecord(double timeInMinutes) {
        if (this.totalRecords() > 0) {
            return ((PersistentEntry)this.getRecord(0)).createEmptyPersistentEntry(timeInMinutes);
        }
        return new EmptyEntry(timeInMinutes);
    }

    @Override
    public BasicRecordList createRecordList() {
        return new PersistentEntryRecordList();
    }

    public void close() {
        int i = 0;
        while (i < this.totalRecords()) {
            ((PersistentEntry)this.getRecord(i)).close();
            ++i;
        }
        super.clear();
    }

    @Override
    public void leaveElements(TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        if (this.totalRecords() == 0) {
            return;
        }
        int i = 0;
        while (i < this.totalRecords()) {
            if (!BasicRecordList.isHit(this.getTime(i), start, end, offsetInSeconds, stepInSeconds, windowInSeconds)) {
                ((PersistentEntry)this.getRecord(i)).close();
                this.delete(i);
                --i;
            }
            ++i;
        }
    }
}

