/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R2;

public class Complex
extends R2 {
    public static final Complex im1 = new Complex(0.0, 1.0);

    public Complex() {
    }

    public Complex(Complex c) {
        this(c.getRe(), c.getIm());
    }

    public Complex(double re, double im) {
        super(re, im);
    }

    public double getRe() {
        return this.getX();
    }

    public void setRe(double re) {
        this.setX(re);
    }

    public double getIm() {
        return this.getY();
    }

    public void setIm(double im) {
        this.setY(im);
    }

    public double getModulus() {
        return this.length();
    }

    public double abs() {
        return this.length();
    }

    public double getPhase() {
        return this.phaseAngle();
    }

    public Complex multiply(Complex c) {
        double re = this.getRe();
        double im = this.getIm();
        this.setTo(re * c.getRe() - im * c.getIm(), re * c.getIm() + im * c.getRe());
        return this;
    }

    public Complex conjugate() {
        this.setIm(-this.getIm());
        return this;
    }

    public Complex getConjugated() {
        return new Complex(this).conjugate();
    }

    public static Complex multiply(Complex c1, Complex c2) {
        return new Complex(c1).multiply(c2);
    }

    public Complex sqrt() {
        double r = Math.sqrt(this.getModulus());
        double theta = this.getPhase() / 2.0;
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public Complex reciprocate() {
        double len2 = this.getRe() * this.getRe() + this.getIm() * this.getIm();
        this.setTo(this.getRe() / len2, -this.getIm() / len2);
        return this;
    }

    public Complex getReciprocal() {
        return new Complex(this).reciprocate();
    }

    public Complex log() {
        double r = this.getModulus();
        double d = Math.atan(this.getIm() / this.getRe());
        if (this.getRe() < 0.0) {
            d += Math.PI;
        }
        this.setTo(Math.log(r), d);
        return this;
    }

    public static Complex atan2(Complex x, Complex y) {
        Complex x2 = new Complex(x.getRe() * x.getRe(), x.getIm() * x.getIm());
        Complex y2 = new Complex(y.getRe() * y.getRe(), y.getIm() * y.getIm());
        Complex sqrt = new Complex((Complex)x2.add(y2)).sqrt();
        Complex x_plus_iy = (Complex)new Complex(y).multiply(im1).add(x);
        Complex arg = new Complex(x_plus_iy).multiply(sqrt.getReciprocal());
        Complex log = arg.log();
        return (Complex)log.multiply(im1).scalar(-1.0);
    }
}

