/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R2;

public class Distribution2 {
    static final int X_DEFAULT_HISTOGRAM_LEVELS = 32;
    static final int Y_DEFAULT_HISTOGRAM_LEVELS = 32;
    static final int X_MAX_BINS_IN_HISTOGRAM = 16;
    static final double X_MIN_BIN_SIZE = 8.0;
    static final int Y_MAX_BINS_IN_HISTOGRAM = 16;
    static final double Y_MIN_BIN_SIZE = 8.0;
    private int xHistogramLevels = 32;
    private int yHistogramLevels = 32;
    private double xFillValue = Double.NaN;
    private double yFillValue = Double.NaN;
    private boolean xCutTrailingFillValues = true;
    private boolean yCutTrailingFillValues = true;
    public int[][] histogram = null;
    public R2 mode;
    public R2 max;
    public R2 min;
    public R2 mean;
    public R2 sum;
    private boolean xAutoBinQtyCalc = false;
    private int xMaxBinsInHistogram = 16;
    private double xMinBinSize = 8.0;
    private boolean yAutoBinQtyCalc = false;
    private int yMaxBinsInHistogram = 16;
    private double yMinBinSize = 8.0;

    public Distribution2() {
        this.setHistogramLevels(32, 32);
    }

    public Distribution2(int xHL, int yHL) {
        this.setHistogramLevels(xHL, yHL);
    }

    public Distribution2(boolean xAutoBinQtyCalc, boolean yAutoBinQtyCalc) {
        this(xAutoBinQtyCalc, 8.0, 16, yAutoBinQtyCalc, 8.0, 16);
    }

    public Distribution2(boolean xAutoBinQtyCalc, double xMinBinSize, int xMaxBinsInHistogram, boolean yAutoBinQtyCalc, double yMinBinSize, int yMaxBinsInHistogram) {
        this.setAutoBinQtyCalc(xAutoBinQtyCalc, xMinBinSize, xMaxBinsInHistogram, yAutoBinQtyCalc, yMinBinSize, yMaxBinsInHistogram);
    }

    public void setHistogramLevels(int xHL, int yHL) {
        this.xHistogramLevels = Math.max(xHL, 1);
        this.yHistogramLevels = Math.max(yHL, 1);
    }

    public void setAutoBinQtyCalc(boolean xAutoBinQtyCalc, boolean yAutoBinQtyCalc) {
        this.setAutoBinQtyCalc(xAutoBinQtyCalc, this.xMinBinSize, this.xMaxBinsInHistogram, yAutoBinQtyCalc, this.yMinBinSize, this.yMaxBinsInHistogram);
    }

    public void setAutoBinQtyCalc(boolean xAutoBinQtyCalc, double xMinBinSize, int xMaxBinsInHistogram, boolean yAutoBinQtyCalc, double yMinBinSize, int yMaxBinsInHistogram) {
        this.xAutoBinQtyCalc = xAutoBinQtyCalc;
        this.xMinBinSize = xMinBinSize;
        this.xMaxBinsInHistogram = xMaxBinsInHistogram;
        this.yAutoBinQtyCalc = yAutoBinQtyCalc;
        this.yMinBinSize = yMinBinSize;
        this.yMaxBinsInHistogram = yMaxBinsInHistogram;
    }

    public void setFillValue(double xFill, double yFill) {
        this.xFillValue = xFill;
        this.yFillValue = yFill;
    }

    public void setCutTrailingFillValues(boolean xFlag, boolean yFlag) {
        this.xCutTrailingFillValues = xFlag;
        this.yCutTrailingFillValues = yFlag;
    }

    public void calculate(R2[] a) {
        this.calculate(a, a.length);
    }

    public void calculate(R2[] a, int len) {
        int last_index = this.getLastIndex(a, len);
        int count = 0;
        this.min = new R2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.max = new R2(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.sum = new R2(0.0, 0.0);
        this.mode = null;
        boolean xCheckFillValue = !Double.isNaN(this.xFillValue);
        boolean yCheckFillValue = !Double.isNaN(this.xFillValue);
        int i = 0;
        while (i <= last_index) {
            if (!(xCheckFillValue && a[i].getX() == this.xFillValue || yCheckFillValue && a[i].getY() == this.yFillValue)) {
                ++count;
                this.sum.add(a[i]);
                if (a[i].getX() > this.max.getX()) {
                    this.max.setX(a[i].getX());
                }
                if (a[i].getY() > this.max.getY()) {
                    this.max.setY(a[i].getY());
                }
                if (a[i].getX() < this.min.getX()) {
                    this.min.setX(a[i].getX());
                }
                if (a[i].getY() < this.min.getY()) {
                    this.min.setY(a[i].getY());
                }
            }
            ++i;
        }
        this.mean = new R2(this.sum.getX() / (double)count, this.sum.getY() / (double)count);
        if (this.max.getX() == Double.NEGATIVE_INFINITY) {
            this.mode = null;
        } else if (this.xHistogramLevels == 1 && this.yHistogramLevels == 1) {
            this.mode = this.mean;
        } else {
            int xHistLevels = this.xHistogramLevels;
            if (this.xAutoBinQtyCalc && (xHistLevels = Math.min(this.xMaxBinsInHistogram, (int)((this.max.getX() - this.min.getX()) / this.xMinBinSize))) == 0) {
                xHistLevels = 1;
            }
            double xStep = (this.max.getX() - this.min.getX()) / (double)xHistLevels;
            int yHistLevels = this.yHistogramLevels;
            if (this.yAutoBinQtyCalc && (yHistLevels = Math.min(this.yMaxBinsInHistogram, (int)((this.max.getY() - this.min.getY()) / this.yMinBinSize))) == 0) {
                yHistLevels = 1;
            }
            double yStep = (this.max.getY() - this.min.getY()) / (double)yHistLevels;
            int[][] histogram = new int[xHistLevels][yHistLevels];
            i = 0;
            while (i <= last_index) {
                if (!(xCheckFillValue && a[i].getX() == this.xFillValue || yCheckFillValue && a[i].getY() == this.yFillValue)) {
                    int yIndex;
                    int xIndex = (int)((a[i].getX() - this.min.getX()) / xStep);
                    if (xIndex > xHistLevels - 1) {
                        xIndex = xHistLevels - 1;
                    }
                    if (xIndex < 0) {
                        xIndex = 0;
                    }
                    if ((yIndex = (int)((a[i].getY() - this.min.getY()) / yStep)) > yHistLevels - 1) {
                        yIndex = yHistLevels - 1;
                    }
                    if (yIndex < 0) {
                        yIndex = 0;
                    }
                    int[] nArray = histogram[xIndex];
                    int n = yIndex;
                    nArray[n] = nArray[n] + 1;
                }
                ++i;
            }
            int xBest = 0;
            int yBest = 0;
            i = 0;
            while (i < xHistLevels) {
                int j = 0;
                while (j < yHistLevels) {
                    if (histogram[i][j] > histogram[xBest][yBest]) {
                        xBest = i;
                        yBest = j;
                    }
                    ++j;
                }
                ++i;
            }
            this.mode = new R2();
            this.mode.setX(this.min.getX() + (double)xBest * xStep + xStep / 2.0);
            this.mode.setY(this.min.getY() + (double)yBest * yStep + yStep / 2.0);
        }
    }

    private int getLastIndex(R2[] a, int length) {
        boolean yCheckFillValue;
        int last_index = Math.min(a.length - 1, length - 1);
        boolean xCheckFillValue = !Double.isNaN(this.xFillValue);
        boolean bl = yCheckFillValue = !Double.isNaN(this.yFillValue);
        if (this.xCutTrailingFillValues && xCheckFillValue || this.yCutTrailingFillValues && yCheckFillValue) {
            int i = a.length - 1;
            while (i > 0) {
                if ((!this.xCutTrailingFillValues || !xCheckFillValue || a[i].getX() != this.xFillValue) && (!this.yCutTrailingFillValues || !yCheckFillValue || a[i].getY() != this.yFillValue)) break;
                last_index = i - 1;
                --i;
            }
        }
        return last_index;
    }
}

