/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import java.util.ArrayList;
import java.util.List;

public final class ExtMath {
    private static final double LOG_10_BASE_E = Math.log(10.0);
    private static final double SMALL_NUMBER = 1.0E-10;
    public static final double TWO_PI = Math.PI * 2;
    public static final double NATURAL_TO_DECIMAL_LOG = 1.0 / LOG_10_BASE_E;
    public static double[] xunit = new double[]{1.0, 0.0, 0.0};
    public static double[] yunit = new double[]{0.0, 1.0, 0.0};
    public static double[] zunit = new double[]{0.0, 0.0, 1.0};

    public static final double log10(double a) {
        return Math.log(a) * NATURAL_TO_DECIMAL_LOG;
    }

    public static final double log(double a, double b) {
        return Math.log(a) / Math.log(b);
    }

    public static double angleAB(double[] a, double[] b) {
        double cos = (a[0] * b[0] + a[1] * b[1] + a[2] * b[2]) / (Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]) * Math.sqrt(b[0] * b[0] + b[1] * b[1] + b[2] * b[2]));
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        return Math.acos(cos);
    }

    public static final boolean areClose(double val1, double val2) {
        return ExtMath.areClose(val1, val2, ExtMath.getEpsilon(val1, val2));
    }

    public static final boolean areClose(double val1, double val2, double epsilon) {
        return Math.abs(val1 - val2) < epsilon;
    }

    public static final boolean isGreater(double val1, double val2) {
        return ExtMath.isGreater(val1, val2, ExtMath.getEpsilon(val1, val2));
    }

    public static final boolean isGreater(double val1, double val2, double epsilon) {
        return val1 - val2 > epsilon;
    }

    public static final boolean isLess(double val1, double val2) {
        return ExtMath.isLess(val1, val2, ExtMath.getEpsilon(val1, val2));
    }

    public static final boolean isLess(double val1, double val2, double epsilon) {
        return val2 - val1 > epsilon;
    }

    public static final double closestNotLess(double borderValue, double factor) {
        double minValue = borderValue / factor;
        if (ExtMath.isLess(minValue = factor * Math.floor(minValue + ExtMath.getEpsilon(minValue)), borderValue)) {
            minValue += factor;
        }
        return minValue;
    }

    public static final double closestNotGreater(double borderValue, double factor) {
        double maxValue = borderValue / factor;
        maxValue = factor * Math.floor(maxValue + ExtMath.getEpsilon(maxValue));
        return maxValue;
    }

    public static int minOf(int ... values) {
        int min = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static int maxOf(int ... values) {
        int max = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static double minOf(double ... values) {
        double min = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static double maxOf(double ... values) {
        double max = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static final boolean isMultiple(double value, double factor) {
        return ExtMath.areClose(ExtMath.closestNotLess(value, factor), value);
    }

    public static int[] getAllDivisors(int dividend) {
        if (dividend <= 0) {
            throw new RuntimeException("dividend <= 0");
        }
        ArrayList<Integer> lstDivisors = new ArrayList<Integer>(100);
        int divisor = ExtMath.getNextDivisor(dividend, -1);
        do {
            lstDivisors.add(divisor);
        } while ((divisor = ExtMath.getNextDivisor(dividend, divisor)) > 0);
        int[] divisors = new int[lstDivisors.size()];
        int i = 0;
        while (i < divisors.length) {
            divisors[i] = (Integer)lstDivisors.get(i);
            ++i;
        }
        return divisors;
    }

    public static int getGCD(int number1, int number2) {
        int rest;
        int greaterNumber;
        int gcd;
        if (number1 <= 0) {
            throw new IllegalArgumentException("number1 <= 0");
        }
        if (number2 <= 0) {
            throw new IllegalArgumentException("number2 <= 0");
        }
        if (number1 <= number2) {
            gcd = number1;
            greaterNumber = number2;
        } else {
            gcd = number2;
            greaterNumber = number1;
        }
        while ((rest = greaterNumber % gcd) != 0) {
            greaterNumber = gcd;
            gcd = rest;
        }
        return gcd;
    }

    public static long getLCM(int number1, int number2) {
        if (number1 <= 0) {
            throw new IllegalArgumentException("number1 <= 0");
        }
        if (number2 <= 0) {
            throw new IllegalArgumentException("number2 <= 0");
        }
        return (long)number1 * (long)(number2 / ExtMath.getGCD(number1, number2));
    }

    public static int[][] getPrimeFactorization(int naturalNumber) {
        if (naturalNumber <= 1) {
            throw new IllegalArgumentException("naturalNumber <= 1");
        }
        int[] primeDivisors = ExtMath.getAllPrimeDivisors(naturalNumber);
        int[][] factorization = new int[primeDivisors.length][2];
        int i = 0;
        while (i < primeDivisors.length) {
            factorization[i][0] = primeDivisors[i];
            factorization[i][1] = 1;
            if (primeDivisors[i] != 1) {
                int tmp = naturalNumber / primeDivisors[i];
                while (tmp >= primeDivisors[i] && tmp % primeDivisors[i] == 0) {
                    int[] nArray = factorization[i];
                    nArray[1] = nArray[1] + 1;
                    tmp /= primeDivisors[i];
                }
            }
            ++i;
        }
        return factorization;
    }

    public static int[] getAllPrimeDivisors(int naturalNumber) {
        boolean added;
        if (naturalNumber <= 1) {
            throw new IllegalArgumentException("naturalNumber <= 1");
        }
        int[] divisors = new int[]{};
        ArrayList<Integer> lstPrimeDivisors = new ArrayList<Integer>(128);
        while (added = ExtMath.addNextPrimeDivisor(naturalNumber, lstPrimeDivisors)) {
        }
        divisors = new int[lstPrimeDivisors.size()];
        int i = 0;
        while (i < divisors.length) {
            divisors[i] = (Integer)lstPrimeDivisors.get(i);
            ++i;
        }
        return divisors;
    }

    private static boolean isPrimeNumber(int naturalNumber, List<Integer> prevPrimeNumbers) {
        int size = prevPrimeNumbers.size();
        int i = 0;
        while (i < size) {
            int primeNumber = prevPrimeNumbers.get(i);
            if (naturalNumber % primeNumber == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPrimeNumber(int naturalNumber) {
        if (naturalNumber < 1) {
            throw new IllegalArgumentException("naturalNumber < 1");
        }
        if (naturalNumber == 1) {
            return true;
        }
        return ExtMath.getNextDivisor(naturalNumber, 1) == naturalNumber;
    }

    public static int getNextPrime(int naturalNumber) {
        boolean isPrimeNumber;
        while (!(isPrimeNumber = ExtMath.isPrimeNumber(++naturalNumber))) {
        }
        return naturalNumber;
    }

    public static int getNextDivisor(int naturalNumber, int prevDivisor) {
        int divisor = -1;
        if (prevDivisor <= 0) {
            divisor = 1;
        } else if (prevDivisor < naturalNumber) {
            divisor = prevDivisor + 1;
            int dividend_2 = naturalNumber / 2;
            while (divisor <= dividend_2 && naturalNumber % divisor != 0) {
                ++divisor;
            }
            if (divisor > dividend_2) {
                divisor = naturalNumber;
            }
        }
        return divisor;
    }

    private static boolean addNextPrimeDivisor(int naturalNumber, List<Integer> prevPrimeDivisors) {
        if (naturalNumber <= 1) {
            throw new IllegalArgumentException("naturalNumber <= 1");
        }
        boolean added = false;
        int numberOfPrevDivisors = prevPrimeDivisors.size();
        int i = 0;
        while (i < numberOfPrevDivisors) {
            int quotient;
            int primeDivisor = prevPrimeDivisors.get(i);
            while ((quotient = naturalNumber % primeDivisor) == 0) {
                naturalNumber = quotient;
            }
            ++i;
        }
        int prevDivisor = numberOfPrevDivisors > 0 ? prevPrimeDivisors.get(numberOfPrevDivisors - 1) : 1;
        int nextDivisor = -1;
        if (naturalNumber > 1) {
            nextDivisor = prevDivisor + 1;
            int dividend_2 = naturalNumber / 2;
            while (!(nextDivisor > dividend_2 || naturalNumber % nextDivisor == 0 && ExtMath.isPrimeNumber(nextDivisor, prevPrimeDivisors))) {
                ++nextDivisor;
            }
            if (nextDivisor <= dividend_2) {
                added = true;
            } else if (ExtMath.isPrimeNumber(naturalNumber, prevPrimeDivisors)) {
                nextDivisor = naturalNumber;
                added = true;
            }
        }
        if (added) {
            prevPrimeDivisors.get(new Integer(nextDivisor));
        }
        return added;
    }

    private static final double getEpsilon(double val1, double val2) {
        double epsilon = 1.0E-10 * Math.max(Math.abs(val1), Math.abs(val2));
        if (1.0E-10 + epsilon == 1.0E-10) {
            epsilon = 1.0E-11;
        }
        return epsilon;
    }

    private static final double getEpsilon(double val) {
        double epsilon = 1.0E-10 * Math.abs(val);
        if (1.0E-10 + epsilon == 1.0E-10) {
            epsilon = 1.0E-10;
        }
        return epsilon;
    }

    public static final boolean containsInAngleInterval(double testAngle, double startAngle, double endAngle) {
        block3: {
            block2: {
                if (!(testAngle < startAngle)) break block2;
                while (testAngle < startAngle) {
                    testAngle += 360.0;
                }
                break block3;
            }
            if (!(testAngle > endAngle)) break block3;
            while (testAngle > endAngle) {
                testAngle -= 360.0;
            }
        }
        return testAngle >= startAngle && testAngle <= endAngle;
    }

    public static double tanh(double x) {
        double a = Math.exp(x);
        double b = Math.exp(-x);
        return (a - b) / (a + b);
    }

    public static double restrictValue(double value, double min, double max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static int restrictValue(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static double rangeAngle_rad(double radians) {
        if (radians >= Math.PI * 2) {
            radians %= Math.PI * 2;
        } else if (radians < 0.0 && (radians = -radians % (Math.PI * 2)) > 0.0) {
            radians = Math.PI * 2 - radians;
        }
        if (radians >= Math.PI * 2) {
            radians = 0.0;
        }
        return radians;
    }

    public static double rangeAngle_deg(double degrees) {
        if (degrees >= 360.0) {
            degrees %= 360.0;
        } else if (degrees < 0.0 && (degrees = -degrees % 360.0) > 0.0) {
            degrees = 360.0 - degrees;
        }
        if (degrees >= 360.0) {
            degrees = 0.0;
        }
        return degrees;
    }

    public static double rangeAngleSigned(double radians) {
        if ((radians = ExtMath.rangeAngle_rad(radians)) > Math.PI) {
            radians -= Math.PI * 2;
        }
        return radians;
    }

    public static double rangeAngleSigned_deg(double degrees) {
        if ((degrees = ExtMath.rangeAngle_deg(degrees)) > 180.0) {
            degrees -= 360.0;
        }
        return degrees;
    }

    public static int closestGreaterOdd(int value) {
        if (value % 2 == 0) {
            ++value;
        }
        return value;
    }

    public static double dbToLin(double in) {
        return Math.pow(10.0, in / 20.0);
    }

    public static double linToDb(double in) {
        return 20.0 * ExtMath.log10(in);
    }

    public static int greaterOf(int a, int b) {
        return a > b ? a : b;
    }

    public static int smallerOf(int a, int b) {
        return a > b ? b : a;
    }

    public static double greaterOf(double a, double b) {
        return a > b ? a : b;
    }

    public static double smallerOf(double a, double b) {
        return a > b ? b : a;
    }

    public static int getExactLogOf2(int value) {
        int log2 = -1;
        int i = 0;
        while (i < 31) {
            if ((value & 1) == 1) {
                if (log2 == -1) {
                    log2 = i;
                } else {
                    return -1;
                }
            }
            if ((value >>= 1) == 0) break;
            ++i;
        }
        return log2;
    }
}

