/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R2;
import java.awt.geom.PathIterator;
import java.util.Arrays;

public class QuadPathIterator
implements PathIterator {
    private double[] xArr;
    private double[] yArr;
    private int nPoints;
    private boolean closed = false;
    private boolean isLastSegment = false;
    private int nextPosInArray = 0;
    private int segType;
    private double[] currSegment = new double[6];

    private static double[] getXArray(R2[] p) {
        double[] x = new double[p.length];
        int i = 0;
        while (i < p.length) {
            x[i] = p[i].getX();
            ++i;
        }
        return x;
    }

    private static double[] getYArray(R2[] p) {
        double[] y = new double[p.length];
        int i = 0;
        while (i < p.length) {
            y[i] = p[i].getY();
            ++i;
        }
        return y;
    }

    public QuadPathIterator(R2[] p) {
        this(p, false);
    }

    public QuadPathIterator(R2[] p, boolean closed) {
        this(QuadPathIterator.getXArray(p), QuadPathIterator.getYArray(p), closed);
    }

    public QuadPathIterator(double[] xArr, double[] yArr) {
        this(xArr, yArr, false);
    }

    public QuadPathIterator(double[] xArr, double[] yArr, boolean closed) {
        this(xArr, yArr, closed, xArr.length);
    }

    public QuadPathIterator(double[] xArr, double[] yArr, boolean closed, int nPoints) {
        this.nPoints = nPoints;
        this.closed = closed;
        if (nPoints != 0) {
            this.xArr = Arrays.copyOf(xArr, nPoints);
            this.yArr = Arrays.copyOf(yArr, nPoints);
        } else {
            this.isLastSegment = true;
        }
    }

    @Override
    public boolean isDone() {
        return this.isLastSegment;
    }

    @Override
    public void next() {
        if (this.isLastSegment) {
            return;
        }
        if (this.nextPosInArray < this.nPoints) {
            if (this.nextPosInArray == 0) {
                this.segType = 0;
                this.currSegment[0] = this.xArr[this.nextPosInArray];
                this.currSegment[1] = this.yArr[this.nextPosInArray];
                ++this.nextPosInArray;
            } else if (this.nPoints - this.nextPosInArray >= 2) {
                this.segType = 2;
                this.currSegment[0] = this.xArr[this.nextPosInArray];
                this.currSegment[1] = this.yArr[this.nextPosInArray];
                this.currSegment[2] = this.xArr[this.nextPosInArray + 1];
                this.currSegment[3] = this.yArr[this.nextPosInArray + 1];
                this.nextPosInArray += 2;
            } else {
                this.segType = 1;
                this.currSegment[0] = this.xArr[this.nextPosInArray];
                this.currSegment[1] = this.yArr[this.nextPosInArray];
                ++this.nextPosInArray;
            }
            if (!this.closed && this.nextPosInArray >= this.nPoints) {
                this.isLastSegment = true;
            }
        } else {
            this.segType = 4;
            this.isLastSegment = true;
        }
    }

    @Override
    public int currentSegment(double[] segment) {
        int i = 0;
        while (i < 6) {
            segment[i] = this.currSegment[i];
            ++i;
        }
        return this.segType;
    }

    @Override
    public int currentSegment(float[] segment) {
        int i = 0;
        while (i < 6) {
            segment[i] = (float)this.currSegment[i];
            ++i;
        }
        return this.segType;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }
}

