/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.DoubleArray;
import edu.uml.lgdc.datatype.OrderedMetricable;
import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class Search {
    public static int scan(Object[] objects, Object whatToFind) {
        return Search.scan(objects, whatToFind, 0, objects.length - 1);
    }

    public static int scan(Object[] objects, Object whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind.equals(objects[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int scan(List<?> objects, Object whatToFind) {
        return Search.scan(objects, whatToFind, 0, objects.size() - 1);
    }

    public static int scan(List<?> objects, Object whatToFind, int left, int right) {
        int index = objects.subList(left, right + 1).indexOf(whatToFind);
        if (index >= 0) {
            return left + index;
        }
        return -1;
    }

    public static int strictScan(Object[] objects, Object whatToFind) {
        return Search.strictScan(objects, whatToFind, 0, objects.length - 1);
    }

    public static int strictScan(Object[] objects, Object whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind == objects[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int strictScan(List<?> objects, Object whatToFind) {
        int i = 0;
        while (i < objects.size()) {
            if (whatToFind == objects.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int strictScan(List<?> objects, Object whatToFind, int left, int right) {
        int index = Search.strictScan(objects.subList(left, right + 1), whatToFind);
        if (index >= 0) {
            return left + index;
        }
        return -1;
    }

    public static int scan(int[] values, int whatToFind) {
        return Search.scan(values, whatToFind, 0, values.length - 1);
    }

    public static int scan(int[] values, int whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind == values[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int scan(char[] values, char whatToFind) {
        return Search.scan(values, whatToFind, 0, values.length - 1);
    }

    public static int scan(char[] values, char whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind == values[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int scan(long[] values, long whatToFind) {
        return Search.scan(values, whatToFind, 0, values.length - 1);
    }

    public static int scan(long[] values, long whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind == values[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int scan(double[] values, double whatToFind) {
        return Search.scan(values, whatToFind, 0, values.length - 1);
    }

    public static int scan(double[] values, double whatToFind, int left, int right) {
        int i = left;
        while (i <= right) {
            if (whatToFind == values[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int scanStr(String[] strings, String str) {
        return Search.scan(strings, (Object)str);
    }

    public static int scanStrIgnoreCase(String[] strings, String str) {
        return Search.scanStr(strings, str, true);
    }

    public static int scanStr(String[] strings, String str, boolean ignoreCase) {
        if (ignoreCase) {
            int i = 0;
            while (i < strings.length) {
                if (str.equalsIgnoreCase(strings[i])) {
                    return i;
                }
                ++i;
            }
        } else {
            return Search.scan(strings, (Object)str);
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int binarySearch(T[] objects, T whatToFind) {
        return Search.binarySearch(objects, whatToFind, (int)0, (int)(objects.length - 1));
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Comparable<? super T>> int binarySearch(T[] objects, T whatToFind, int left, int right) {
        if (left > right) {
            return -1;
        }
        if (whatToFind.compareTo(objects[left]) < 0 || objects[right].compareTo(whatToFind) < 0) {
            return -1;
        }
        if (whatToFind.compareTo(objects[right]) != 0) ** GOTO lbl12
        return right;
lbl-1000:
        // 1 sources

        {
            middle = (left + right) / 2;
            if (whatToFind.compareTo(objects[middle]) < 0) {
                right = middle;
                continue;
            }
            left = middle;
lbl12:
            // 3 sources

            ** while (right - left > 1)
        }
lbl13:
        // 1 sources

        if (whatToFind.compareTo(objects[left]) == 0) {
            return left;
        }
        return -1;
    }

    public static int binarySearch(List<String> objects, String whatToFind) {
        return Search.binarySearch(objects, whatToFind, 0, objects.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public static int binarySearch(List<String> objects, String whatToFind, int left, int right) {
        if (left > right) {
            return -1;
        }
        if (whatToFind.compareTo(objects.get(left)) < 0 || objects.get(right).compareTo(whatToFind) < 0) {
            return -1;
        }
        if (!whatToFind.equals(objects.get(right))) ** GOTO lbl12
        return right;
lbl-1000:
        // 1 sources

        {
            middle = (left + right) / 2;
            if (whatToFind.compareTo(objects.get(middle)) < 0) {
                right = middle;
                continue;
            }
            left = middle;
lbl12:
            // 3 sources

            ** while (right - left > 1)
        }
lbl13:
        // 1 sources

        if (whatToFind.equals(objects.get(left))) {
            return left;
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int binarySearch(List<T> objects, T whatToFind) {
        return Search.binarySearch(objects, whatToFind, 0, objects.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Comparable<? super T>> int binarySearch(List<T> objects, T whatToFind, int left, int right) {
        if (left > right) {
            return -1;
        }
        if (whatToFind.compareTo(objects.get(left)) < 0 || ((Comparable)objects.get(right)).compareTo(whatToFind) < 0) {
            return -1;
        }
        if (whatToFind.compareTo(objects.get(right)) != 0) ** GOTO lbl12
        return right;
lbl-1000:
        // 1 sources

        {
            middle = (left + right) / 2;
            if (whatToFind.compareTo(objects.get(middle)) < 0) {
                right = middle;
                continue;
            }
            left = middle;
lbl12:
            // 3 sources

            ** while (right - left > 1)
        }
lbl13:
        // 1 sources

        if (whatToFind.compareTo(objects.get(left)) == 0) {
            return left;
        }
        return -1;
    }

    public static int leftNearest(int[] arr, int whatToFind) {
        return Search.leftNearest(arr, whatToFind, 0, arr.length - 1);
    }

    public static int leftNearest(int[] arr, int whatToFind, int first, int last) {
        if (arr == null || arr.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(arr, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) > first) {
            return index - 1;
        }
        return -1;
    }

    public static int leftNearest(double[] arr, double whatToFind) {
        return Search.leftNearest(arr, whatToFind, 0, arr.length - 1);
    }

    public static int leftNearest(double[] arr, double whatToFind, int first, int last) {
        if (arr == null || arr.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(arr, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) > first) {
            return index - 1;
        }
        return -1;
    }

    public static int leftNearest(DoubleArray arr, double whatToFind) {
        return Search.leftNearest(arr, whatToFind, 0, arr.size() - 1);
    }

    public static int leftNearest(DoubleArray arr, double whatToFind, int first, int last) {
        if (arr == null || arr.size() == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        if (whatToFind < arr.element(first)) {
            return -1;
        }
        int right = last;
        if (arr.element(right) < whatToFind || arr.element(right) == whatToFind) {
            return right;
        }
        int left = first;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (whatToFind < arr.element(middle)) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return left;
    }

    public static int leftNearest(Object[] array, Object whatToFind) {
        return Search.leftNearest(array, whatToFind, 0, array.length - 1);
    }

    public static int leftNearest(Object[] array, Object whatToFind, int first, int last) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(array, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) > first) {
            return index - 1;
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int leftNearest(List<T> list, T whatToFind) {
        return Search.leftNearest(list, whatToFind, 0, list.size() - 1);
    }

    public static <T extends Comparable<? super T>> int leftNearest(List<T> list, T whatToFind, int first, int last) {
        if (list == null || list.size() == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        if (whatToFind.compareTo(list.get(first)) < 0) {
            return -1;
        }
        int right = last;
        if (((Comparable)list.get(right)).compareTo(whatToFind) <= 0) {
            return right;
        }
        int left = first;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (whatToFind.compareTo(list.get(middle)) < 0) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return left;
    }

    public static int rightNearest(int[] array, int whatToFind) {
        return Search.rightNearest(array, whatToFind, 0, array.length - 1);
    }

    public static int rightNearest(int[] array, int whatToFind, int first, int last) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(array, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) < last + 1) {
            return index;
        }
        return -1;
    }

    public static int rightNearest(double[] arr, double whatToFind) {
        return Search.rightNearest(arr, whatToFind, 0, arr.length - 1);
    }

    public static int rightNearest(double[] arr, double whatToFind, int first, int last) {
        if (arr == null || arr.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(arr, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) < last + 1) {
            return index;
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int rightNearest(List<T> list, T whatToFind) {
        return Search.rightNearest(list, whatToFind, 0, list.size() - 1);
    }

    public static <T extends Comparable<? super T>> int rightNearest(List<T> list, T whatToFind, int first, int last) {
        if (list == null || list.size() == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int right = last;
        if (((Comparable)list.get(right)).compareTo(whatToFind) < 0) {
            return -1;
        }
        if (whatToFind.compareTo(list.get(first)) <= 0) {
            return first;
        }
        int left = first;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (((Comparable)list.get(middle)).compareTo(whatToFind) < 0) {
                left = middle;
                continue;
            }
            right = middle;
        }
        return right;
    }

    public static int rightNearest(Object[] array, Object whatToFind) {
        return Search.leftNearest(array, whatToFind, 0, array.length - 1);
    }

    public static int rightNearest(Object[] array, Object whatToFind, int first, int last) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int index = Arrays.binarySearch(array, first, last + 1, whatToFind);
        if (index >= 0) {
            return index;
        }
        if ((index = -(index + 1)) < last + 1) {
            return index;
        }
        return -1;
    }

    public static int rightNearest(List<String> list, String whatToFind) {
        return Search.rightNearest(list, whatToFind, 0, list.size() - 1);
    }

    public static int rightNearest(List<String> list, String whatToFind, int first, int last) {
        if (list == null || list.size() == 0) {
            return -1;
        }
        if (first > last) {
            return -1;
        }
        int right = last;
        if (list.get(right).compareTo(whatToFind) < 0) {
            return -1;
        }
        if (whatToFind.compareTo(list.get(first)) <= 0) {
            return first;
        }
        int left = first;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (whatToFind.compareTo(list.get(middle)) < 0) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return right;
    }

    public static int closest(double[] arr, double what) {
        return Search.closest(arr, what, 0, arr.length - 1);
    }

    public static int closest(double[] arr, double what, int first, int last) {
        int index = Search.leftNearest(arr, what, first, last);
        if (index >= 0) {
            if (index < last && arr[index + 1] - what < what - arr[index]) {
                ++index;
            }
        } else if (first <= last) {
            index = first;
        }
        return index;
    }

    public static int closest(DoubleArray arr, double what) {
        return Search.closest(arr, what, 0, arr.size() - 1);
    }

    public static int closest(DoubleArray arr, double what, int first, int last) {
        int index = Search.leftNearest(arr, what, first, last);
        if (index >= 0) {
            if (index < last && arr.element(index + 1) - what < what - arr.element(index)) {
                ++index;
            }
        } else if (first <= last) {
            index = first;
        }
        return index;
    }

    public static <T extends OrderedMetricable<T>> int closest(T[] objects, T what) {
        return Search.closest(objects, what, (int)0, (int)(objects.length - 1));
    }

    public static <T extends OrderedMetricable<T>> int closest(T[] objects, T what, int first, int last) {
        int index = Search.leftNearest(objects, what, first, last);
        if (index >= 0) {
            if (index < last && objects[index + 1].dist(what) < objects[index].dist(what)) {
                ++index;
            }
        } else if (first <= last) {
            index = first;
        }
        return index;
    }

    public static <T extends OrderedMetricable<T>> int closest(List<T> objects, T what) {
        return Search.closest(objects, what, 0, objects.size() - 1);
    }

    public static <T extends OrderedMetricable<T>> int closest(List<T> objects, T what, int first, int last) {
        int index = Search.leftNearest(objects, what, first, last);
        if (index >= 0) {
            if (index < last && ((OrderedMetricable)objects.get(index + 1)).dist(what) < ((OrderedMetricable)objects.get(index)).dist(what)) {
                ++index;
            }
        } else if (first <= last) {
            index = first;
        }
        return index;
    }

    public static <T extends TimeOrderedMetric> int closest(List<T> objects, T what) {
        return Search.closest(objects, what, 0, objects.size() - 1);
    }

    public static <T extends TimeOrderedMetric> int closest(List<T> objects, T what, int first, int last) {
        int index = Search.leftNearest(objects, what, first, last);
        if (index >= 0) {
            if (index < last && ((TimeOrderedMetric)objects.get(index + 1)).dist(what) < ((TimeOrderedMetric)objects.get(index)).dist(what)) {
                ++index;
            }
        } else if (first <= last) {
            index = first;
        }
        return index;
    }

    public static long searchBack(byte[] what, String filename, byte[] buffer) {
        return Search.searchBack(what, filename, buffer, -1L);
    }

    public static long searchBack(byte[] what, String filename, byte[] buffer, long maxOffsetFromEnd) {
        long offset;
        block14: {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer is null");
            }
            if (buffer.length < what.length) {
                throw new IllegalArgumentException("buffer.length < what.length");
            }
            offset = -1L;
            FileRW file = null;
            try {
                try {
                    file = new FileRW(filename, "r");
                    offset = Search.searchBack(what, file, buffer, -1L);
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                    if (file == null) break block14;
                    try {
                        file.close();
                    }
                    catch (IOException ex2) {
                        Console.printThreadStackTrace(ex2);
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
        }
        return offset;
    }

    public static long searchBack(byte[] what, FileRW file, byte[] buffer, long maxOffsetFromEnd) throws IOException {
        long startPos;
        int numberOfBytesToRead;
        long offset = -1L;
        long pos = file.getFilePointer();
        long minOffset = 0L;
        if (maxOffsetFromEnd >= 0L) {
            minOffset = Math.max(pos - 1L - maxOffsetFromEnd, 0L);
        }
        if ((numberOfBytesToRead = (int)(pos - (startPos = Math.max(pos - (long)buffer.length, minOffset)))) <= what.length) {
            return -1L;
        }
        int tailLength = 0;
        while (true) {
            file.seek(startPos);
            file.read(buffer, 0, numberOfBytesToRead);
            int off = Search.searchBack(what, buffer, numberOfBytesToRead + tailLength);
            if (off >= 0) {
                offset = file.getFilePointer() - (long)numberOfBytesToRead + (long)off;
                break;
            }
            if (startPos == minOffset) break;
            tailLength = what.length;
            long nextPos = Math.max(startPos - (long)buffer.length + (long)tailLength, minOffset);
            numberOfBytesToRead = (int)(startPos - nextPos);
            if (numberOfBytesToRead + tailLength < buffer.length) {
                int i = 0;
                while (i < what.length - 1) {
                    buffer[numberOfBytesToRead + i] = buffer[buffer.length - what.length + i];
                    ++i;
                }
            }
            startPos = nextPos;
        }
        return offset;
    }

    public static int searchBack(byte[] what, byte[] searchBuffer, int length) {
        int first = what.length - 1;
        int i = length - 1;
        while (i >= first) {
            boolean found = true;
            int k = i - what.length + 1;
            int j = 0;
            while (j < what.length) {
                if (searchBuffer[k + j] != what[j]) {
                    found = false;
                    break;
                }
                ++j;
            }
            if (found) {
                return k;
            }
            --i;
        }
        return -1;
    }

    public static int search(byte[] what, byte[] searchBuffer) {
        return Search.search(what, searchBuffer, 0, searchBuffer.length);
    }

    public static int search(byte[] what, byte[] searchBuffer, int start, int length) {
        if (start < 0 || length < 0 || start + length > searchBuffer.length) {
            throw new IllegalArgumentException("some of the arguments, start or length, or their combination is illegal");
        }
        int i = start;
        while (i <= start + length - what.length) {
            boolean found = true;
            int j = 0;
            while (j < what.length) {
                if (searchBuffer[i + j] != what[j]) {
                    found = false;
                    break;
                }
                ++j;
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

