/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R3;

public class SphereMath {
    private final double radius;
    private final double radius2;
    private final double minDotProduct;
    private final double maxDotProduct;

    public SphereMath() {
        this(1.0);
    }

    public SphereMath(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius <= 0");
        }
        this.radius = radius;
        this.radius2 = radius * radius;
        this.minDotProduct = -0.9999 * this.radius2;
        this.maxDotProduct = 0.9999 * this.radius2;
    }

    public double angle_pDeg(double theta1_deg, double phi1_deg, double theta2_deg, double phi2_deg) {
        return Math.toDegrees(this.angle_pRad(Math.toRadians(theta1_deg), Math.toRadians(phi1_deg), Math.toRadians(theta2_deg), Math.toRadians(phi2_deg)));
    }

    public double angle_pRad(double theta1_rad, double phi1_rad, double theta2_rad, double phi2_rad) {
        return this.distance_pRad(theta1_rad, phi1_rad, theta2_rad, phi2_rad) / this.radius;
    }

    public double distance_pDeg(double theta1_deg, double phi1_deg, double theta2_deg, double phi2_deg) {
        return this.distance_pRad(Math.toRadians(theta1_deg), Math.toRadians(phi1_deg), Math.toRadians(theta2_deg), Math.toRadians(phi2_deg));
    }

    public double distance_pRad(double theta1_rad, double phi1_rad, double theta2_rad, double phi2_rad) {
        SphereMath.checkSphericalCoords(theta1_rad, phi1_rad);
        SphereMath.checkSphericalCoords(theta2_rad, phi2_rad);
        R3 v1 = this.toDecartes(theta1_rad, phi1_rad);
        R3 v2 = this.toDecartes(theta2_rad, phi2_rad);
        double dotProduct = R3.dotProduct(v1, v2);
        if (dotProduct < this.minDotProduct) {
            return this.radius * Math.PI;
        }
        if (dotProduct > this.maxDotProduct) {
            return 0.0;
        }
        return this.radius * Math.acos(dotProduct / this.radius2);
    }

    public double[] midpoint_pDeg(double theta1_deg, double phi1_deg, double theta2_deg, double phi2_deg) {
        double[] result_rad = this.midpoint_pRad(Math.toRadians(theta1_deg), Math.toRadians(phi1_deg), Math.toRadians(theta2_deg), Math.toRadians(phi2_deg));
        if (result_rad != null) {
            return new double[]{Math.toDegrees(result_rad[0]), Math.toDegrees(result_rad[1])};
        }
        return null;
    }

    public double[] midpoint_pRad(double theta1_rad, double phi1_rad, double theta2_rad, double phi2_rad) {
        SphereMath.checkSphericalCoords(theta1_rad, phi1_rad);
        SphereMath.checkSphericalCoords(theta2_rad, phi2_rad);
        R3 v = this.toDecartes(theta1_rad, phi1_rad);
        v.add(this.toDecartes(theta2_rad, phi2_rad));
        double length = v.length();
        if (length < 1.0E-6) {
            return null;
        }
        double theta_rad = Math.atan2(v.getY(), v.getX());
        if (theta_rad < 0.0) {
            theta_rad += Math.PI * 2;
        } else if (theta_rad >= Math.PI * 2) {
            theta_rad = 0.0;
        }
        double cos = v.getZ() / length;
        if (cos < -1.0) {
            cos = -1.0;
        } else if (cos > 1.0) {
            cos = 1.0;
        }
        double phi_rad = Math.acos(cos);
        return new double[]{theta_rad, phi_rad};
    }

    public R3 toDecartes(double theta_rad, double phi_rad) {
        SphereMath.checkSphericalCoords(theta_rad, phi_rad);
        double x = this.radius * Math.cos(theta_rad) * Math.sin(phi_rad);
        double y = this.radius * Math.sin(theta_rad) * Math.sin(phi_rad);
        double z = this.radius * Math.cos(phi_rad);
        return new R3(x, y, z);
    }

    private static void checkSphericalCoords(double theta_rad, double phi_rad) {
        assert (theta_rad >= 0.0 && theta_rad <= Math.PI * 2);
        assert (theta_rad >= 0.0 && theta_rad <= Math.PI * 2);
    }
}

