/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.multithread;

import edu.uml.lgdc.datatype.CIOObjBuffer;
import edu.uml.lgdc.multithread.Semaphore;

public class MSQueue {
    private static final int MAX_QUEUE_SIZE = 10;
    private static final int WAIT_MILLISEC = 0;
    private CIOObjBuffer buffer;
    private int waitMillisec = 0;
    private Semaphore availableSpaceCount;
    private Semaphore availableMessageCount;

    public MSQueue() {
        this(10);
    }

    public MSQueue(int maxQueueSize) {
        this(maxQueueSize, 0);
    }

    public MSQueue(int maxQueueSize, int waitMillisec) {
        if (maxQueueSize <= 0) {
            throw new IllegalArgumentException("Maximum size of queue should be greater than 0");
        }
        this.setWaitMillisec(waitMillisec);
        this.buffer = new CIOObjBuffer(maxQueueSize);
        this.availableSpaceCount = new Semaphore(maxQueueSize);
        this.availableMessageCount = new Semaphore(0);
    }

    public Object pend() throws InterruptedException {
        return this.pend(0);
    }

    public Object pend(int waitMillisec) throws InterruptedException {
        if (waitMillisec < 0) {
            throw new IllegalArgumentException("waitMillisec < 0");
        }
        Object object = null;
        if (this.availableMessageCount.pend(waitMillisec)) {
            object = this.buffer.read();
            this.availableSpaceCount.post();
        }
        return object;
    }

    public boolean post(Object object) throws InterruptedException {
        return this.post(object, this.waitMillisec);
    }

    public boolean post(Object object, int waitMillisec) throws InterruptedException {
        if (waitMillisec < 0) {
            throw new IllegalArgumentException("waitMillisec < 0");
        }
        if (!this.availableSpaceCount.pend(waitMillisec)) {
            return false;
        }
        this.buffer.write(object);
        this.availableMessageCount.post();
        return true;
    }

    public boolean isFull() {
        return this.buffer.isFull();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public synchronized int howMany() {
        return this.buffer.howMany();
    }

    public boolean postUrgent(Object object) throws InterruptedException {
        return this.postUrgent(object, this.waitMillisec);
    }

    public boolean postUrgent(Object object, int waitMillisec) throws InterruptedException {
        if (!this.availableSpaceCount.pend(waitMillisec)) {
            return false;
        }
        this.buffer.writeUrgent(object);
        this.availableMessageCount.post();
        return true;
    }

    public boolean postToHead(Object object) throws InterruptedException {
        return this.postToHead(object, this.waitMillisec);
    }

    public boolean postToHead(Object object, int waitMillisec) throws InterruptedException {
        if (!this.availableSpaceCount.pend(waitMillisec)) {
            return false;
        }
        this.buffer.writeToHead(object);
        this.availableMessageCount.post();
        return true;
    }

    public void setWaitMillisec(int waitMillisec) {
        if (waitMillisec < 0) {
            throw new IllegalArgumentException("waitMillisec < 0");
        }
        this.waitMillisec = waitMillisec;
    }
}

