/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.multithread;

public class Semaphore {
    protected int counter;

    public Semaphore(int counter) {
        this.counter = counter;
    }

    public synchronized void post() {
        ++this.counter;
        this.notify();
    }

    public synchronized boolean pend() throws InterruptedException {
        this.waitCountNotZero();
        return this.decreaseCounter();
    }

    public synchronized boolean pend(int milliSec) throws InterruptedException {
        if (milliSec < 0) {
            throw new IllegalArgumentException("milliSec should be >= 0");
        }
        if (milliSec == 0) {
            return this.pend();
        }
        long start = System.currentTimeMillis();
        long end = start + (long)milliSec;
        while (this.counter <= 0 && end - start > 0L) {
            this.wait(end - start);
            start = System.currentTimeMillis();
        }
        return this.decreaseCounter();
    }

    public synchronized boolean pend(int milliSec, int nanoSec) throws InterruptedException {
        if (milliSec < 0) {
            throw new IllegalArgumentException("milliSec should be >= 0");
        }
        if (nanoSec < 0) {
            throw new IllegalArgumentException("nanoSec should be >= 0");
        }
        if (milliSec == 0) {
            if (nanoSec == 0) {
                return this.pend();
            }
            return this.pend(1);
        }
        if (nanoSec < 500) {
            return this.pend(milliSec);
        }
        return this.pend(milliSec + 1);
    }

    public synchronized void waitCountNotZero() throws InterruptedException {
        while (this.counter <= 0) {
            this.wait();
        }
    }

    public synchronized void clear() {
        this.counter = 0;
    }

    public synchronized void set(int value) {
        this.counter = value;
        if (value > 0) {
            if (value == 1) {
                this.notify();
            } else {
                this.notifyAll();
            }
        }
    }

    private boolean decreaseCounter() {
        if (this.counter > 0) {
            --this.counter;
            return true;
        }
        return false;
    }

    public int ask() {
        return this.counter;
    }
}

