/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.ControlPar;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TimeZone;

public abstract class Console {
    public static final String TIME_FORMAT = "yyyy.MM.dd HH:mm:ss.SSS";
    public static final int TIME_STR_LEN = "yyyy.MM.dd HH:mm:ss.SSS".length();
    public static final String MSGERR_PREFIX_START = "*** ";
    public static final String MSGERR_PREFIX_END = "ERROR: ";
    public static final String MSGERR_PREFIX = "*** ERROR: ";
    public static final String MSGWARN_PREFIX = "+++ WARNING: ";
    private static final String EMPTY_STRING = "";
    private static final String PREV_LOG_SUFFIX = "_prev";
    private static final int MB = 0x100000;
    protected static byte[] RESERVED_SPACE;
    protected static Object printSync;
    protected ControlPar controlPar = null;
    private String line = "";

    static {
        printSync = new Object();
    }

    public static void releaseReservedSpace() {
        if (RESERVED_SPACE != null) {
            RESERVED_SPACE = null;
            System.runFinalization();
            System.gc();
        }
    }

    public final void terminate(final Throwable error, final TimeScale time) {
        final Thread threadInError = Thread.currentThread();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Console.releaseReservedSpace();
                Console.this.crashErrorReport(threadInError, error, time);
                System.exit(1);
            }
        }, "CrashReport");
        thread.setPriority(10);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void crashErrorReport(Thread crashedThread, Throwable error, TimeScale time) {
    }

    public String getCrashReportFilename(String threadName, TimeScale time) {
        return "fe_" + CommonConst.getApplicationName() + "_" + FC.padLeft(EMPTY_STRING + (time.get(2) + 1), 2, '0') + FC.padLeft(EMPTY_STRING + time.get(5), 2, '0') + FC.padLeft(EMPTY_STRING + time.get(11), 2, '0') + "_" + threadName;
    }

    public void print(String str) {
        String[] result;
        if (str.length() == 0) {
            return;
        }
        do {
            result = StrUtil.cutLine(str);
            str = result[1];
            if (result[0] != null) {
                this.addToLine(result[0]);
                this.logIt_impl(this.line, true, false);
                this.line = EMPTY_STRING;
                continue;
            }
            if (result[1].length() <= 0) continue;
            this.addToLine(result[1]);
        } while (result[0] != null && str.length() > 0);
    }

    private void addToLine(String str) {
        this.line = this.line == EMPTY_STRING ? str : String.valueOf(this.line) + str;
    }

    public void logAsIs(String message) {
        this.logIt(message, false);
    }

    public void printStackTrace(Throwable e) {
        e.printStackTrace();
        if (this.controlPar.logOutput != null) {
            e.printStackTrace(this.controlPar.logOutput);
        }
    }

    public void logIt(String message) {
        this.logIt(message, true, true);
    }

    public void logIt(String message, boolean embedTime) {
        this.logIt(message, embedTime, true);
    }

    public void logIt(String message, boolean embedTime, boolean writeToStandardOutput) {
        this.logIt_impl(message, embedTime, writeToStandardOutput);
    }

    private void logIt_impl(String message, boolean embedTime, boolean writeToStandardOutput) {
        if (embedTime) {
            message = TimeScale.prefixWithLocalTime(message, "  ");
        }
        if (writeToStandardOutput) {
            System.out.println(message);
        }
        if (this.controlPar.logOutput != null) {
            this.controlPar.logOutput.println(message);
        }
        if (!this.controlPar.isConsoleMode()) {
            this.printToScreen(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToScreen(String message) {
        if (this.controlPar.taLogOutput != null) {
            Object object = this.controlPar.taLogOutputLock;
            synchronized (object) {
                this.controlPar.taLogOutput.append(String.valueOf(message) + "\n");
            }
        }
    }

    public static void printThreadStackTrace(Throwable e) {
        StackTraceElement[] ste = e.getStackTrace();
        String[] lines = new String[ste.length + 1];
        lines[0] = e.toString();
        int i = 0;
        while (i < ste.length) {
            lines[i + 1] = ste[i].toString();
            ++i;
        }
        Console.showError(lines);
        if (e.getCause() != null) {
            Console.showError("Caused by:");
            Console.printThreadStackTrace(e.getCause());
        }
    }

    public static void showMsg(String s) {
        Console.showMsg(s, false);
    }

    public static void showMsg(String[] lines) {
        Console.showMsg(lines, false);
    }

    public static void showError(String s, String where) {
        Console.showMsg(MSGERR_PREFIX_START + where + " " + MSGERR_PREFIX_END + s, true);
    }

    public static void showError(String s) {
        Console.showMsg(MSGERR_PREFIX + s, true);
    }

    public static void showError(String[] lines) {
        if (lines.length > 0) {
            lines[0] = MSGERR_PREFIX + lines[0];
        }
        Console.showMsg(lines, true);
    }

    public static void showWarn(String s) {
        Console.showMsg(MSGWARN_PREFIX + s);
    }

    public static void showWarn(String[] lines) {
        if (lines.length > 0) {
            lines[0] = MSGWARN_PREFIX + lines[0];
        }
        Console.showMsg(lines, false);
    }

    public static void showMsg(String s, boolean err) {
        Console.showMsg(StrUtil.textToLines(s), err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showMsg(String[] lines, boolean err) {
        Object object = printSync;
        synchronized (object) {
            PrintStream ps = err ? System.err : System.out;
            String timeStr = new TimeScale(TimeZone.getDefault()).toFormatUT(TIME_FORMAT);
            if (lines.length > 0) {
                String tmp = String.valueOf(timeStr) + ": " + lines[0];
                ps.println(tmp);
                int i = 1;
                while (i < lines.length) {
                    tmp = String.valueOf("                                                                                                                            ".substring(0, 2)) + lines[i];
                    ps.println(tmp);
                    ++i;
                }
            } else {
                String tmp = String.valueOf(timeStr) + ": ";
                ps.println(tmp);
            }
        }
    }

    public static String getMsgAsString(String[] lines) {
        String timeStr = new TimeScale(TimeZone.getDefault()).toFormatUT(TIME_FORMAT);
        String output = EMPTY_STRING;
        if (lines.length > 0) {
            String tmp = String.valueOf(timeStr) + ": " + lines[0];
            output = String.valueOf(output) + tmp;
            int i = 1;
            while (i < lines.length) {
                tmp = String.valueOf("                                                                                                                            ".substring(0, 2)) + lines[i];
                output = String.valueOf(output) + tmp;
                ++i;
            }
        } else {
            String tmp = String.valueOf(timeStr) + ": ";
            output = String.valueOf(output) + tmp;
        }
        return output;
    }

    public static String getErrorAsString(String[] lines) {
        if (lines.length > 0) {
            lines[0] = MSGERR_PREFIX + lines[0];
        }
        return Console.getMsgAsString(lines);
    }

    public static String getWarnAsString(String[] lines) {
        if (lines.length > 0) {
            lines[0] = MSGWARN_PREFIX + lines[0];
        }
        return Console.getMsgAsString(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showMsgAsIs(String s, boolean err) {
        Object object = printSync;
        synchronized (object) {
            (err ? System.err : System.out).print(s);
        }
    }

    public static void showMsgLineAsIs(String s, boolean err) {
        PrintStream ps = err ? System.err : System.out;
        ps.println(s);
    }

    public static void printThreadStackTrace(Throwable e, FileRW fileRW) throws IOException {
        StackTraceElement[] ste = e.getStackTrace();
        String[] lines = new String[ste.length + 1];
        lines[0] = e.toString();
        int i = 0;
        while (i < ste.length) {
            lines[i + 1] = ste[i].toString();
            ++i;
        }
        Console.showError(lines, fileRW);
        if (e.getCause() != null) {
            Console.showError("Caused by:", fileRW);
            Console.printThreadStackTrace(e.getCause(), fileRW);
        }
    }

    public static String getErrMsgPrefix() {
        return String.valueOf(new TimeScale(TimeZone.getDefault()).toFormatUT(TIME_FORMAT)) + ": " + MSGERR_PREFIX;
    }

    public static void showError(String[] lines, FileRW fileRW) throws IOException {
        if (lines.length > 0) {
            lines[0] = MSGERR_PREFIX + lines[0];
        }
        Console.showMsg(lines, fileRW);
    }

    public static void showMsg(String s, FileRW fileRW) throws IOException {
        Console.showMsg(StrUtil.textToLines(s), fileRW);
    }

    public static void showError(String s, FileRW fileRW) throws IOException {
        Console.showError(StrUtil.textToLines(s), fileRW);
    }

    public static void showMsg(String[] lines, FileRW fileRW) throws IOException {
        Console.writeMsg(new TimeScale(TimeZone.getDefault()), lines, fileRW);
    }

    public static void writeMsg(TimeScale time, String s, FileRW fileRW) throws IOException {
        Console.writeMsg(time, StrUtil.textToLines(s), fileRW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMsg(TimeScale time, String[] lines, FileRW fileRW) throws IOException {
        Object object = printSync;
        synchronized (object) {
            String timeStr = time.toFormatUT(TIME_FORMAT);
            if (lines.length > 0) {
                fileRW.write(String.valueOf(timeStr) + ": " + lines[0] + "\n");
                int i = 1;
                while (i < lines.length) {
                    fileRW.write(String.valueOf("                                                                                                                            ".substring(0, 2)) + lines[i] + "\n");
                    ++i;
                }
            } else {
                fileRW.write(String.valueOf(timeStr) + ":\n");
            }
        }
    }

    public static void writeMsgNoEx(TimeScale time, String s, FileRW fileRW) {
        Console.writeMsgNoEx(time, StrUtil.textToLines(s), fileRW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMsgNoEx(TimeScale time, String[] lines, FileRW fileRW) {
        Object object = printSync;
        synchronized (object) {
            String timeStr = time != null ? time.toFormatUT(TIME_FORMAT) : FC.padRight("UNKNOWN_TIME", TIME_FORMAT.length());
            try {
                if (lines.length > 0) {
                    fileRW.write(String.valueOf(timeStr) + ": " + lines[0] + "\n");
                    int i = 1;
                    while (i < lines.length) {
                        fileRW.write(String.valueOf("                                                                                                                            ".substring(0, 2)) + lines[i] + "\n");
                        ++i;
                    }
                } else {
                    fileRW.write(String.valueOf(timeStr) + ":\n");
                }
            }
            catch (IOException e) {
                Console.printThreadStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMsgNoEx(String s, FileRW fileRW) {
        Object object = printSync;
        synchronized (object) {
            try {
                fileRW.write(String.valueOf(s) + "\n");
            }
            catch (IOException e) {
                Console.printThreadStackTrace(e);
            }
        }
    }

    public static String getStampedMsgLine(String line) {
        StringBuilder strBuf = new StringBuilder(200);
        strBuf.append(new TimeScale(TimeZone.getDefault()).toFormatUT(TIME_FORMAT)).append(": ").append(line).append(line).append("\n");
        return strBuf.toString();
    }

    public static String getStampedErrLine(String line) {
        StringBuilder strBuf = new StringBuilder(200);
        strBuf.append(new TimeScale(TimeZone.getDefault()).toFormatUT(TIME_FORMAT)).append(": ").append(MSGERR_PREFIX).append(line).append(line).append("\n");
        return strBuf.toString();
    }

    public static void prepareLogFile(String logFilename) {
        Console.prepareLogFile(logFilename, 1L);
    }

    public static void prepareLogFile(String logFilename, long maxSize_MB) {
        File logFile;
        String logExt = FileRW.getExt(logFilename);
        String logFileBasename = FileRW.getNameButExt(logFilename);
        if (logExt.length() > 0) {
            logExt = "." + logExt;
        }
        if ((logFile = new File(logFilename)).length() > maxSize_MB * 0x100000L) {
            File prevLogFile = new File(String.valueOf(logFileBasename) + PREV_LOG_SUFFIX + logExt);
            prevLogFile.delete();
            logFile.renameTo(prevLogFile);
        }
    }

    public static void redirectToFile(String filename, boolean append, boolean autoflush) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filename, append);
            PrintStream ps = new PrintStream(os, autoflush);
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (IOException e) {
            Console.showError(e.toString());
        }
    }
}

