/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.format.StrUtil;

public class Version {
    private String versionString;
    private int[] numbers = new int[3];
    private int qtyOfGroups;
    private boolean betaVersion;
    private int betaNumber;

    private Version() {
    }

    public String getString() {
        return this.versionString;
    }

    public int getMajorNumber() {
        return this.numbers[0];
    }

    public int getMinorNumber() {
        return this.numbers[1];
    }

    public int getBuildNumber() {
        return this.numbers[2];
    }

    public int getQtyOfGroups() {
        return this.qtyOfGroups;
    }

    public boolean isBetaVersion() {
        return this.betaVersion;
    }

    public int getBetaNumber() {
        return this.betaNumber;
    }

    public boolean before(Object obj) {
        return this.compare(obj) < 0;
    }

    public boolean equiv(Object obj) {
        return this.compare(obj) == 0;
    }

    public int compare(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj is null");
        }
        if (!(obj instanceof Version)) {
            throw new IllegalArgumentException("obj is not instance of class Version");
        }
        Version version = (Version)obj;
        int minNumberOfGroups = Math.min(this.qtyOfGroups, version.qtyOfGroups);
        boolean notEqualed = false;
        int i = 0;
        while (i < minNumberOfGroups) {
            if (this.numbers[i] > version.numbers[i]) {
                return 1;
            }
            if (this.numbers[i] < version.numbers[i]) {
                notEqualed = true;
            }
            ++i;
        }
        if (this.qtyOfGroups > version.qtyOfGroups) {
            return 1;
        }
        if (this.qtyOfGroups < version.qtyOfGroups || notEqualed) {
            return -1;
        }
        if (!this.betaVersion) {
            if (!version.betaVersion) {
                return 0;
            }
            return 1;
        }
        if (!version.betaVersion) {
            return -1;
        }
        if (this.betaNumber < version.betaNumber) {
            return -1;
        }
        if (this.betaNumber > version.betaNumber) {
            return 1;
        }
        return 0;
    }

    public static Version getVersion(String str) {
        Version version = new Version();
        if ((str = str.trim()).length() != 0) {
            int pos1 = 0;
            int groupIndex = 0;
            while (pos1 < str.length()) {
                int pos2;
                if (groupIndex == 3 || (pos2 = str.indexOf(46, pos1)) == pos1) break;
                if (pos2 < 0) {
                    pos2 = str.length();
                }
                if (pos2 < str.length()) {
                    if (!StrUtil.isOnlyDigits(str.substring(pos1, pos2))) break;
                    version.numbers[groupIndex++] = Integer.parseInt(str.substring(pos1, pos2));
                    pos1 = pos2 + 1;
                    continue;
                }
                if (StrUtil.isOnlyDigits(str.substring(pos1, pos2))) {
                    version.numbers[groupIndex++] = Integer.parseInt(str.substring(pos1, pos2));
                    pos1 = pos2;
                    break;
                }
                pos2 = str.indexOf(98, pos1);
                if (pos2 == pos1 || pos2 < 0 || !StrUtil.isOnlyDigits(str.substring(pos1, pos2))) break;
                version.numbers[groupIndex++] = Integer.parseInt(str.substring(pos1, pos2));
                version.betaVersion = true;
                if (pos2 == str.length() - 1) {
                    pos1 = str.length();
                    break;
                }
                if (!StrUtil.isOnlyDigits(str.substring(pos2 + 1))) break;
                version.betaNumber = Integer.parseInt(str.substring(pos2 + 1));
                pos1 = str.length();
                break;
            }
            if (pos1 >= str.length()) {
                version.versionString = str;
                version.qtyOfGroups = groupIndex;
            } else {
                version = null;
            }
        }
        return version;
    }
}

