/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.cadence;

import edu.uml.lgdc.project.cadence.Cadence;
import edu.uml.lgdc.project.cadence.CadenceAccumulator;
import edu.uml.lgdc.time.TimeScale;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractCadenceAccumulator<E>
implements CadenceAccumulator<E> {
    protected TreeSet<Integer> legalCadences_sec;
    protected final TreeMap<TimeScale, E> times = new TreeMap();
    private SortedSet<Cadence<E>> cadences;

    @Override
    public SortedSet<Cadence<E>> add(TimeScale time, E measurement) {
        Objects.requireNonNull(time);
        if (this.cadences != null) {
            throw new RuntimeException("Cadence Accumulator already calculated a cadence");
        }
        if (this.times.put(time, measurement) == null) {
            this.cadences = this.calcCadences();
            return this.cadences;
        }
        return null;
    }

    protected abstract SortedSet<Cadence<E>> calcCadences();

    @Override
    public boolean isEmpty() {
        return this.times.size() == 0;
    }

    @Override
    public void leaveWindow(TimeScale startTime, TimeScale endTime) {
        assert (startTime == null || endTime == null || !endTime.before(startTime));
        Iterator<TimeScale> iterator = this.times.keySet().iterator();
        boolean reduced = false;
        while (iterator.hasNext()) {
            TimeScale time = iterator.next();
            if (this.isInTimeWindow(time, startTime, endTime)) continue;
            iterator.remove();
            reduced = true;
        }
        if (reduced) {
            this.cadences = this.calcCadences();
        }
    }

    @Override
    public void setLegalCadences(TreeSet<Integer> legalCadences_sec) {
        Objects.requireNonNull(legalCadences_sec);
        assert (legalCadences_sec.size() > 0);
        this.legalCadences_sec = legalCadences_sec;
    }

    private boolean isInTimeWindow(TimeScale time, TimeScale startTime, TimeScale endTime) {
        if (startTime != null) {
            if (endTime != null) {
                return !time.before(startTime) && !endTime.before(time);
            }
            return !time.before(startTime);
        }
        if (endTime != null) {
            return !endTime.before(time);
        }
        return true;
    }
}

