/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.cadence;

import edu.uml.lgdc.project.cadence.AbstractCadenceAccumulator;
import edu.uml.lgdc.project.cadence.Cadence;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Max8PointCadenceAccumulator<E>
extends AbstractCadenceAccumulator<E> {
    @Override
    protected SortedSet<Cadence<E>> calcCadences() {
        if (this.legalCadences_sec == null) {
            throw new RuntimeException("Set of legal cadence periods was not set");
        }
        int size = this.times.size();
        if (size < 3) {
            return null;
        }
        TimeScale[] timeArr = this.times.keySet().toArray(new TimeScale[0]);
        if (size == 3) {
            return this.handle(timeArr, a -> this.getCadence3_sec(a, 0, 1));
        }
        if (size == 4) {
            return this.handle(timeArr, a -> this.getCadence4_sec(a, 0, 1));
        }
        if (size == 5) {
            return this.handle(timeArr, a -> this.getCadence5_sec(a, 0, 1));
        }
        if (size == 6) {
            return this.handle(timeArr, a -> this.getCadence6_sec(a, 0, 1));
        }
        if (size == 7) {
            return this.handle(timeArr, a -> this.getCadence7_sec(a, 0, 1));
        }
        if (size == 8) {
            return this.handle(timeArr, a -> this.getCadence8_sec(a, 0, 1));
        }
        this.leaveWindow(timeArr[timeArr.length - 8], timeArr[timeArr.length - 1]);
        return this.calcCadences();
    }

    private SortedSet<Cadence<E>> handle(TimeScale[] timeArr, Cadenza cadenza) {
        List<SubCadenceDesc> subCadenceDescs = cadenza.get(timeArr);
        if (subCadenceDescs != null) {
            return this.getCadences(timeArr, subCadenceDescs);
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence3_sec(TimeScale[] timeArr, int index, int step) {
        assert (timeArr.length > index + step * 2);
        double cadence0_sec = timeArr[index + step].diffIn(13, timeArr[index]);
        double cadence1_sec = timeArr[index + 2 * step].diffIn(13, timeArr[index + step]);
        if (this.isCadenceLegal(cadence0_sec) && cadence0_sec == cadence1_sec) {
            return new ArrayList<SubCadenceDesc>(Arrays.asList(new SubCadenceDesc((int)cadence0_sec, index, 3, step)));
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence4_sec(TimeScale[] timeArr, int index, int step) {
        assert (timeArr.length > index + step * 3);
        List<SubCadenceDesc> subCadenceDescs = this.getCadence3_sec(timeArr, 1, 1);
        if (subCadenceDescs != null) {
            for (SubCadenceDesc subCadenceDesc : subCadenceDescs) {
                double dist_sec = timeArr[subCadenceDesc.index].diffIn(13, timeArr[index]);
                if (dist_sec == (double)subCadenceDesc.cadence_sec) {
                    ++subCadenceDesc.qty;
                    subCadenceDesc.index -= subCadenceDesc.step;
                    break;
                }
                if (dist_sec != (double)(2 * subCadenceDesc.cadence_sec)) continue;
                ++subCadenceDesc.qty;
                subCadenceDesc.index -= subCadenceDesc.step;
                break;
            }
            return subCadenceDescs;
        }
        double cadence0_sec = timeArr[index + step].diffIn(13, timeArr[index]);
        if (this.isCadenceLegal(cadence0_sec)) {
            double cadence1_sec = timeArr[index + 2 * step].diffIn(13, timeArr[index + step]);
            double cadence2_sec = timeArr[index + 3 * step].diffIn(13, timeArr[index + 2 * step]);
            if (cadence0_sec == cadence1_sec && cadence2_sec == 2.0 * cadence0_sec) {
                return new ArrayList<SubCadenceDesc>(Arrays.asList(new SubCadenceDesc((int)cadence0_sec, index, 4, step)));
            }
            if (cadence0_sec == cadence2_sec && cadence1_sec == 2.0 * cadence0_sec) {
                return new ArrayList<SubCadenceDesc>(Arrays.asList(new SubCadenceDesc((int)cadence0_sec, index, 4, step)));
            }
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence5_sec(TimeScale[] timeArr, int index, int step) {
        assert (timeArr.length > index + step * 4);
        List<SubCadenceDesc> subCadenceDescs = this.getCadence4_sec(timeArr, 1, 1);
        if (subCadenceDescs != null) {
            for (SubCadenceDesc subCadenceDesc : subCadenceDescs) {
                double dist_sec = timeArr[subCadenceDesc.index].diffIn(13, timeArr[index]);
                if (dist_sec == (double)subCadenceDesc.cadence_sec) {
                    ++subCadenceDesc.qty;
                    subCadenceDesc.index -= subCadenceDesc.step;
                    break;
                }
                if (!this.isIdealCadence_sec(timeArr, 1, 4) || dist_sec != (double)(2 * subCadenceDesc.cadence_sec)) continue;
                ++subCadenceDesc.qty;
                subCadenceDesc.index -= subCadenceDesc.step;
                break;
            }
            return subCadenceDescs;
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence6_sec(TimeScale[] timeArr, int index, int step) {
        assert (timeArr.length > index + step * 5);
        List<SubCadenceDesc> subCadenceDescs = this.getCadence5_sec(timeArr, 1, 1);
        if (subCadenceDescs != null) {
            for (SubCadenceDesc subCadenceDesc : subCadenceDescs) {
                double dist_sec = timeArr[subCadenceDesc.index].diffIn(13, timeArr[index]);
                if (dist_sec == (double)subCadenceDesc.cadence_sec) {
                    ++subCadenceDesc.qty;
                    subCadenceDesc.index -= subCadenceDesc.step;
                    break;
                }
                if (!this.isIdealCadence_sec(timeArr, 1, 5) || dist_sec != (double)(2 * subCadenceDesc.cadence_sec)) continue;
                ++subCadenceDesc.qty;
                subCadenceDesc.index -= subCadenceDesc.step;
                break;
            }
            return subCadenceDescs;
        }
        List<SubCadenceDesc> list1 = this.getCadence3_sec(timeArr, index, 2 * step);
        List<SubCadenceDesc> list2 = this.getCadence3_sec(timeArr, index + step, 2 * step);
        if (list1 != null && list2 != null && list1.get((int)0).cadence_sec == list2.get((int)0).cadence_sec) {
            subCadenceDescs = new ArrayList<SubCadenceDesc>();
            subCadenceDescs.add(list1.get(0));
            subCadenceDescs.add(list2.get(0));
            return subCadenceDescs;
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence7_sec(TimeScale[] timeArr, int index, int step) {
        List<SubCadenceDesc> list2;
        assert (timeArr.length > index + step * 6);
        List<SubCadenceDesc> subCadenceDescs = this.getCadence6_sec(timeArr, 1, 1);
        if (subCadenceDescs != null) {
            for (SubCadenceDesc desc : subCadenceDescs) {
                double dist_sec = timeArr[desc.index].diffIn(13, timeArr[index]);
                if (dist_sec != (double)desc.cadence_sec && (dist_sec != (double)(2 * desc.cadence_sec) || timeArr[desc.index].diffIn(13, timeArr[desc.index + desc.step]) != (double)desc.cadence_sec)) continue;
                ++desc.qty;
                desc.index -= desc.step;
                break;
            }
            return subCadenceDescs;
        }
        double cadence0_sec = timeArr[index + step].diffIn(13, timeArr[index]);
        if (this.isCadenceLegal(cadence0_sec)) {
            double cadence1_sec = timeArr[index + 2 * step].diffIn(13, timeArr[index + step]);
            double cadence2_sec = timeArr[index + 3 * step].diffIn(13, timeArr[index + 2 * step]);
            double cadence3_sec = timeArr[index + 4 * step].diffIn(13, timeArr[index + 3 * step]);
            double cadence4_sec = timeArr[index + 5 * step].diffIn(13, timeArr[index + 4 * step]);
            double cadence5_sec = timeArr[index + 6 * step].diffIn(13, timeArr[index + 5 * step]);
            if (cadence1_sec == 2.0 * cadence0_sec && cadence3_sec == 2.0 * cadence0_sec && cadence2_sec == cadence0_sec && cadence4_sec == cadence0_sec && cadence5_sec == cadence0_sec || cadence1_sec == 2.0 * cadence0_sec && cadence4_sec == 2.0 * cadence0_sec && cadence2_sec == cadence0_sec && cadence3_sec == cadence0_sec && cadence5_sec == cadence0_sec || cadence1_sec == 2.0 * cadence0_sec && cadence5_sec == 2.0 * cadence0_sec && cadence2_sec == cadence0_sec && cadence3_sec == cadence0_sec && cadence4_sec == cadence0_sec || cadence2_sec == 2.0 * cadence0_sec && cadence4_sec == 2.0 * cadence0_sec && cadence1_sec == cadence0_sec && cadence3_sec == cadence0_sec && cadence5_sec == cadence0_sec || cadence2_sec == 2.0 * cadence0_sec && cadence5_sec == 2.0 * cadence0_sec && cadence1_sec == cadence0_sec && cadence3_sec == cadence0_sec && cadence4_sec == cadence0_sec || cadence3_sec == 2.0 * cadence0_sec && cadence5_sec == 2.0 * cadence0_sec && cadence1_sec == cadence0_sec && cadence2_sec == cadence0_sec && cadence4_sec == cadence0_sec) {
                return new ArrayList<SubCadenceDesc>(Arrays.asList(new SubCadenceDesc((int)cadence0_sec, index, 7, step)));
            }
        }
        List<SubCadenceDesc> list1 = this.getCadence3_sec(timeArr, index + step, 2 * step);
        List<SubCadenceDesc> list2_3 = this.getCadence3_sec(timeArr, index + 2 * step, 2 * step);
        List<SubCadenceDesc> list2_4 = this.getCadence4_sec(timeArr, index, 2 * step);
        List<SubCadenceDesc> list = list2 = list2_4 != null ? list2_4 : list2_3;
        if (list1 != null && list2 != null && list1.get((int)0).cadence_sec == list2.get((int)0).cadence_sec) {
            subCadenceDescs = new ArrayList<SubCadenceDesc>();
            subCadenceDescs.add(list1.get(0));
            subCadenceDescs.add(list2.get(0));
            return subCadenceDescs;
        }
        return null;
    }

    private List<SubCadenceDesc> getCadence8_sec(TimeScale[] timeArr, int index, int step) {
        List<SubCadenceDesc> list2;
        assert (timeArr.length > index + step * 7);
        List<SubCadenceDesc> subCadenceDescs = this.getCadence7_sec(timeArr, 1, 1);
        if (subCadenceDescs != null) {
            for (SubCadenceDesc desc : subCadenceDescs) {
                double dist_sec = timeArr[desc.index].diffIn(13, timeArr[index]);
                if (dist_sec != (double)desc.cadence_sec && (dist_sec != (double)(2 * desc.cadence_sec) || timeArr[desc.index].diffIn(13, timeArr[desc.index + desc.step]) != (double)desc.cadence_sec)) continue;
                ++desc.qty;
                desc.index -= desc.step;
                break;
            }
            return subCadenceDescs;
        }
        List<SubCadenceDesc> list1_3 = this.getCadence3_sec(timeArr, index + 2 * step, 2 * step);
        List<SubCadenceDesc> list2_3 = this.getCadence3_sec(timeArr, index + 3 * step, 2 * step);
        List<SubCadenceDesc> list1_4 = this.getCadence4_sec(timeArr, index, 2 * step);
        List<SubCadenceDesc> list2_4 = this.getCadence4_sec(timeArr, index + step, 2 * step);
        List<SubCadenceDesc> list1 = list1_4 != null ? list1_4 : list1_3;
        List<SubCadenceDesc> list = list2 = list2_4 != null ? list2_4 : list2_3;
        if (list1 != null && list2 != null && list1.get((int)0).cadence_sec == list2.get((int)0).cadence_sec) {
            subCadenceDescs = new ArrayList<SubCadenceDesc>();
            subCadenceDescs.add(list1.get(0));
            subCadenceDescs.add(list2.get(0));
            return subCadenceDescs;
        }
        return null;
    }

    private SortedSet<Cadence<E>> getCadences(TimeScale[] timeArr, List<SubCadenceDesc> subCadenceDescs) {
        TreeSet<Cadence<Cadence<E>>> cadences = new TreeSet<Cadence<Cadence<E>>>();
        for (SubCadenceDesc desc : subCadenceDescs) {
            cadences.add(new Cadence<E>(desc.cadence_sec, this.extractMap(timeArr, desc.index, desc.qty, desc.step)));
        }
        return cadences;
    }

    private boolean isIdealCadence_sec(TimeScale[] timeArr, int index, int qty) {
        return this.isIdealCadence_sec(timeArr, index, qty, 1);
    }

    private boolean isIdealCadence_sec(TimeScale[] timeArr, int index, int qty, int step) {
        assert (qty > 2);
        assert (timeArr.length > index + step * (qty - 1));
        double prevCadence = -1.0;
        int i = index;
        int j = 0;
        while (j < qty - 1) {
            double cadence = timeArr[i + step].diffIn(13, timeArr[i]);
            if (j > 0 ? cadence != prevCadence : !this.isCadenceLegal(cadence)) {
                return false;
            }
            prevCadence = cadence;
            i += step;
            ++j;
        }
        return true;
    }

    private boolean isCadenceLegal(double cadence_sec) {
        return cadence_sec == (double)((int)cadence_sec) && this.legalCadences_sec.contains((int)cadence_sec);
    }

    private TreeMap<TimeScale, E> extractMap(TimeScale[] timeArr, int index, int qty, int step) {
        TreeMap map = new TreeMap();
        int i = index;
        int j = 0;
        while (j < qty) {
            map.put(timeArr[i], this.times.get(timeArr[i]));
            i += step;
            ++j;
        }
        return map;
    }

    private static interface Cadenza {
        public List<SubCadenceDesc> get(TimeScale[] var1);
    }

    private static class SubCadenceDesc {
        int cadence_sec;
        int index;
        int qty;
        int step;

        SubCadenceDesc(int cadence_sec, int index, int qty, int step) {
            this.cadence_sec = cadence_sec;
            this.index = index;
            this.qty = qty;
            this.step = step;
        }
    }
}

