/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.cadence;

import edu.uml.lgdc.project.cadence.AbstractCadenceAccumulator;
import edu.uml.lgdc.project.cadence.Cadence;
import edu.uml.lgdc.time.TimeScale;
import java.util.SortedSet;
import java.util.TreeSet;

public class ThreePointCadenceAccumulator<E>
extends AbstractCadenceAccumulator<E> {
    @Override
    protected SortedSet<Cadence<E>> calcCadences() {
        if (this.legalCadences_sec == null) {
            throw new RuntimeException("Set of legal cadence periods was not set");
        }
        if (this.times.size() == 3) {
            TimeScale[] timeArray = this.times.keySet().toArray(new TimeScale[0]);
            double interval_1 = timeArray[1].diffIn(13, timeArray[0]);
            double interval_2 = timeArray[2].diffIn(13, timeArray[1]);
            double minCadence_sec = Math.min(interval_1, interval_2);
            double maxCadence_sec = Math.max(interval_1, interval_2);
            if (this.isCadenceLegal(minCadence_sec) && (maxCadence_sec == minCadence_sec || maxCadence_sec == 2.0 * minCadence_sec)) {
                TreeSet cadences = new TreeSet();
                cadences.add(new Cadence((int)minCadence_sec, this.times));
                return cadences;
            }
            return null;
        }
        return null;
    }

    private boolean isCadenceLegal(double cadence_sec) {
        return cadence_sec == (double)((int)cadence_sec) && this.legalCadences_sec.contains((int)cadence_sec);
    }
}

